/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.config;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.stp.StpLogic;
import com.bringspring.common.auth.config.JsbosOauthConfig;
import com.bringspring.common.auth.config.JsbosTokenConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class AuthAutoConfigration {
    @Primary
    @Bean
    @ConfigurationProperties(prefix="oauth.login")
    public SaTokenConfig getJsbosTokenConfig() {
        return new JsbosTokenConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="oauth")
    public JsbosOauthConfig getJsbosOauthConfig() {
        return new JsbosOauthConfig();
    }

    @Primary
    @Bean(value={"defaultStpLogic"})
    public StpLogic getJsbosTokenJwtLogic() {
        return new StpLogicJwtForSimple("login");
    }

    @Bean(value={"tenantStpLogic"})
    public StpLogic getJsbosTenantTokenJwtLogic() {
        return new StpLogicJwtForSimple("tenant");
    }
}

