/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.util;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.SaSessionCustomUtil;
import com.bringspring.common.model.login.BaseSystemInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantProvider.class);
    private static final long tenantTimeout = 2592000L;
    private static ThreadLocal<BaseSystemInfo> systemInfoThreadLocal = new ThreadLocal();

    public static SaSession getTenantSession(String tenantId) {
        SaSession saSession;
        if (tenantId == null) {
            tenantId = "";
        }
        if ((saSession = SaSessionCustomUtil.getSessionById((String)("tenant:" + tenantId))) != null && !((Boolean)saSession.get("init", (Object)false)).booleanValue()) {
            saSession.set("init", (Object)true);
            saSession.updateTimeout(2592000L);
        }
        return saSession;
    }

    public static void putTenantCache(String tenantId, String key, Object value) {
        SaSession saSession = TenantProvider.getTenantSession(tenantId);
        if (saSession != null) {
            saSession.set(key, value).updateTimeout(2592000L);
        }
    }

    public static <T> T getTenantCache(String tenantId, String key) {
        SaSession saSession = TenantProvider.getTenantSession(tenantId);
        if (saSession != null) {
            return (T)saSession.get(key);
        }
        return null;
    }

    public static void delTenantCache(String tenantId, String key) {
        SaSession saSession = TenantProvider.getTenantSession(tenantId);
        if (saSession != null) {
            saSession.delete(key);
        }
    }

    public static void renewTimeout(String tenantId, long timeout) {
        SaSession saSession;
        if (tenantId == null) {
            tenantId = "";
        }
        if ((saSession = TenantProvider.getTenantSession(tenantId)) != null) {
            saSession.updateTimeout(timeout);
        }
    }

    public static BaseSystemInfo getBaseSystemInfo() {
        BaseSystemInfo systemInfo = systemInfoThreadLocal.get();
        return systemInfo;
    }

    public static void setBaseSystemInfo(BaseSystemInfo baseSystemInfo) {
        systemInfoThreadLocal.set(baseSystemInfo);
    }

    public static void clearBaseSystemIfo() {
        systemInfoThreadLocal.remove();
    }
}

