/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.util;

import cn.dev33.satoken.same.SaSameUtil;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.SaTerminalInfo;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.consts.DeviceType;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class UserProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProvider.class);
    private static CacheUtil cacheUtil;
    private static CacheKeyUtil cacheKeyUtil;
    public static final String USER_INFO_KEY = "userInfo";
    private static final ThreadLocal<UserInfo> USER_CACHE;

    public UserProvider(CacheUtil cacheUtil, CacheKeyUtil cacheKeyUtil) {
        UserProvider.cacheUtil = cacheUtil;
        UserProvider.cacheKeyUtil = cacheKeyUtil;
    }

    public static void login(UserInfo userInfo) {
        UserProvider.setLocalLoginUser(userInfo);
        StpUtil.login((Object)UserProvider.splicingLoginId(userInfo.getUserId()));
        userInfo.setToken(StpUtil.getTokenValueNotCut());
        UserProvider.setLoginUser(userInfo);
    }

    public static void login(UserInfo userInfo, SaLoginParameter loginModel) {
        UserProvider.setLocalLoginUser(userInfo);
        StpUtil.login((Object)UserProvider.splicingLoginId(userInfo.getUserId()), (SaLoginParameter)loginModel);
        userInfo.setToken(StpUtil.getTokenValueNotCut());
        UserProvider.setLoginUser(userInfo);
    }

    public static void loginNoRequest(UserInfo userInfo, SaLoginParameter loginModel) {
        UserProvider.setLocalLoginUser(userInfo);
        String token = StpUtil.createLoginSession((Object)UserProvider.splicingLoginId(userInfo.getUserId()), (SaLoginParameter)loginModel);
        userInfo.setToken("bearer " + token);
        UserProvider.setLoginUser(userInfo);
    }

    public static String getLoginUserId(String token) {
        String loginId = (String)StpUtil.getLoginIdByToken((String)token);
        return UserProvider.parseLoginId(loginId);
    }

    public static String getLoginUserId() {
        String loginId = UserProvider.getUser().getUserId();
        return UserProvider.parseLoginId(loginId);
    }

    public static String splicingLoginId(String userId) {
        return UserProvider.splicingLoginId(userId, null);
    }

    private static String splicingLoginId(String userId, String tenantId) {
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = TenantHolder.getDatasourceId();
        }
        if (!StringUtils.isEmpty(tenantId)) {
            return tenantId + ":" + userId;
        }
        return userId;
    }

    private static String parseLoginId(String loginId) {
        if (loginId != null && loginId.contains(":")) {
            loginId = loginId.substring(loginId.indexOf(":") + 1);
        }
        return loginId;
    }

    public static Boolean isValidToken(String token) {
        UserInfo userInfo = UserProvider.getUser(token);
        return userInfo.getUserId() != null;
    }

    public static void setLoginUser(UserInfo userInfo) {
        StpUtil.getTokenSessionByToken((String)UserProvider.cutToken(userInfo.getToken())).set(USER_INFO_KEY, (Object)userInfo);
    }

    public static void setLocalLoginUser(UserInfo userInfo) {
        USER_CACHE.set(userInfo);
    }

    public static UserInfo getLocalLoginUser() {
        return USER_CACHE.get();
    }

    public static void clearLocalUser() {
        USER_CACHE.remove();
    }

    public UserInfo get(String token) {
        return UserProvider.getUser(token);
    }

    public UserInfo get() {
        return UserProvider.getUser();
    }

    public static UserInfo getUser(String userId, String tenantId) {
        return UserProvider.getUser(userId, tenantId, null, null);
    }

    public static UserInfo getUser(String userId, String tenantId, List<String> includeDevice, List<String> excludeDevice) {
        List tokenSignList;
        SaSession session = StpUtil.getSessionByLoginId((Object)UserProvider.splicingLoginId(userId, tenantId), (boolean)false);
        if (session != null && !(tokenSignList = session.getTerminalList()).isEmpty() && !(tokenSignList = tokenSignList.stream().filter(tokenSign -> {
            if (!ObjectUtils.isEmpty((Object)excludeDevice) && excludeDevice.contains(tokenSign.getDeviceType())) {
                return false;
            }
            return ObjectUtils.isEmpty((Object)includeDevice) || includeDevice.contains(tokenSign.getDeviceType());
        }).collect(Collectors.toList())).isEmpty()) {
            return UserProvider.getUser(((SaTerminalInfo)tokenSignList.get(0)).getTokenValue());
        }
        return new UserInfo();
    }

    public static UserInfo getUser(String token) {
        UserInfo userInfo = null;
        String tokens = null;
        if (token != null) {
            tokens = UserProvider.cutToken(token);
        } else {
            try {
                tokens = StpUtil.getTokenValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tokens != null && StpUtil.getLoginIdByToken((String)tokens) != null) {
            userInfo = (UserInfo)StpUtil.getTokenSessionByToken((String)tokens).get(USER_INFO_KEY);
        }
        if (userInfo == null) {
            userInfo = new UserInfo();
        }
        return userInfo;
    }

    public static UserInfo getUser() {
        UserInfo userInfo = USER_CACHE.get();
        if (userInfo != null) {
            return userInfo;
        }
        userInfo = UserProvider.getUser(null);
        if (userInfo.getUserId() != null) {
            USER_CACHE.set(userInfo);
        }
        return userInfo;
    }

    public static String cutToken(String token) {
        if (token != null && token.startsWith("bearer ")) {
            token = token.substring("bearer ".length());
        }
        return token;
    }

    public static String getToken() {
        String toke = UserProvider.getAuthorize();
        return toke;
    }

    public static String getAuthorize() {
        String authorize = ServletUtil.getHeader("Authorization");
        return authorize;
    }

    public static void renewTimeout(String token) {
        if (StpUtil.getTokenValue() != null) {
            SaSession saSession;
            UserInfo userInfo = UserProvider.getUser(token);
            if (userInfo.getUserId() == null || userInfo.getTokenTimeout() == null) {
                return;
            }
            StpUtil.renewTimeout((long)((long)userInfo.getTokenTimeout().intValue() * 60L));
            if (userInfo.getIsAdministrator().booleanValue() && (saSession = StpUtil.getSessionByLoginId((Object)UserProvider.splicingLoginId("admin"), (boolean)false)) != null) {
                saSession.updateTimeout((long)userInfo.getTokenTimeout().intValue() * 60L);
            }
        }
    }

    public static List<String> getLoginUserListToken() {
        return StpUtil.searchTokenValue((String)"", (int)-1, (int)-1, (boolean)true).stream().map(token -> token.replace(StpUtil.stpLogic.splicingKeyTokenValue(""), "")).collect(Collectors.toList());
    }

    public static String getInnerAuthToken() {
        return SaSameUtil.getToken();
    }

    public static void checkInnerToken(String token) {
        SaSameUtil.checkToken((String)token);
    }

    public static boolean isValidInnerToken(String token) {
        return SaSameUtil.isValid((String)token);
    }

    public static void kickoutByUserId(String userId, String tenantId) {
        StpUtil.kickout((Object)UserProvider.splicingLoginId(userId, tenantId));
    }

    public static void kickoutByToken(String ... tokens) {
        for (String token : tokens) {
            StpUtil.kickoutByTokenValue((String)token);
        }
    }

    public static void logout() {
        StpUtil.logout();
    }

    public static void logoutByToken(String token) {
        if (token == null) {
            UserProvider.logout();
        } else {
            StpUtil.logoutByTokenValue((String)UserProvider.cutToken(token));
        }
    }

    public static void logoutByUserId(String userId, DeviceType deviceType) {
        StpUtil.logout((Object)UserProvider.splicingLoginId(userId), (String)deviceType.getDevice());
    }

    public static void logoutByUserId(String userId) {
        StpUtil.logout((Object)UserProvider.splicingLoginId(userId));
        UserProvider.removeOtherCache(userId);
    }

    public static List<String> getPermissionList() {
        return StpUtil.getPermissionList();
    }

    public static List<String> getRoleList() {
        return StpUtil.getRoleList();
    }

    public static void removeOtherCache(String userId) {
        cacheUtil.remove(cacheKeyUtil.getUserAuthorize() + userId);
        cacheUtil.remove(cacheKeyUtil.getSystemInfo());
    }

    public boolean isOnLine(String userId) {
        return StpUtil.getTokenValueByLoginId((Object)UserProvider.splicingLoginId(userId), (String)UserProvider.getDeviceForAgent().getDevice()) != null;
    }

    public static boolean isLogined() {
        return StpUtil.isLogin();
    }

    public static boolean isValid(String token) {
        return StpUtil.getLoginIdByToken((String)token) != null;
    }

    public static DeviceType getDeviceForAgent() {
        if (ServletUtil.getIsMobileDevice()) {
            return DeviceType.APP;
        }
        return DeviceType.PC;
    }

    public static boolean isTempUser(UserInfo userInfo) {
        if (userInfo == null) {
            userInfo = UserProvider.getUser();
        }
        return DeviceType.TEMPUSER.getDevice().equals(userInfo.getLoginDevice()) || DeviceType.TEMPUSERLIMITED.getDevice().equals(userInfo.getLoginDevice());
    }

    public UserInfo get(String userId, String tenantId) {
        String OnlineInfo;
        Object OnlineInfoVal;
        UserInfo userInfo;
        tenantId = "null".equals(String.valueOf(tenantId)) ? "" : tenantId;
        String token = tenantId + "login_online_" + userId;
        if (ServletUtils.getIsMobileDevice()) {
            token = tenantId + "login_online_mobile_" + userId;
        }
        return (userInfo = JsonUtil.getJsonToBean(String.valueOf(OnlineInfoVal = cacheUtil.query("loginCacheSpace", OnlineInfo = String.valueOf(cacheUtil.query("loginCacheSpace", token)))), UserInfo.class)) == null ? new UserInfo() : userInfo;
    }

    public void add(UserInfo userInfo) {
        String userId = userInfo.getUserId();
        long time = DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date());
        Object UserAuthorizeUserId = cacheUtil.query("loginCacheSpace", cacheKeyUtil.getUserAuthorize() + userId);
        String authorize = String.valueOf(UserAuthorizeUserId);
        String loginOnlineKey = cacheKeyUtil.getLoginOnline() + userId;
        cacheUtil.remove("loginCacheSpace", authorize);
        cacheUtil.insert("loginCacheSpace", userInfo.getId(), userInfo, time);
        if (ServletUtils.getIsMobileDevice()) {
            String key = cacheKeyUtil.getMobileLoginOnline() + userId;
            cacheUtil.insert("loginCacheSpace", key, userInfo.getId(), time);
            if (ServletUtils.getHeader("clientId") != null) {
                String clientId = ServletUtils.getHeader("clientId");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(userInfo.getUserId(), clientId);
                cacheUtil.insert("loginCacheSpace", cacheKeyUtil.getMobileDeviceList(), map);
            }
        } else {
            cacheUtil.insert("loginCacheSpace", loginOnlineKey, userInfo.getId(), time);
        }
    }

    public void removeWebSocket(UserInfo userInfo) {
        boolean isMobileDevice = ServletUtils.getIsMobileDevice();
        String userId = String.valueOf(userInfo.getUserId());
        String tenandId = "null".equals(String.valueOf(userInfo.getTenantId())) ? "" : userInfo.getTenantId();
        OnlineUserModel user = OnlineUserProvider.getOnlineUserList().stream().filter(t -> userId.equals(t.getUserId()) && tenandId.equals(t.getTenantId()) && isMobileDevice == t.getIsMobileDevice()).findFirst().orElse(null);
        if (user != null) {
            JSONObject object = new JSONObject();
            object.put("method", (Object)"logout");
            object.put("msg", (Object)ActionResultCode.SessionOffLine.getMessage());
            user.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
        }
    }

    public void remove() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();
        if (ServletUtils.getIsMobileDevice()) {
            cacheUtil.removeHash("loginCacheSpace", cacheKeyUtil.getMobileDeviceList(), userId);
        }
        if (userInfo.getId() != null) {
            cacheUtil.remove("loginCacheSpace", userInfo.getId());
        }
        cacheUtil.remove("loginCacheSpace", cacheKeyUtil.getUserAuthorize() + userId);
        cacheUtil.remove("loginCacheSpace", cacheKeyUtil.getLoginOnline() + userId);
        cacheUtil.remove("loginCacheSpace", cacheKeyUtil.getSystemInfo());
    }

    public void removeCurrent() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();
        if (ServletUtils.getIsMobileDevice()) {
            String MobileLoginOnlineUserId = cacheKeyUtil.getMobileLoginOnline() + userInfo.getUserId();
            String key = String.valueOf(cacheUtil.query("loginCacheSpace", MobileLoginOnlineUserId));
            cacheUtil.remove("loginCacheSpace", key);
            cacheUtil.remove("loginCacheSpace", MobileLoginOnlineUserId);
        } else {
            String LoginOnlineUserId = cacheKeyUtil.getLoginOnline() + userInfo.getUserId();
            String key = String.valueOf(cacheUtil.query("loginCacheSpace", LoginOnlineUserId));
            cacheUtil.remove("loginCacheSpace", key);
            cacheUtil.remove("loginCacheSpace", LoginOnlineUserId);
        }
        cacheUtil.remove("loginCacheSpace", cacheKeyUtil.getUserAuthorize() + userId);
        cacheUtil.remove("loginCacheSpace", cacheKeyUtil.getSystemInfo());
    }

    public void removeOnLine(String userId) {
        if (userId == null) {
            return;
        }
        String LoginOnlineUserId = cacheKeyUtil.getLoginOnline() + userId;
        String onlineToken = String.valueOf(cacheUtil.query("loginCacheSpace", LoginOnlineUserId));
        String MobileLoginOnlineUserId = cacheKeyUtil.getMobileLoginOnline() + userId;
        String mobileOnlineToken = String.valueOf(cacheUtil.query("loginCacheSpace", MobileLoginOnlineUserId));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)onlineToken)) {
            cacheUtil.remove("loginCacheSpace", LoginOnlineUserId);
            cacheUtil.remove("loginCacheSpace", onlineToken);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mobileOnlineToken)) {
            cacheUtil.remove("loginCacheSpace", MobileLoginOnlineUserId);
            cacheUtil.remove("loginCacheSpace", mobileOnlineToken);
            cacheUtil.removeHash("loginCacheSpace", cacheKeyUtil.getMobileDeviceList(), userId);
        }
    }

    public boolean isOnLine() {
        UserInfo userInfo = this.get();
        String online = ServletUtils.getIsMobileDevice() ? userInfo.getTenantId() + "login_online_mobile_" + userInfo.getUserId() : userInfo.getTenantId() + "login_online_" + userInfo.getUserId();
        return cacheUtil.exists("loginCacheSpace", online) && userInfo.getId().equals(cacheUtil.query("loginCacheSpace", online).toString());
    }

    public boolean isOverdue() {
        UserInfo userInfo = this.get();
        return !StringUtils.isEmpty(userInfo.getId());
    }

    static {
        USER_CACHE = new ThreadLocal();
    }
}

