/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config;

import cn.hutool.core.net.url.UrlBuilder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;

public class ConfigValueUtil {
    public static final String PREFIX = "config";
    @Value(value="spring.application.name:JSBOS")
    private String applicationName;
    @Value(value="${config.Path}")
    private String path;
    private String licenseFilePath;
    private String dataBackupFilePath;
    private String temporaryFilePath;
    private String systemFilePath;
    private String templateFilePath;
    private String templateCodePath;
    private String templateCodePathVue3;
    private String emailFilePath;
    private String biVisualPath;
    private String documentFilePath;
    private String documentZip;
    private String documentPreviewPath;
    private String userAvatarFilePath;
    private String imContentFilePath;
    @Value(value="${config.fileType}")
    private String fileType;
    private String documentEcbp;
    private String iotAnalysisPath;
    @Value(value="${config.AllowUploadFileType:jpg,gif,png,bmp,jpeg,doc,docx,ppt,pptx,xls,xlsx,pdf,txt,rar,zip,csv,mp3}")
    private String allowUploadFileType;
    @Value(value="${config.AllowUploadImageType:jpg,gif,png,bmp,jpeg,tiff,psd,swf,svg,pcx,dxf,wmf,emf,lic,eps,tga}")
    private String allowUploadImageType;
    @Value(value="${config.AllowPreviewFileType:doc,docx,xls,xlsx,ppt,pptx,pdf,txt}")
    private String allowPreviewFileType;
    @Value(value="${config.PreviewType:kkfile}")
    private String previewType;
    @Value(value="${config.kkFileUrl:}")
    private String kkFileUrl;
    private String baseLanguagePath;
    private String serviceDirectoryPath;
    @Value(value="${config.CodeAreasName}")
    private String codeAreasName;
    private String webAnnexFilePath;
    private boolean shardingSphereEnabled;
    private String ecsOriginalFilePath;
    private String ecsReimbursementFilePath;
    @Value(value="${config.EnablePreAuth:false}")
    private Boolean enablePreAuth;
    @Value(value="${config.ErrorReport}")
    private String errorReport;
    @Value(value="${config.ErrorReportTo}")
    private String errorReportTo;
    @Value(value="${config.RecordLog}")
    private String recordLog;
    @Value(value="${config.MultiTenancy}")
    private boolean multiTenancy;
    private String multiTenancyUrl;
    private String multiTenantColumn = "tenant_id";
    private List<String> multiTenantIgnoreTable = this.initMultiTenantIgnoreTable();
    private String multiTenancyOfficialLoginCodeUrl = null;
    private String multiTenancyOfficialResetCodeUrl = null;
    private boolean enableLogicDelete = false;
    private boolean standingSwitch = false;
    private Long codeCertificateTimeout = 180L;
    private String logicDeleteColumn = "delete_mark";
    @Value(value="${config.SoftVersion}")
    private String softVersion;
    @Value(value="${config.IgexinEnabled}")
    private String igexinEnabled;
    @Value(value="${config.IgexinAppid}")
    private String igexinAppid;
    @Value(value="${config.IgexinAppkey}")
    private String igexinAppkey;
    @Value(value="${config.IgexinMastersecret}")
    private String igexinMastersecret;
    @Value(value="${config.AppUpdateContent}")
    private String appUpdateContent;
    @Value(value="${config.AppVersion}")
    private String appVersion;
    private String frontDomain;
    private String appDomain;
    private String apiDomain;
    private String flowDomain;
    private boolean checkFilePdf;
    @Value(value="${config.TestVersion:false}")
    private String testVersion;
    private String appPushUrl;

    public String getServiceDirectoryPath() {
        String folder = StringUtils.isNotEmpty(this.serviceDirectoryPath) ? this.serviceDirectoryPath : "CodeTemp";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getLicenseFilePath() {
        String folder = StringUtils.isNotEmpty(this.licenseFilePath) ? this.licenseFilePath : "License";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDataBackupFilePath() {
        String folder = StringUtils.isNotEmpty(this.dataBackupFilePath) ? this.dataBackupFilePath : "DataBackupFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentEcbpFilePath() {
        String folder = StringUtils.isNotEmpty(this.documentEcbp) ? this.documentEcbp : "DocumentEcbp";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getIotAnalysisFilePath() {
        String folder = StringUtils.isNotEmpty(this.iotAnalysisPath) ? this.iotAnalysisPath : "iotAnalysis";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemporaryFilePath() {
        String folder = StringUtils.isNotEmpty(this.temporaryFilePath) ? this.temporaryFilePath : "TemporaryFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getSystemFilePath() {
        String folder = StringUtils.isNotEmpty(this.systemFilePath) ? this.systemFilePath : "SystemFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemplateFilePath() {
        String folder = StringUtils.isNotEmpty(this.templateFilePath) ? this.templateFilePath : "TemplateFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemplateCodePath() {
        String folder = StringUtils.isNotEmpty(this.templateCodePath) ? this.templateCodePath : "TemplateCode";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEmailFilePath() {
        String folder = StringUtils.isNotEmpty(this.emailFilePath) ? this.emailFilePath : "EmailFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentPreviewPath() {
        String folder = StringUtils.isNotEmpty(this.documentPreviewPath) ? this.documentPreviewPath : "DocumentPreview";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getUserAvatarFilePath() {
        String folder = StringUtils.isNotEmpty(this.userAvatarFilePath) ? this.userAvatarFilePath : "UserAvatar";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getImContentFilePath() {
        String folder = StringUtils.isNotEmpty(this.imContentFilePath) ? this.imContentFilePath : "IMContentFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentFilePath() {
        String folder = StringUtils.isNotEmpty(this.documentFilePath) ? this.documentFilePath : "DocumentFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentZip() {
        Object folder = StringUtils.isNotEmpty(this.documentZip) ? this.documentZip : "DocumentFile" + File.separator + "temporaryZip";
        return this.getXssPath(this.path + (String)folder + File.separator);
    }

    public String getWebAnnexFilePath() {
        String folder = StringUtils.isNotEmpty(this.webAnnexFilePath) ? this.webAnnexFilePath : "WebAnnexFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEcsOriginalFilePath() {
        String folder = StringUtils.isNotEmpty(this.ecsOriginalFilePath) ? this.ecsOriginalFilePath : "EcsOriginalFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEcsReimbursementFilePath() {
        String folder = StringUtils.isNotEmpty(this.ecsReimbursementFilePath) ? this.ecsReimbursementFilePath : "EcsReimbursementFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getBiVisualPath() {
        String folder = StringUtils.isNotEmpty(this.biVisualPath) ? this.biVisualPath : "BiVisualPath";
        return this.getXssPath(this.path + folder + File.separator);
    }

    private String getXssPath(String path) {
        String xssPath = XSSEscape.escapePath(path);
        return xssPath;
    }

    public String getMultiTenancyOfficialLoginCodeUrl() {
        if (this.multiTenancyOfficialLoginCodeUrl == null) {
            if (StringUtils.isNotEmpty(this.multiTenancyUrl)) {
                UrlBuilder urlBuilder1 = UrlBuilder.of((String)this.multiTenancyUrl);
                this.multiTenancyOfficialLoginCodeUrl = String.format("%s://%s:%s/api/Saas/Tenant/LoginSmsCodeCheck/", urlBuilder1.getSchemeWithDefault(), urlBuilder1.getHost(), urlBuilder1.getPortWithDefault());
            } else {
                this.multiTenancyOfficialLoginCodeUrl = "";
            }
        }
        return this.multiTenancyOfficialLoginCodeUrl;
    }

    public String getMultiTenancyOfficialResetCodeUrl() {
        if (this.multiTenancyOfficialResetCodeUrl == null) {
            if (StringUtils.isNotEmpty(this.multiTenancyUrl)) {
                UrlBuilder urlBuilder1 = UrlBuilder.of((String)this.multiTenancyUrl);
                this.multiTenancyOfficialResetCodeUrl = String.format("%s://%s:%s/api/Saas/Tenant/ResetPasswordSmsCodeCheck/", urlBuilder1.getSchemeWithDefault(), urlBuilder1.getHost(), urlBuilder1.getPortWithDefault());
            } else {
                this.multiTenancyOfficialResetCodeUrl = "";
            }
        }
        return this.multiTenancyOfficialResetCodeUrl;
    }

    public String getTemplateCodePathVue3() {
        String folder = StringUtils.isNotEmpty(this.templateCodePathVue3) ? this.templateCodePathVue3 : "TemplateCodeVue3";
        return this.getXssPath(folder + "/");
    }

    public String getBaseLanguagePath() {
        String folder = StringUtils.isNotEmpty(this.baseLanguagePath) ? this.baseLanguagePath : "Language";
        return this.getXssPath(folder + "/");
    }

    public void setMultiTenantIgnoreTable(List<String> multiTenantIgnoreTable) {
        this.initMultiTenantIgnoreTable();
        this.multiTenantIgnoreTable.addAll(multiTenantIgnoreTable);
        this.multiTenantIgnoreTable = this.multiTenantIgnoreTable.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public List<String> getMultiTenantIgnoreTable() {
        return new ArrayList<String>(this.multiTenantIgnoreTable);
    }

    private List<String> initMultiTenantIgnoreTable() {
        List<String> multiTenantIgnoreTable = this.multiTenantIgnoreTable;
        if (multiTenantIgnoreTable == null) {
            multiTenantIgnoreTable = new ArrayList<String>();
        } else {
            multiTenantIgnoreTable.clear();
        }
        multiTenantIgnoreTable.add("dual");
        return multiTenantIgnoreTable;
    }

    @Generated
    public ConfigValueUtil() {
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getFileType() {
        return this.fileType;
    }

    @Generated
    public String getDocumentEcbp() {
        return this.documentEcbp;
    }

    @Generated
    public String getIotAnalysisPath() {
        return this.iotAnalysisPath;
    }

    @Generated
    public String getAllowUploadFileType() {
        return this.allowUploadFileType;
    }

    @Generated
    public String getAllowUploadImageType() {
        return this.allowUploadImageType;
    }

    @Generated
    public String getAllowPreviewFileType() {
        return this.allowPreviewFileType;
    }

    @Generated
    public String getPreviewType() {
        return this.previewType;
    }

    @Generated
    public String getKkFileUrl() {
        return this.kkFileUrl;
    }

    @Generated
    public String getCodeAreasName() {
        return this.codeAreasName;
    }

    @Generated
    public boolean isShardingSphereEnabled() {
        return this.shardingSphereEnabled;
    }

    @Generated
    public Boolean getEnablePreAuth() {
        return this.enablePreAuth;
    }

    @Generated
    public String getErrorReport() {
        return this.errorReport;
    }

    @Generated
    public String getErrorReportTo() {
        return this.errorReportTo;
    }

    @Generated
    public String getRecordLog() {
        return this.recordLog;
    }

    @Generated
    public boolean isMultiTenancy() {
        return this.multiTenancy;
    }

    @Generated
    public String getMultiTenancyUrl() {
        return this.multiTenancyUrl;
    }

    @Generated
    public String getMultiTenantColumn() {
        return this.multiTenantColumn;
    }

    @Generated
    public boolean isEnableLogicDelete() {
        return this.enableLogicDelete;
    }

    @Generated
    public boolean isStandingSwitch() {
        return this.standingSwitch;
    }

    @Generated
    public Long getCodeCertificateTimeout() {
        return this.codeCertificateTimeout;
    }

    @Generated
    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    @Generated
    public String getSoftVersion() {
        return this.softVersion;
    }

    @Generated
    public String getIgexinEnabled() {
        return this.igexinEnabled;
    }

    @Generated
    public String getIgexinAppid() {
        return this.igexinAppid;
    }

    @Generated
    public String getIgexinAppkey() {
        return this.igexinAppkey;
    }

    @Generated
    public String getIgexinMastersecret() {
        return this.igexinMastersecret;
    }

    @Generated
    public String getAppUpdateContent() {
        return this.appUpdateContent;
    }

    @Generated
    public String getAppVersion() {
        return this.appVersion;
    }

    @Generated
    public String getFrontDomain() {
        return this.frontDomain;
    }

    @Generated
    public String getAppDomain() {
        return this.appDomain;
    }

    @Generated
    public String getApiDomain() {
        return this.apiDomain;
    }

    @Generated
    public String getFlowDomain() {
        return this.flowDomain;
    }

    @Generated
    public boolean isCheckFilePdf() {
        return this.checkFilePdf;
    }

    @Generated
    public String getTestVersion() {
        return this.testVersion;
    }

    @Generated
    public String getAppPushUrl() {
        return this.appPushUrl;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setLicenseFilePath(String licenseFilePath) {
        this.licenseFilePath = licenseFilePath;
    }

    @Generated
    public void setDataBackupFilePath(String dataBackupFilePath) {
        this.dataBackupFilePath = dataBackupFilePath;
    }

    @Generated
    public void setTemporaryFilePath(String temporaryFilePath) {
        this.temporaryFilePath = temporaryFilePath;
    }

    @Generated
    public void setSystemFilePath(String systemFilePath) {
        this.systemFilePath = systemFilePath;
    }

    @Generated
    public void setTemplateFilePath(String templateFilePath) {
        this.templateFilePath = templateFilePath;
    }

    @Generated
    public void setTemplateCodePath(String templateCodePath) {
        this.templateCodePath = templateCodePath;
    }

    @Generated
    public void setTemplateCodePathVue3(String templateCodePathVue3) {
        this.templateCodePathVue3 = templateCodePathVue3;
    }

    @Generated
    public void setEmailFilePath(String emailFilePath) {
        this.emailFilePath = emailFilePath;
    }

    @Generated
    public void setBiVisualPath(String biVisualPath) {
        this.biVisualPath = biVisualPath;
    }

    @Generated
    public void setDocumentFilePath(String documentFilePath) {
        this.documentFilePath = documentFilePath;
    }

    @Generated
    public void setDocumentZip(String documentZip) {
        this.documentZip = documentZip;
    }

    @Generated
    public void setDocumentPreviewPath(String documentPreviewPath) {
        this.documentPreviewPath = documentPreviewPath;
    }

    @Generated
    public void setUserAvatarFilePath(String userAvatarFilePath) {
        this.userAvatarFilePath = userAvatarFilePath;
    }

    @Generated
    public void setImContentFilePath(String imContentFilePath) {
        this.imContentFilePath = imContentFilePath;
    }

    @Generated
    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Generated
    public void setDocumentEcbp(String documentEcbp) {
        this.documentEcbp = documentEcbp;
    }

    @Generated
    public void setIotAnalysisPath(String iotAnalysisPath) {
        this.iotAnalysisPath = iotAnalysisPath;
    }

    @Generated
    public void setAllowUploadFileType(String allowUploadFileType) {
        this.allowUploadFileType = allowUploadFileType;
    }

    @Generated
    public void setAllowUploadImageType(String allowUploadImageType) {
        this.allowUploadImageType = allowUploadImageType;
    }

    @Generated
    public void setAllowPreviewFileType(String allowPreviewFileType) {
        this.allowPreviewFileType = allowPreviewFileType;
    }

    @Generated
    public void setPreviewType(String previewType) {
        this.previewType = previewType;
    }

    @Generated
    public void setKkFileUrl(String kkFileUrl) {
        this.kkFileUrl = kkFileUrl;
    }

    @Generated
    public void setBaseLanguagePath(String baseLanguagePath) {
        this.baseLanguagePath = baseLanguagePath;
    }

    @Generated
    public void setServiceDirectoryPath(String serviceDirectoryPath) {
        this.serviceDirectoryPath = serviceDirectoryPath;
    }

    @Generated
    public void setCodeAreasName(String codeAreasName) {
        this.codeAreasName = codeAreasName;
    }

    @Generated
    public void setWebAnnexFilePath(String webAnnexFilePath) {
        this.webAnnexFilePath = webAnnexFilePath;
    }

    @Generated
    public void setShardingSphereEnabled(boolean shardingSphereEnabled) {
        this.shardingSphereEnabled = shardingSphereEnabled;
    }

    @Generated
    public void setEcsOriginalFilePath(String ecsOriginalFilePath) {
        this.ecsOriginalFilePath = ecsOriginalFilePath;
    }

    @Generated
    public void setEcsReimbursementFilePath(String ecsReimbursementFilePath) {
        this.ecsReimbursementFilePath = ecsReimbursementFilePath;
    }

    @Generated
    public void setEnablePreAuth(Boolean enablePreAuth) {
        this.enablePreAuth = enablePreAuth;
    }

    @Generated
    public void setErrorReport(String errorReport) {
        this.errorReport = errorReport;
    }

    @Generated
    public void setErrorReportTo(String errorReportTo) {
        this.errorReportTo = errorReportTo;
    }

    @Generated
    public void setRecordLog(String recordLog) {
        this.recordLog = recordLog;
    }

    @Generated
    public void setMultiTenancy(boolean multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    @Generated
    public void setMultiTenancyUrl(String multiTenancyUrl) {
        this.multiTenancyUrl = multiTenancyUrl;
    }

    @Generated
    public void setMultiTenantColumn(String multiTenantColumn) {
        this.multiTenantColumn = multiTenantColumn;
    }

    @Generated
    public void setMultiTenancyOfficialLoginCodeUrl(String multiTenancyOfficialLoginCodeUrl) {
        this.multiTenancyOfficialLoginCodeUrl = multiTenancyOfficialLoginCodeUrl;
    }

    @Generated
    public void setMultiTenancyOfficialResetCodeUrl(String multiTenancyOfficialResetCodeUrl) {
        this.multiTenancyOfficialResetCodeUrl = multiTenancyOfficialResetCodeUrl;
    }

    @Generated
    public void setEnableLogicDelete(boolean enableLogicDelete) {
        this.enableLogicDelete = enableLogicDelete;
    }

    @Generated
    public void setStandingSwitch(boolean standingSwitch) {
        this.standingSwitch = standingSwitch;
    }

    @Generated
    public void setCodeCertificateTimeout(Long codeCertificateTimeout) {
        this.codeCertificateTimeout = codeCertificateTimeout;
    }

    @Generated
    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    @Generated
    public void setSoftVersion(String softVersion) {
        this.softVersion = softVersion;
    }

    @Generated
    public void setIgexinEnabled(String igexinEnabled) {
        this.igexinEnabled = igexinEnabled;
    }

    @Generated
    public void setIgexinAppid(String igexinAppid) {
        this.igexinAppid = igexinAppid;
    }

    @Generated
    public void setIgexinAppkey(String igexinAppkey) {
        this.igexinAppkey = igexinAppkey;
    }

    @Generated
    public void setIgexinMastersecret(String igexinMastersecret) {
        this.igexinMastersecret = igexinMastersecret;
    }

    @Generated
    public void setAppUpdateContent(String appUpdateContent) {
        this.appUpdateContent = appUpdateContent;
    }

    @Generated
    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    @Generated
    public void setFrontDomain(String frontDomain) {
        this.frontDomain = frontDomain;
    }

    @Generated
    public void setAppDomain(String appDomain) {
        this.appDomain = appDomain;
    }

    @Generated
    public void setApiDomain(String apiDomain) {
        this.apiDomain = apiDomain;
    }

    @Generated
    public void setFlowDomain(String flowDomain) {
        this.flowDomain = flowDomain;
    }

    @Generated
    public void setCheckFilePdf(boolean checkFilePdf) {
        this.checkFilePdf = checkFilePdf;
    }

    @Generated
    public void setTestVersion(String testVersion) {
        this.testVersion = testVersion;
    }

    @Generated
    public void setAppPushUrl(String appPushUrl) {
        this.appPushUrl = appPushUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigValueUtil)) {
            return false;
        }
        ConfigValueUtil other = (ConfigValueUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShardingSphereEnabled() != other.isShardingSphereEnabled()) {
            return false;
        }
        if (this.isMultiTenancy() != other.isMultiTenancy()) {
            return false;
        }
        if (this.isEnableLogicDelete() != other.isEnableLogicDelete()) {
            return false;
        }
        if (this.isStandingSwitch() != other.isStandingSwitch()) {
            return false;
        }
        if (this.isCheckFilePdf() != other.isCheckFilePdf()) {
            return false;
        }
        Boolean this$enablePreAuth = this.getEnablePreAuth();
        Boolean other$enablePreAuth = other.getEnablePreAuth();
        if (this$enablePreAuth == null ? other$enablePreAuth != null : !((Object)this$enablePreAuth).equals(other$enablePreAuth)) {
            return false;
        }
        Long this$codeCertificateTimeout = this.getCodeCertificateTimeout();
        Long other$codeCertificateTimeout = other.getCodeCertificateTimeout();
        if (this$codeCertificateTimeout == null ? other$codeCertificateTimeout != null : !((Object)this$codeCertificateTimeout).equals(other$codeCertificateTimeout)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$licenseFilePath = this.getLicenseFilePath();
        String other$licenseFilePath = other.getLicenseFilePath();
        if (this$licenseFilePath == null ? other$licenseFilePath != null : !this$licenseFilePath.equals(other$licenseFilePath)) {
            return false;
        }
        String this$dataBackupFilePath = this.getDataBackupFilePath();
        String other$dataBackupFilePath = other.getDataBackupFilePath();
        if (this$dataBackupFilePath == null ? other$dataBackupFilePath != null : !this$dataBackupFilePath.equals(other$dataBackupFilePath)) {
            return false;
        }
        String this$temporaryFilePath = this.getTemporaryFilePath();
        String other$temporaryFilePath = other.getTemporaryFilePath();
        if (this$temporaryFilePath == null ? other$temporaryFilePath != null : !this$temporaryFilePath.equals(other$temporaryFilePath)) {
            return false;
        }
        String this$systemFilePath = this.getSystemFilePath();
        String other$systemFilePath = other.getSystemFilePath();
        if (this$systemFilePath == null ? other$systemFilePath != null : !this$systemFilePath.equals(other$systemFilePath)) {
            return false;
        }
        String this$templateFilePath = this.getTemplateFilePath();
        String other$templateFilePath = other.getTemplateFilePath();
        if (this$templateFilePath == null ? other$templateFilePath != null : !this$templateFilePath.equals(other$templateFilePath)) {
            return false;
        }
        String this$templateCodePath = this.getTemplateCodePath();
        String other$templateCodePath = other.getTemplateCodePath();
        if (this$templateCodePath == null ? other$templateCodePath != null : !this$templateCodePath.equals(other$templateCodePath)) {
            return false;
        }
        String this$templateCodePathVue3 = this.getTemplateCodePathVue3();
        String other$templateCodePathVue3 = other.getTemplateCodePathVue3();
        if (this$templateCodePathVue3 == null ? other$templateCodePathVue3 != null : !this$templateCodePathVue3.equals(other$templateCodePathVue3)) {
            return false;
        }
        String this$emailFilePath = this.getEmailFilePath();
        String other$emailFilePath = other.getEmailFilePath();
        if (this$emailFilePath == null ? other$emailFilePath != null : !this$emailFilePath.equals(other$emailFilePath)) {
            return false;
        }
        String this$biVisualPath = this.getBiVisualPath();
        String other$biVisualPath = other.getBiVisualPath();
        if (this$biVisualPath == null ? other$biVisualPath != null : !this$biVisualPath.equals(other$biVisualPath)) {
            return false;
        }
        String this$documentFilePath = this.getDocumentFilePath();
        String other$documentFilePath = other.getDocumentFilePath();
        if (this$documentFilePath == null ? other$documentFilePath != null : !this$documentFilePath.equals(other$documentFilePath)) {
            return false;
        }
        String this$documentZip = this.getDocumentZip();
        String other$documentZip = other.getDocumentZip();
        if (this$documentZip == null ? other$documentZip != null : !this$documentZip.equals(other$documentZip)) {
            return false;
        }
        String this$documentPreviewPath = this.getDocumentPreviewPath();
        String other$documentPreviewPath = other.getDocumentPreviewPath();
        if (this$documentPreviewPath == null ? other$documentPreviewPath != null : !this$documentPreviewPath.equals(other$documentPreviewPath)) {
            return false;
        }
        String this$userAvatarFilePath = this.getUserAvatarFilePath();
        String other$userAvatarFilePath = other.getUserAvatarFilePath();
        if (this$userAvatarFilePath == null ? other$userAvatarFilePath != null : !this$userAvatarFilePath.equals(other$userAvatarFilePath)) {
            return false;
        }
        String this$imContentFilePath = this.getImContentFilePath();
        String other$imContentFilePath = other.getImContentFilePath();
        if (this$imContentFilePath == null ? other$imContentFilePath != null : !this$imContentFilePath.equals(other$imContentFilePath)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$documentEcbp = this.getDocumentEcbp();
        String other$documentEcbp = other.getDocumentEcbp();
        if (this$documentEcbp == null ? other$documentEcbp != null : !this$documentEcbp.equals(other$documentEcbp)) {
            return false;
        }
        String this$iotAnalysisPath = this.getIotAnalysisPath();
        String other$iotAnalysisPath = other.getIotAnalysisPath();
        if (this$iotAnalysisPath == null ? other$iotAnalysisPath != null : !this$iotAnalysisPath.equals(other$iotAnalysisPath)) {
            return false;
        }
        String this$allowUploadFileType = this.getAllowUploadFileType();
        String other$allowUploadFileType = other.getAllowUploadFileType();
        if (this$allowUploadFileType == null ? other$allowUploadFileType != null : !this$allowUploadFileType.equals(other$allowUploadFileType)) {
            return false;
        }
        String this$allowUploadImageType = this.getAllowUploadImageType();
        String other$allowUploadImageType = other.getAllowUploadImageType();
        if (this$allowUploadImageType == null ? other$allowUploadImageType != null : !this$allowUploadImageType.equals(other$allowUploadImageType)) {
            return false;
        }
        String this$allowPreviewFileType = this.getAllowPreviewFileType();
        String other$allowPreviewFileType = other.getAllowPreviewFileType();
        if (this$allowPreviewFileType == null ? other$allowPreviewFileType != null : !this$allowPreviewFileType.equals(other$allowPreviewFileType)) {
            return false;
        }
        String this$previewType = this.getPreviewType();
        String other$previewType = other.getPreviewType();
        if (this$previewType == null ? other$previewType != null : !this$previewType.equals(other$previewType)) {
            return false;
        }
        String this$kkFileUrl = this.getKkFileUrl();
        String other$kkFileUrl = other.getKkFileUrl();
        if (this$kkFileUrl == null ? other$kkFileUrl != null : !this$kkFileUrl.equals(other$kkFileUrl)) {
            return false;
        }
        String this$baseLanguagePath = this.getBaseLanguagePath();
        String other$baseLanguagePath = other.getBaseLanguagePath();
        if (this$baseLanguagePath == null ? other$baseLanguagePath != null : !this$baseLanguagePath.equals(other$baseLanguagePath)) {
            return false;
        }
        String this$serviceDirectoryPath = this.getServiceDirectoryPath();
        String other$serviceDirectoryPath = other.getServiceDirectoryPath();
        if (this$serviceDirectoryPath == null ? other$serviceDirectoryPath != null : !this$serviceDirectoryPath.equals(other$serviceDirectoryPath)) {
            return false;
        }
        String this$codeAreasName = this.getCodeAreasName();
        String other$codeAreasName = other.getCodeAreasName();
        if (this$codeAreasName == null ? other$codeAreasName != null : !this$codeAreasName.equals(other$codeAreasName)) {
            return false;
        }
        String this$webAnnexFilePath = this.getWebAnnexFilePath();
        String other$webAnnexFilePath = other.getWebAnnexFilePath();
        if (this$webAnnexFilePath == null ? other$webAnnexFilePath != null : !this$webAnnexFilePath.equals(other$webAnnexFilePath)) {
            return false;
        }
        String this$ecsOriginalFilePath = this.getEcsOriginalFilePath();
        String other$ecsOriginalFilePath = other.getEcsOriginalFilePath();
        if (this$ecsOriginalFilePath == null ? other$ecsOriginalFilePath != null : !this$ecsOriginalFilePath.equals(other$ecsOriginalFilePath)) {
            return false;
        }
        String this$ecsReimbursementFilePath = this.getEcsReimbursementFilePath();
        String other$ecsReimbursementFilePath = other.getEcsReimbursementFilePath();
        if (this$ecsReimbursementFilePath == null ? other$ecsReimbursementFilePath != null : !this$ecsReimbursementFilePath.equals(other$ecsReimbursementFilePath)) {
            return false;
        }
        String this$errorReport = this.getErrorReport();
        String other$errorReport = other.getErrorReport();
        if (this$errorReport == null ? other$errorReport != null : !this$errorReport.equals(other$errorReport)) {
            return false;
        }
        String this$errorReportTo = this.getErrorReportTo();
        String other$errorReportTo = other.getErrorReportTo();
        if (this$errorReportTo == null ? other$errorReportTo != null : !this$errorReportTo.equals(other$errorReportTo)) {
            return false;
        }
        String this$recordLog = this.getRecordLog();
        String other$recordLog = other.getRecordLog();
        if (this$recordLog == null ? other$recordLog != null : !this$recordLog.equals(other$recordLog)) {
            return false;
        }
        String this$multiTenancyUrl = this.getMultiTenancyUrl();
        String other$multiTenancyUrl = other.getMultiTenancyUrl();
        if (this$multiTenancyUrl == null ? other$multiTenancyUrl != null : !this$multiTenancyUrl.equals(other$multiTenancyUrl)) {
            return false;
        }
        String this$multiTenantColumn = this.getMultiTenantColumn();
        String other$multiTenantColumn = other.getMultiTenantColumn();
        if (this$multiTenantColumn == null ? other$multiTenantColumn != null : !this$multiTenantColumn.equals(other$multiTenantColumn)) {
            return false;
        }
        List<String> this$multiTenantIgnoreTable = this.getMultiTenantIgnoreTable();
        List<String> other$multiTenantIgnoreTable = other.getMultiTenantIgnoreTable();
        if (this$multiTenantIgnoreTable == null ? other$multiTenantIgnoreTable != null : !((Object)this$multiTenantIgnoreTable).equals(other$multiTenantIgnoreTable)) {
            return false;
        }
        String this$multiTenancyOfficialLoginCodeUrl = this.getMultiTenancyOfficialLoginCodeUrl();
        String other$multiTenancyOfficialLoginCodeUrl = other.getMultiTenancyOfficialLoginCodeUrl();
        if (this$multiTenancyOfficialLoginCodeUrl == null ? other$multiTenancyOfficialLoginCodeUrl != null : !this$multiTenancyOfficialLoginCodeUrl.equals(other$multiTenancyOfficialLoginCodeUrl)) {
            return false;
        }
        String this$multiTenancyOfficialResetCodeUrl = this.getMultiTenancyOfficialResetCodeUrl();
        String other$multiTenancyOfficialResetCodeUrl = other.getMultiTenancyOfficialResetCodeUrl();
        if (this$multiTenancyOfficialResetCodeUrl == null ? other$multiTenancyOfficialResetCodeUrl != null : !this$multiTenancyOfficialResetCodeUrl.equals(other$multiTenancyOfficialResetCodeUrl)) {
            return false;
        }
        String this$logicDeleteColumn = this.getLogicDeleteColumn();
        String other$logicDeleteColumn = other.getLogicDeleteColumn();
        if (this$logicDeleteColumn == null ? other$logicDeleteColumn != null : !this$logicDeleteColumn.equals(other$logicDeleteColumn)) {
            return false;
        }
        String this$softVersion = this.getSoftVersion();
        String other$softVersion = other.getSoftVersion();
        if (this$softVersion == null ? other$softVersion != null : !this$softVersion.equals(other$softVersion)) {
            return false;
        }
        String this$igexinEnabled = this.getIgexinEnabled();
        String other$igexinEnabled = other.getIgexinEnabled();
        if (this$igexinEnabled == null ? other$igexinEnabled != null : !this$igexinEnabled.equals(other$igexinEnabled)) {
            return false;
        }
        String this$igexinAppid = this.getIgexinAppid();
        String other$igexinAppid = other.getIgexinAppid();
        if (this$igexinAppid == null ? other$igexinAppid != null : !this$igexinAppid.equals(other$igexinAppid)) {
            return false;
        }
        String this$igexinAppkey = this.getIgexinAppkey();
        String other$igexinAppkey = other.getIgexinAppkey();
        if (this$igexinAppkey == null ? other$igexinAppkey != null : !this$igexinAppkey.equals(other$igexinAppkey)) {
            return false;
        }
        String this$igexinMastersecret = this.getIgexinMastersecret();
        String other$igexinMastersecret = other.getIgexinMastersecret();
        if (this$igexinMastersecret == null ? other$igexinMastersecret != null : !this$igexinMastersecret.equals(other$igexinMastersecret)) {
            return false;
        }
        String this$appUpdateContent = this.getAppUpdateContent();
        String other$appUpdateContent = other.getAppUpdateContent();
        if (this$appUpdateContent == null ? other$appUpdateContent != null : !this$appUpdateContent.equals(other$appUpdateContent)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$frontDomain = this.getFrontDomain();
        String other$frontDomain = other.getFrontDomain();
        if (this$frontDomain == null ? other$frontDomain != null : !this$frontDomain.equals(other$frontDomain)) {
            return false;
        }
        String this$appDomain = this.getAppDomain();
        String other$appDomain = other.getAppDomain();
        if (this$appDomain == null ? other$appDomain != null : !this$appDomain.equals(other$appDomain)) {
            return false;
        }
        String this$apiDomain = this.getApiDomain();
        String other$apiDomain = other.getApiDomain();
        if (this$apiDomain == null ? other$apiDomain != null : !this$apiDomain.equals(other$apiDomain)) {
            return false;
        }
        String this$flowDomain = this.getFlowDomain();
        String other$flowDomain = other.getFlowDomain();
        if (this$flowDomain == null ? other$flowDomain != null : !this$flowDomain.equals(other$flowDomain)) {
            return false;
        }
        String this$testVersion = this.getTestVersion();
        String other$testVersion = other.getTestVersion();
        if (this$testVersion == null ? other$testVersion != null : !this$testVersion.equals(other$testVersion)) {
            return false;
        }
        String this$appPushUrl = this.getAppPushUrl();
        String other$appPushUrl = other.getAppPushUrl();
        return !(this$appPushUrl == null ? other$appPushUrl != null : !this$appPushUrl.equals(other$appPushUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigValueUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShardingSphereEnabled() ? 79 : 97);
        result = result * 59 + (this.isMultiTenancy() ? 79 : 97);
        result = result * 59 + (this.isEnableLogicDelete() ? 79 : 97);
        result = result * 59 + (this.isStandingSwitch() ? 79 : 97);
        result = result * 59 + (this.isCheckFilePdf() ? 79 : 97);
        Boolean $enablePreAuth = this.getEnablePreAuth();
        result = result * 59 + ($enablePreAuth == null ? 43 : ((Object)$enablePreAuth).hashCode());
        Long $codeCertificateTimeout = this.getCodeCertificateTimeout();
        result = result * 59 + ($codeCertificateTimeout == null ? 43 : ((Object)$codeCertificateTimeout).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $licenseFilePath = this.getLicenseFilePath();
        result = result * 59 + ($licenseFilePath == null ? 43 : $licenseFilePath.hashCode());
        String $dataBackupFilePath = this.getDataBackupFilePath();
        result = result * 59 + ($dataBackupFilePath == null ? 43 : $dataBackupFilePath.hashCode());
        String $temporaryFilePath = this.getTemporaryFilePath();
        result = result * 59 + ($temporaryFilePath == null ? 43 : $temporaryFilePath.hashCode());
        String $systemFilePath = this.getSystemFilePath();
        result = result * 59 + ($systemFilePath == null ? 43 : $systemFilePath.hashCode());
        String $templateFilePath = this.getTemplateFilePath();
        result = result * 59 + ($templateFilePath == null ? 43 : $templateFilePath.hashCode());
        String $templateCodePath = this.getTemplateCodePath();
        result = result * 59 + ($templateCodePath == null ? 43 : $templateCodePath.hashCode());
        String $templateCodePathVue3 = this.getTemplateCodePathVue3();
        result = result * 59 + ($templateCodePathVue3 == null ? 43 : $templateCodePathVue3.hashCode());
        String $emailFilePath = this.getEmailFilePath();
        result = result * 59 + ($emailFilePath == null ? 43 : $emailFilePath.hashCode());
        String $biVisualPath = this.getBiVisualPath();
        result = result * 59 + ($biVisualPath == null ? 43 : $biVisualPath.hashCode());
        String $documentFilePath = this.getDocumentFilePath();
        result = result * 59 + ($documentFilePath == null ? 43 : $documentFilePath.hashCode());
        String $documentZip = this.getDocumentZip();
        result = result * 59 + ($documentZip == null ? 43 : $documentZip.hashCode());
        String $documentPreviewPath = this.getDocumentPreviewPath();
        result = result * 59 + ($documentPreviewPath == null ? 43 : $documentPreviewPath.hashCode());
        String $userAvatarFilePath = this.getUserAvatarFilePath();
        result = result * 59 + ($userAvatarFilePath == null ? 43 : $userAvatarFilePath.hashCode());
        String $imContentFilePath = this.getImContentFilePath();
        result = result * 59 + ($imContentFilePath == null ? 43 : $imContentFilePath.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $documentEcbp = this.getDocumentEcbp();
        result = result * 59 + ($documentEcbp == null ? 43 : $documentEcbp.hashCode());
        String $iotAnalysisPath = this.getIotAnalysisPath();
        result = result * 59 + ($iotAnalysisPath == null ? 43 : $iotAnalysisPath.hashCode());
        String $allowUploadFileType = this.getAllowUploadFileType();
        result = result * 59 + ($allowUploadFileType == null ? 43 : $allowUploadFileType.hashCode());
        String $allowUploadImageType = this.getAllowUploadImageType();
        result = result * 59 + ($allowUploadImageType == null ? 43 : $allowUploadImageType.hashCode());
        String $allowPreviewFileType = this.getAllowPreviewFileType();
        result = result * 59 + ($allowPreviewFileType == null ? 43 : $allowPreviewFileType.hashCode());
        String $previewType = this.getPreviewType();
        result = result * 59 + ($previewType == null ? 43 : $previewType.hashCode());
        String $kkFileUrl = this.getKkFileUrl();
        result = result * 59 + ($kkFileUrl == null ? 43 : $kkFileUrl.hashCode());
        String $baseLanguagePath = this.getBaseLanguagePath();
        result = result * 59 + ($baseLanguagePath == null ? 43 : $baseLanguagePath.hashCode());
        String $serviceDirectoryPath = this.getServiceDirectoryPath();
        result = result * 59 + ($serviceDirectoryPath == null ? 43 : $serviceDirectoryPath.hashCode());
        String $codeAreasName = this.getCodeAreasName();
        result = result * 59 + ($codeAreasName == null ? 43 : $codeAreasName.hashCode());
        String $webAnnexFilePath = this.getWebAnnexFilePath();
        result = result * 59 + ($webAnnexFilePath == null ? 43 : $webAnnexFilePath.hashCode());
        String $ecsOriginalFilePath = this.getEcsOriginalFilePath();
        result = result * 59 + ($ecsOriginalFilePath == null ? 43 : $ecsOriginalFilePath.hashCode());
        String $ecsReimbursementFilePath = this.getEcsReimbursementFilePath();
        result = result * 59 + ($ecsReimbursementFilePath == null ? 43 : $ecsReimbursementFilePath.hashCode());
        String $errorReport = this.getErrorReport();
        result = result * 59 + ($errorReport == null ? 43 : $errorReport.hashCode());
        String $errorReportTo = this.getErrorReportTo();
        result = result * 59 + ($errorReportTo == null ? 43 : $errorReportTo.hashCode());
        String $recordLog = this.getRecordLog();
        result = result * 59 + ($recordLog == null ? 43 : $recordLog.hashCode());
        String $multiTenancyUrl = this.getMultiTenancyUrl();
        result = result * 59 + ($multiTenancyUrl == null ? 43 : $multiTenancyUrl.hashCode());
        String $multiTenantColumn = this.getMultiTenantColumn();
        result = result * 59 + ($multiTenantColumn == null ? 43 : $multiTenantColumn.hashCode());
        List<String> $multiTenantIgnoreTable = this.getMultiTenantIgnoreTable();
        result = result * 59 + ($multiTenantIgnoreTable == null ? 43 : ((Object)$multiTenantIgnoreTable).hashCode());
        String $multiTenancyOfficialLoginCodeUrl = this.getMultiTenancyOfficialLoginCodeUrl();
        result = result * 59 + ($multiTenancyOfficialLoginCodeUrl == null ? 43 : $multiTenancyOfficialLoginCodeUrl.hashCode());
        String $multiTenancyOfficialResetCodeUrl = this.getMultiTenancyOfficialResetCodeUrl();
        result = result * 59 + ($multiTenancyOfficialResetCodeUrl == null ? 43 : $multiTenancyOfficialResetCodeUrl.hashCode());
        String $logicDeleteColumn = this.getLogicDeleteColumn();
        result = result * 59 + ($logicDeleteColumn == null ? 43 : $logicDeleteColumn.hashCode());
        String $softVersion = this.getSoftVersion();
        result = result * 59 + ($softVersion == null ? 43 : $softVersion.hashCode());
        String $igexinEnabled = this.getIgexinEnabled();
        result = result * 59 + ($igexinEnabled == null ? 43 : $igexinEnabled.hashCode());
        String $igexinAppid = this.getIgexinAppid();
        result = result * 59 + ($igexinAppid == null ? 43 : $igexinAppid.hashCode());
        String $igexinAppkey = this.getIgexinAppkey();
        result = result * 59 + ($igexinAppkey == null ? 43 : $igexinAppkey.hashCode());
        String $igexinMastersecret = this.getIgexinMastersecret();
        result = result * 59 + ($igexinMastersecret == null ? 43 : $igexinMastersecret.hashCode());
        String $appUpdateContent = this.getAppUpdateContent();
        result = result * 59 + ($appUpdateContent == null ? 43 : $appUpdateContent.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $frontDomain = this.getFrontDomain();
        result = result * 59 + ($frontDomain == null ? 43 : $frontDomain.hashCode());
        String $appDomain = this.getAppDomain();
        result = result * 59 + ($appDomain == null ? 43 : $appDomain.hashCode());
        String $apiDomain = this.getApiDomain();
        result = result * 59 + ($apiDomain == null ? 43 : $apiDomain.hashCode());
        String $flowDomain = this.getFlowDomain();
        result = result * 59 + ($flowDomain == null ? 43 : $flowDomain.hashCode());
        String $testVersion = this.getTestVersion();
        result = result * 59 + ($testVersion == null ? 43 : $testVersion.hashCode());
        String $appPushUrl = this.getAppPushUrl();
        result = result * 59 + ($appPushUrl == null ? 43 : $appPushUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigValueUtil(applicationName=" + this.getApplicationName() + ", path=" + this.getPath() + ", licenseFilePath=" + this.getLicenseFilePath() + ", dataBackupFilePath=" + this.getDataBackupFilePath() + ", temporaryFilePath=" + this.getTemporaryFilePath() + ", systemFilePath=" + this.getSystemFilePath() + ", templateFilePath=" + this.getTemplateFilePath() + ", templateCodePath=" + this.getTemplateCodePath() + ", templateCodePathVue3=" + this.getTemplateCodePathVue3() + ", emailFilePath=" + this.getEmailFilePath() + ", biVisualPath=" + this.getBiVisualPath() + ", documentFilePath=" + this.getDocumentFilePath() + ", documentZip=" + this.getDocumentZip() + ", documentPreviewPath=" + this.getDocumentPreviewPath() + ", userAvatarFilePath=" + this.getUserAvatarFilePath() + ", imContentFilePath=" + this.getImContentFilePath() + ", fileType=" + this.getFileType() + ", documentEcbp=" + this.getDocumentEcbp() + ", iotAnalysisPath=" + this.getIotAnalysisPath() + ", allowUploadFileType=" + this.getAllowUploadFileType() + ", allowUploadImageType=" + this.getAllowUploadImageType() + ", allowPreviewFileType=" + this.getAllowPreviewFileType() + ", previewType=" + this.getPreviewType() + ", kkFileUrl=" + this.getKkFileUrl() + ", baseLanguagePath=" + this.getBaseLanguagePath() + ", serviceDirectoryPath=" + this.getServiceDirectoryPath() + ", codeAreasName=" + this.getCodeAreasName() + ", webAnnexFilePath=" + this.getWebAnnexFilePath() + ", shardingSphereEnabled=" + this.isShardingSphereEnabled() + ", ecsOriginalFilePath=" + this.getEcsOriginalFilePath() + ", ecsReimbursementFilePath=" + this.getEcsReimbursementFilePath() + ", enablePreAuth=" + this.getEnablePreAuth() + ", errorReport=" + this.getErrorReport() + ", errorReportTo=" + this.getErrorReportTo() + ", recordLog=" + this.getRecordLog() + ", multiTenancy=" + this.isMultiTenancy() + ", multiTenancyUrl=" + this.getMultiTenancyUrl() + ", multiTenantColumn=" + this.getMultiTenantColumn() + ", multiTenantIgnoreTable=" + String.valueOf(this.getMultiTenantIgnoreTable()) + ", multiTenancyOfficialLoginCodeUrl=" + this.getMultiTenancyOfficialLoginCodeUrl() + ", multiTenancyOfficialResetCodeUrl=" + this.getMultiTenancyOfficialResetCodeUrl() + ", enableLogicDelete=" + this.isEnableLogicDelete() + ", standingSwitch=" + this.isStandingSwitch() + ", codeCertificateTimeout=" + this.getCodeCertificateTimeout() + ", logicDeleteColumn=" + this.getLogicDeleteColumn() + ", softVersion=" + this.getSoftVersion() + ", igexinEnabled=" + this.getIgexinEnabled() + ", igexinAppid=" + this.getIgexinAppid() + ", igexinAppkey=" + this.getIgexinAppkey() + ", igexinMastersecret=" + this.getIgexinMastersecret() + ", appUpdateContent=" + this.getAppUpdateContent() + ", appVersion=" + this.getAppVersion() + ", frontDomain=" + this.getFrontDomain() + ", appDomain=" + this.getAppDomain() + ", apiDomain=" + this.getApiDomain() + ", flowDomain=" + this.getFlowDomain() + ", checkFilePdf=" + this.isCheckFilePdf() + ", testVersion=" + this.getTestVersion() + ", appPushUrl=" + this.getAppPushUrl() + ")";
    }
}

