/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.config;

import com.alibaba.druid.support.jakarta.StatViewServlet;
import com.alibaba.druid.support.jakarta.WebStatFilter;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.exception.DataException;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.Arrays;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DruidConfig {
    @Autowired
    DataSourceUtil dataSourceUtil;

    public DataSource druid() throws DataException {
        return ConnUtil.getDruidDataSource(this.dataSourceUtil);
    }

    @Bean
    public ServletRegistrationBean statViewServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        HashMap<String, String> initParams = new HashMap<String, String>(4);
        initParams.put("loginUsername", "bringspring");
        initParams.put("loginPassword", "123456");
        initParams.put("allow", "");
        initParams.put("deny", "192.168.10.21");
        bean.setInitParameters(initParams);
        return bean;
    }

    @Bean
    public FilterRegistrationBean webStatFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new WebStatFilter());
        HashMap<String, String> initParams = new HashMap<String, String>(16);
        initParams.put("exclusions", "*.js,*.css,/druid/*");
        bean.setInitParameters(initParams);
        bean.setUrlPatterns(Arrays.asList("/*"));
        return bean;
    }
}

