/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.db;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.DateTimeLimit;
import com.bringspring.common.database.datatype.limit.DecimalLimit;
import com.bringspring.common.database.datatype.limit.FloatLimit;
import com.bringspring.common.database.datatype.limit.IntegerLimit;
import com.bringspring.common.database.datatype.limit.StringLimit;
import lombok.Generated;

public enum DtMySQLEnum implements DtInterface
{
    TINY_INT("tinyint", new IntegerLimit().fixedPrecision(3)),
    SMALL_INT("smallint", new IntegerLimit().fixedPrecision(5)),
    MEDIUM_INT("mediumint", new IntegerLimit().fixedPrecision(7)),
    INT("int", new IntegerLimit().fixedPrecision(10)),
    BIGINT("bigint", new IntegerLimit().fixedPrecision(19)),
    BIT("bit", new StringLimit(true).charLength(15L, 64L)),
    BLOB("blob", new StringLimit()),
    CHAR("char", new StringLimit(true).charLength(50L, 255L)),
    VARCHAR("varchar", new StringLimit(true).charLength(16170L, 50L)),
    TINY_TEXT("tinytext", new StringLimit().fixedCharLength(225L)),
    TEXT("text", new StringLimit().fixedCharLength(65535L)),
    MEDIUM_TEXT("mediumtext", new StringLimit().fixedCharLength(0xFFFFFFL)),
    LONG_TEXT("longtext", new StringLimit().fixedBitLength(0xFFFFFFFFL)),
    LONG_BLOB("longblob", new StringLimit().fixedCharLength(0L)),
    FLOAT("float", new FloatLimit(true).precision(255, 18).scale(30, 3)),
    DOUBLE("double", new FloatLimit(true).precision(255, 18).scale(30, 3)),
    DECIMAL("decimal", new DecimalLimit(true).precision(65, 18).scale(30, 3)),
    TIME("time", new DateTimeLimit(true).scale(6, 6)),
    DATE_TIME("datetime", new DateTimeLimit(true).scale(6, 6)),
    TIMESTAMP("timestamp", new DateTimeLimit(true).scale(6, 6)),
    YEAR("year", new DateTimeLimit(true).precision(4, 4)),
    DATE("date", new DateTimeLimit());

    private final String dataType;
    private final DtLimitBase dtLimit;

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public DtLimitBase getDtLimit() {
        return this.dtLimit;
    }

    @Generated
    private DtMySQLEnum(String dataType, DtLimitBase dtLimit) {
        this.dataType = dataType;
        this.dtLimit = dtLimit;
    }
}

