/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.db;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.DateTimeLimit;
import com.bringspring.common.database.datatype.limit.DecimalLimit;
import com.bringspring.common.database.datatype.limit.FloatLimit;
import com.bringspring.common.database.datatype.limit.IntegerLimit;
import com.bringspring.common.database.datatype.limit.StringLimit;
import lombok.Generated;

public enum DtSQLServerEnum implements DtInterface
{
    TINY_INT("tinyint", new IntegerLimit()),
    SMALL_INT("smallint", new IntegerLimit()),
    INT("int", new IntegerLimit()),
    BIGINT("bigint", new IntegerLimit()),
    CHAR("char", new StringLimit(true).charLength(8000L, 50L)),
    NVARCHAR("nvarchar", new StringLimit(true).charLength(8000L, 50L)),
    VARCHAR("varchar", new StringLimit(true).charLength(4000L, 50L)),
    VARCHAR_MAX("nvarchar(max)", new StringLimit().fixedCharLength(4005L)),
    VARBINARY("varbinary(max)", new StringLimit()),
    TEXT("text", new StringLimit()),
    N_TEXT("ntext", new StringLimit()),
    IMAGE("image", new StringLimit()),
    FLOAT("float", new FloatLimit().precision(53, 18).scale(18, 3)),
    DATE("date", new DateTimeLimit()),
    TIME("time", new DateTimeLimit()),
    DATE_TIME("datetime", new DateTimeLimit()),
    DATE_TIME2("datetime2", new DateTimeLimit()),
    TIMESTAMP("timestamp", new DateTimeLimit()),
    DECIMAL("decimal", new DecimalLimit(true).precision(38, 18).scale(18, 3));

    private final String dataType;
    private final DtLimitBase dtLimit;

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public DtLimitBase getDtLimit() {
        return this.dtLimit;
    }

    @Generated
    private DtSQLServerEnum(String dataType, DtLimitBase dtLimit) {
        this.dataType = dataType;
        this.dtLimit = dtLimit;
    }
}

