/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.limit;

import com.bringspring.common.database.datatype.db.DtOracleEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.util.DtLimitUtil;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;

public class NumberLimit
extends DtLimitBase {
    public static final String CATEGORY = "type-Number";
    public static final String JAVA_TYPE = "number";

    public NumberLimit(Boolean modify) {
        this.isModifyFlag = modify;
    }

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    @Override
    public DtModel convert(DtModelDTO viewDtModel) {
        DtModel dataTypeModel = switch (viewDtModel.getDtEnum().getDtCategory()) {
            case "type-Decimal", "type-Integer", CATEGORY -> DtLimitUtil.convertNumeric(viewDtModel);
            default -> new DtModel(viewDtModel.getDtEnum());
        };
        if (viewDtModel.getConvertTargetDtEnum().getIsModifyFlag().booleanValue()) {
            if (viewDtModel.getConvertTargetDtEnum().getDbType().equals("Oracle") && dataTypeModel.getNumPrecision().equals(0) && dataTypeModel.getNumScale().equals(0)) {
                dataTypeModel.setNumPrecision(Integer.valueOf(DtOracleEnum.NUMBER.getNumPrecisionLm().getDefaults().toString()));
                dataTypeModel.setNumScale(Integer.valueOf(DtOracleEnum.NUMBER.getNumScaleLm().getDefaults().toString()));
            }
            DtLimitUtil.getNumericLength(dataTypeModel);
        }
        return dataTypeModel;
    }
}

