/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.sync.util;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.datatype.db.DtDMEnum;
import com.bringspring.common.database.datatype.db.DtKingbaseESEnum;
import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.datatype.db.DtOracleEnum;
import com.bringspring.common.database.datatype.db.DtPostgreSQLEnum;
import com.bringspring.common.database.datatype.db.DtSQLServerEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.sync.enums.DtConvertMultiEnum;
import com.bringspring.common.database.datatype.sync.util.DtSyncUtil;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.exception.DataException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DtSyncTest {
    public static void main(String[] args) throws Exception {
        DtSyncTest.checkDataType(true, true, true);
    }

    public static ActionResult<Map<String, List<String>>> getConvertRules(String fromDbType, String toDbType) throws Exception {
        LinkedHashMap map = new LinkedHashMap();
        for (DtInterface dtInterface : (DtInterface[])DtInterface.getClz(fromDbType).getEnumConstants()) {
            DtInterface[] allConverts;
            LinkedList<String> list = new LinkedList<String>();
            for (DtInterface allConvert : allConverts = DtSyncUtil.getAllConverts(dtInterface, toDbType)) {
                list.add(allConvert.getDataType());
            }
            map.put(dtInterface.getDataType(), list);
        }
        return ActionResult.success(map);
    }

    public static ActionResult<Map<String, String>> getDefaultRules(String fromDbType, String toDbType) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (DtInterface dtInterface : (DtInterface[])DtInterface.getClz(fromDbType).getEnumConstants()) {
            DtInterface toFixCovert = DtSyncUtil.getToFixCovert(dtInterface, toDbType);
            if (toFixCovert == null) {
                throw new DataException(MsgCode.DB006.get());
            }
            map.put(dtInterface.getDataType(), toFixCovert.getDataType());
        }
        return ActionResult.success(map);
    }

    public static void checkDataType(Boolean oneFlag, Boolean multiFlag, Boolean mutualFlag) throws Exception {
        Map<String, Object> resultMap;
        if (oneFlag.booleanValue()) {
            for (String string : DbBase.DB_ENCODES) {
                for (String toDbEncode : DbBase.DB_ENCODES) {
                    if (string.equals(toDbEncode)) continue;
                    System.out.println("================ " + string + " \u8f6c " + toDbEncode + " ==============");
                    resultMap = DtSyncTest.getDefaultRules(string, toDbEncode).getData();
                    for (String key : resultMap.keySet()) {
                        System.out.println(key + DtSyncTest.getTab(key, string) + ": \t" + (String)resultMap.get(key));
                    }
                }
            }
        }
        if (multiFlag.booleanValue()) {
            System.out.println("\n\n");
            for (String string : DbBase.DB_ENCODES) {
                for (String toDbEncode : DbBase.DB_ENCODES) {
                    if (string.equals(toDbEncode)) continue;
                    System.out.println("================ " + string + " \u8f6c " + toDbEncode + " ==============");
                    resultMap = DtSyncTest.getConvertRules(string, toDbEncode).getData();
                    for (String key : resultMap.keySet()) {
                        System.out.println(key + DtSyncTest.getTab(key, string) + ": \t" + ((List)resultMap.get(key)).toString());
                    }
                }
            }
        }
        if (mutualFlag.booleanValue()) {
            System.out.println("\n\n");
            for (DtConvertMultiEnum dtConvertMultiEnum : DtConvertMultiEnum.values()) {
                System.out.println("================ " + String.valueOf((Object)dtConvertMultiEnum) + " ==============");
                System.out.println("MySQL\t\t:" + Arrays.asList(dtConvertMultiEnum.getDtMySQLEnums()).toString());
                System.out.println("Oracle\t\t:" + Arrays.asList(dtConvertMultiEnum.getDtOracleEnums()).toString());
                System.out.println("SQLServer\t:" + Arrays.asList(dtConvertMultiEnum.getDtDMEnums()).toString());
                System.out.println("DM8\t\t\t:" + Arrays.asList(dtConvertMultiEnum.getDtSQLServerEnums()).toString());
                System.out.println("KingbaseES\t:" + Arrays.asList(dtConvertMultiEnum.getDtKingbaseESEnums()).toString());
                System.out.println("PostgreSQL\t:" + Arrays.asList(dtConvertMultiEnum.getDtPostgreSQLEnums()).toString());
            }
        }
        System.out.println("\n\n");
        System.out.println("================ MySQL ==============");
        for (DtMySQLEnum dtMySQLEnum : DtMySQLEnum.values()) {
            System.out.println(dtMySQLEnum.getDataType());
        }
        System.out.println("================ Oracle ==============");
        for (DtOracleEnum dtOracleEnum : DtOracleEnum.values()) {
            System.out.println(dtOracleEnum.getDataType());
        }
        System.out.println("================ SQLServer ==============");
        for (DtSQLServerEnum dtSQLServerEnum : DtSQLServerEnum.values()) {
            System.out.println(dtSQLServerEnum.getDataType());
        }
        System.out.println("================ DM8 ==============");
        for (DtDMEnum dtDMEnum : DtDMEnum.values()) {
            System.out.println(dtDMEnum.getDataType());
        }
        System.out.println("================ KingbaseES ==============");
        for (DtKingbaseESEnum dtKingbaseESEnum : DtKingbaseESEnum.values()) {
            System.out.println(dtKingbaseESEnum.getDataType());
        }
        System.out.println("================ PostgreSQL ==============");
        for (DtPostgreSQLEnum dtPostgreSQLEnum : DtPostgreSQLEnum.values()) {
            System.out.println(dtPostgreSQLEnum.getDataType());
        }
    }

    public static String getTab(String str, String dbType) {
        int num = str.length();
        String tab = "\t\t";
        if ("Oracle".equals(dbType) || "DM8".equals(dbType)) {
            if (num >= 8) {
                tab = "\t";
            }
        } else if (num > 8) {
            tab = "\t";
        }
        return tab;
    }
}

