/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.sync.util;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.sync.enums.DtConvertEnum;
import com.bringspring.common.database.datatype.sync.enums.DtConvertMultiEnum;
import com.bringspring.common.exception.DataException;
import java.util.Map;

public class DtSyncUtil {
    public static DtInterface getToCovert(String fromDbType, String toDbType, String dataTypeName, Map<String, String> convertRuleMap) throws Exception {
        DtInterface formDtEnum;
        if (convertRuleMap != null) {
            for (String key : convertRuleMap.keySet()) {
                if (!key.equalsIgnoreCase(dataTypeName)) continue;
                String toDataType = convertRuleMap.get(key);
                return DtInterface.newInstanceByDt(toDataType, toDbType);
            }
        }
        if ((formDtEnum = DtInterface.newInstanceByDt(dataTypeName, fromDbType)) != null) {
            return DtSyncUtil.getToFixCovert(formDtEnum, toDbType);
        }
        throw new DataException(MsgCode.DB005.get(fromDbType, dataTypeName));
    }

    public static DtInterface getToFixCovert(DtInterface fromDtEnum, String toDbType) throws Exception {
        return DtConvertEnum.getConvertModel(fromDtEnum).getDtEnum(toDbType);
    }

    public static DtInterface[] getAllConverts(DtInterface fromDtEnum, String toDbType) throws Exception {
        for (DtConvertMultiEnum convertEnum : DtConvertMultiEnum.values()) {
            if (!convertEnum.getAllConverts().contains(fromDtEnum)) continue;
            return DtConvertMultiEnum.getConverts(toDbType, convertEnum);
        }
        return null;
    }
}

