/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model.dbfield;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.model.DtModelDTO;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.base.DbFieldModelBase;
import com.bringspring.common.database.util.DbTypeUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class JdbcColumnModel
extends DbFieldModelBase {
    private String label;
    private Integer dtJdbcEncode;
    private Object value;
    protected String defaultValue;
    private String table;
    private String size;
    private Long columnSize;
    private Integer numPrecRadix;
    private Integer decimalDigits;
    private String ordinalPosition;
    private String autoIncrement;
    private String javaDataType;

    public DbFieldModel convertDbFieldModel(String dbEncode) throws Exception {
        DbFieldModel dbFieldModel = new DbFieldModel();
        dbFieldModel.setField(this.getField());
        dbFieldModel.setComment(this.getComment());
        dbFieldModel.setDataType(this.getDataType());
        dbFieldModel.setIsPrimaryKey(this.getIsPrimaryKey());
        dbFieldModel.setIsAutoIncrement(JdbcColumnModel.convertIsAutoIncrement(dbEncode, this.getAutoIncrement()));
        dbFieldModel.setNullSign(this.getNullSign());
        dbFieldModel.setDefaultValue(this.getDefaultValue());
        DtInterface dtEnum = DtInterface.newInstanceByDt(this.getDataType(), dbEncode);
        assert (dtEnum != null);
        dbFieldModel.setDtModelDTO(new DtModelDTO(dtEnum, this.columnSize, Integer.parseInt(this.columnSize.toString()), this.decimalDigits));
        return dbFieldModel;
    }

    private static Boolean convertIsAutoIncrement(String dbEncode, String sign) {
        switch (dbEncode) {
            case "MySQL": {
                return sign.equalsIgnoreCase("YES");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JdbcColumnModel> getList(Connection conn, String table, List<String> primaryFields) throws Exception {
        ResultSet rs = JdbcColumnModel.getColumnMetaDateRs(conn, table);
        try {
            ArrayList<JdbcColumnModel> list = new ArrayList<JdbcColumnModel>();
            while (rs.next()) {
                JdbcColumnModel column = new JdbcColumnModel();
                column.setTable(rs.getString("TABLE_NAME"));
                column.setField(rs.getString("COLUMN_NAME"));
                column.setJavaDataType(rs.getString("DATA_TYPE"));
                column.setDataType(rs.getString("TYPE_NAME"));
                column.setColumnSize(rs.getLong("COLUMN_SIZE"));
                column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                column.setComment(rs.getString("REMARKS"));
                column.setDefaultValue(rs.getString("COLUMN_DEF"));
                column.setLength(rs.getString("CHAR_OCTET_LENGTH"));
                column.setOrdinalPosition(rs.getString("ORDINAL_POSITION"));
                String isNull = rs.getString("IS_NULLABLE");
                column.setNullSign(isNull.equalsIgnoreCase("YES") ? "NULL" : "NOT NULL");
                try {
                    column.setAutoIncrement(rs.getString("IS_AUTOINCREMENT"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                column.setIsPrimaryKey(primaryFields.stream().anyMatch(o -> o.equalsIgnoreCase(column.getField())));
                list.add(column);
            }
            ArrayList<JdbcColumnModel> arrayList = list;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(rs).get(0) != null) {
                rs.close();
            }
        }
    }

    public static List<JdbcColumnModel> getList(ResultSet rs, Boolean isLowercase, Boolean isValue) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        ArrayList<JdbcColumnModel> dbColumnModelList = new ArrayList<JdbcColumnModel>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            JdbcColumnModel model = new JdbcColumnModel();
            model.setTable(md.getTableName(i));
            model.setField(md.getColumnName(i));
            model.setNullSign(md.isNullable(i) == 1 ? "NULL" : "NOT NULL");
            model.setLabel(isLowercase != false ? md.getColumnLabel(i).toLowerCase() : md.getColumnLabel(i));
            model.setDataType(md.getColumnTypeName(i));
            model.setValue(isValue != false ? rs.getObject(i) : null);
            dbColumnModelList.add(model);
        }
        return dbColumnModelList;
    }

    public void getOracle() {
    }

    public static ResultSet getColumnMetaDateRs(Connection conn, String table) throws Exception {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        switch (DbTypeUtil.getDb(conn).getDbEncode()) {
            case "SQLServer": {
                return dbMetaData.getColumns(conn.getCatalog(), "dbo", table, null);
            }
            case "PostgreSQL": {
                return dbMetaData.getColumns(conn.getCatalog(), "public", table, null);
            }
            case "KingbaseES": {
                return dbMetaData.getColumns(conn.getCatalog(), conn.getSchema(), table, null);
            }
        }
        return dbMetaData.getColumns(conn.getCatalog(), dbMetaData.getUserName(), table, null);
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Integer getDtJdbcEncode() {
        return this.dtJdbcEncode;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @Generated
    public Long getColumnSize() {
        return this.columnSize;
    }

    @Generated
    public Integer getNumPrecRadix() {
        return this.numPrecRadix;
    }

    @Generated
    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    @Generated
    public String getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Generated
    public String getAutoIncrement() {
        return this.autoIncrement;
    }

    @Generated
    public String getJavaDataType() {
        return this.javaDataType;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setDtJdbcEncode(Integer dtJdbcEncode) {
        this.dtJdbcEncode = dtJdbcEncode;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setSize(String size) {
        this.size = size;
    }

    @Generated
    public void setColumnSize(Long columnSize) {
        this.columnSize = columnSize;
    }

    @Generated
    public void setNumPrecRadix(Integer numPrecRadix) {
        this.numPrecRadix = numPrecRadix;
    }

    @Generated
    public void setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    @Generated
    public void setOrdinalPosition(String ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    @Generated
    public void setAutoIncrement(String autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Generated
    public void setJavaDataType(String javaDataType) {
        this.javaDataType = javaDataType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcColumnModel)) {
            return false;
        }
        JdbcColumnModel other = (JdbcColumnModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$dtJdbcEncode = this.getDtJdbcEncode();
        Integer other$dtJdbcEncode = other.getDtJdbcEncode();
        if (this$dtJdbcEncode == null ? other$dtJdbcEncode != null : !((Object)this$dtJdbcEncode).equals(other$dtJdbcEncode)) {
            return false;
        }
        Long this$columnSize = this.getColumnSize();
        Long other$columnSize = other.getColumnSize();
        if (this$columnSize == null ? other$columnSize != null : !((Object)this$columnSize).equals(other$columnSize)) {
            return false;
        }
        Integer this$numPrecRadix = this.getNumPrecRadix();
        Integer other$numPrecRadix = other.getNumPrecRadix();
        if (this$numPrecRadix == null ? other$numPrecRadix != null : !((Object)this$numPrecRadix).equals(other$numPrecRadix)) {
            return false;
        }
        Integer this$decimalDigits = this.getDecimalDigits();
        Integer other$decimalDigits = other.getDecimalDigits();
        if (this$decimalDigits == null ? other$decimalDigits != null : !((Object)this$decimalDigits).equals(other$decimalDigits)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$ordinalPosition = this.getOrdinalPosition();
        String other$ordinalPosition = other.getOrdinalPosition();
        if (this$ordinalPosition == null ? other$ordinalPosition != null : !this$ordinalPosition.equals(other$ordinalPosition)) {
            return false;
        }
        String this$autoIncrement = this.getAutoIncrement();
        String other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !this$autoIncrement.equals(other$autoIncrement)) {
            return false;
        }
        String this$javaDataType = this.getJavaDataType();
        String other$javaDataType = other.getJavaDataType();
        return !(this$javaDataType == null ? other$javaDataType != null : !this$javaDataType.equals(other$javaDataType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcColumnModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dtJdbcEncode = this.getDtJdbcEncode();
        result = result * 59 + ($dtJdbcEncode == null ? 43 : ((Object)$dtJdbcEncode).hashCode());
        Long $columnSize = this.getColumnSize();
        result = result * 59 + ($columnSize == null ? 43 : ((Object)$columnSize).hashCode());
        Integer $numPrecRadix = this.getNumPrecRadix();
        result = result * 59 + ($numPrecRadix == null ? 43 : ((Object)$numPrecRadix).hashCode());
        Integer $decimalDigits = this.getDecimalDigits();
        result = result * 59 + ($decimalDigits == null ? 43 : ((Object)$decimalDigits).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $ordinalPosition = this.getOrdinalPosition();
        result = result * 59 + ($ordinalPosition == null ? 43 : $ordinalPosition.hashCode());
        String $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : $autoIncrement.hashCode());
        String $javaDataType = this.getJavaDataType();
        result = result * 59 + ($javaDataType == null ? 43 : $javaDataType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "JdbcColumnModel(label=" + this.getLabel() + ", dtJdbcEncode=" + this.getDtJdbcEncode() + ", value=" + String.valueOf(this.getValue()) + ", defaultValue=" + this.getDefaultValue() + ", table=" + this.getTable() + ", size=" + this.getSize() + ", columnSize=" + this.getColumnSize() + ", numPrecRadix=" + this.getNumPrecRadix() + ", decimalDigits=" + this.getDecimalDigits() + ", ordinalPosition=" + this.getOrdinalPosition() + ", autoIncrement=" + this.getAutoIncrement() + ", javaDataType=" + this.getJavaDataType() + ")";
    }

    @Generated
    public JdbcColumnModel() {
    }
}

