/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.util.TenantHolder;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MyDefaultMasterSlaveAutoRoutingPlugin
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyDefaultMasterSlaveAutoRoutingPlugin.class);
    protected DynamicRoutingDataSource dynamicDataSource;

    public MyDefaultMasterSlaveAutoRoutingPlugin(DataSource dataSource) {
        this.dynamicDataSource = (DynamicRoutingDataSource)dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (TenantHolder.isRemote() || !DynamicDataSourceUtil.isPrimaryDataSoure() || !this.dynamicDataSource.getGroupDataSources().containsKey("slave")) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        String pushedDataSource = null;
        try {
            boolean hasTrans = TransactionSynchronizationManager.isActualTransactionActive();
            if (!hasTrans) {
                hasTrans = StringUtils.hasText((String)TransactionContext.getXID());
            }
            String dataSource = !hasTrans && SqlCommandType.SELECT == ms.getSqlCommandType() ? "slave" : DynamicDataSourceUtil.dynamicDataSourceProperties.getPrimary();
            pushedDataSource = DynamicDataSourceContextHolder.push((String)dataSource);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (pushedDataSource != null) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }
}

