/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.param;

import cn.hutool.core.util.HexUtil;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.JdbcColumnModel;
import com.bringspring.common.database.model.dbtable.DbTableFieldModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.sql.enums.SqlOracleEnum;
import com.bringspring.common.database.sql.model.SqlPrintHandler;
import com.bringspring.common.database.sql.util.SqlFrameUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.util.context.SpringContext;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import oracle.sql.TIMESTAMP;

public class FormatSqlOracle {
    private static SqlPrintHandler sqlPrintHandler = SpringContext.getBean(SqlPrintHandler.class);
    public static Function<Map<String, Object>, Map.Entry<String, Object>> getPrimaryVal = fieldMap -> {
        for (Map.Entry field : fieldMap.entrySet()) {
            String primaryKey = (String)field.getKey();
            if (!primaryKey.equalsIgnoreCase("fid") && !primaryKey.equalsIgnoreCase("id") && !primaryKey.equalsIgnoreCase("ID_")) continue;
            return field;
        }
        return null;
    };

    public static String dateTime(String dbEncode, String dateTime) {
        if ("Oracle".equals(dbEncode)) {
            return "to_date(" + dateTime + ", 'yyyy-mm-dd hh24:mi:ss')";
        }
        return dateTime;
    }

    public static Object timestamp(Object value) {
        if (value instanceof TIMESTAMP) {
            try {
                return ((TIMESTAMP)value).dateValue();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static void nullValue(String dbEncode, JdbcColumnModel model, Map<String, Object> map) {
        if (("Oracle".equals(dbEncode) || "DM8".equals(dbEncode)) && model.getValue() instanceof String && model.getNullSign().equals("NOT NULL") && model.getValue().toString().equals("")) {
            map.put(model.getField(), " ");
        }
    }

    public static Object clobExecute(String dbEncode, Object context, String table, String column, Map<String, Object> dataMap, StringBuilder sqlBuilder) {
        String clobUpdateSql;
        Map.Entry<String, Object> field;
        if ("Oracle".equals(dbEncode) && context instanceof String && (field = getPrimaryVal.apply(dataMap)) != null && (clobUpdateSql = FormatSqlOracle.clobUpdate(context.toString(), table, column, field.getKey(), field.getValue().toString())) != null) {
            sqlPrintHandler.updateClob(clobUpdateSql);
            sqlBuilder.append(clobUpdateSql).append(";\n/\n");
            return "context";
        }
        return context;
    }

    public static Object blobExecute(String dbEncode, Object context, String table, String column, Map<String, Object> dataMap, StringBuilder sqlBuilder) {
        String clobUpdateSql;
        Map.Entry<String, Object> field;
        if ("Oracle".equals(dbEncode) && context instanceof byte[] && (field = getPrimaryVal.apply(dataMap)) != null && (clobUpdateSql = FormatSqlOracle.blobUpdate(HexUtil.encodeHexStr((byte[])((byte[])context)), table, column, field.getKey(), field.getValue().toString())) != null) {
            sqlPrintHandler.updateClob(clobUpdateSql);
            sqlBuilder.append(clobUpdateSql).append(";\n/\n");
            return "30";
        }
        return context;
    }

    public static String clobUpdate(String context, String table, String column, String primaryColumn, String primaryValue) {
        if (context.length() > 1500) {
            context = context.replace("'", "''");
            List<String> splitStrList = SqlFrameUtil.splitStrRepeat(context, 1500);
            StringBuilder contextInfo = new StringBuilder();
            for (String contextFragment : splitStrList) {
                contextInfo.append("\t").append(SqlOracleEnum.CLOB_APPEND.getSqlFrame().replace("{context}", contextFragment)).append(";\n");
            }
            return SqlOracleEnum.CLOB_UPDATE.getFastSql(Arrays.asList(table, column, contextInfo.toString(), primaryColumn, primaryValue));
        }
        return null;
    }

    public static String blobUpdate(String context, String table, String column, String primaryColumn, String primaryValue) {
        context = context.replace("'", "''");
        List<String> splitStrList = SqlFrameUtil.splitStrRepeat(context, 1500);
        StringBuilder contextInfo = new StringBuilder();
        for (String contextFragment : splitStrList) {
            contextInfo.append("\t").append(SqlOracleEnum.BLOB_APPEND.getSqlFrame().replace("{context}", contextFragment)).append(";\n");
        }
        return SqlOracleEnum.BLOB_UPDATE.getFastSql(Arrays.asList(table, column, contextInfo.toString(), primaryColumn, primaryValue));
    }

    public static void autoIncrement(DbLinkEntity dbLinkEntity, DbTableFieldModel dbTableFieldModel) throws Exception {
        if (DbTypeUtil.checkOracle(dbLinkEntity).booleanValue()) {
            String table = dbTableFieldModel.getTable();
            boolean autoInc = false;
            String autoIncField = "";
            for (DbFieldModel dbFieldModel : dbTableFieldModel.getDbFieldModelList()) {
                if (dbFieldModel.getIsAutoIncrement() == null || !dbFieldModel.getIsAutoIncrement().booleanValue()) continue;
                autoInc = true;
                autoIncField = dbFieldModel.getField();
            }
            if (autoInc) {
                NotTenantPluginHolder.setNotSwitchFlag();
                String autoIncrement = SqlOracleEnum.CREATE_AUTO_INCREMENT.getSqlFrame().replace("{table}", table);
                String autoIncrementTrigger = SqlOracleEnum.CREATE_AUTO_INCREMENT_TRIGGER.getSqlFrame().replace("{table}", table).replace("{autoInc_field}", autoIncField);
                if (!sqlPrintHandler.oracleAutoIncrement(autoIncrement).booleanValue()) {
                    NotTenantPluginHolder.setNotSwitchFlag();
                }
            }
        }
    }

    @Generated
    public FormatSqlOracle() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormatSqlOracle)) {
            return false;
        }
        FormatSqlOracle other = (FormatSqlOracle)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormatSqlOracle;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "FormatSqlOracle()";
    }
}

