/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.druid.DruidConfig;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.LockObjectUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DynamicDataSourceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceUtil.class);
    private static int MAX_DATASOURCE_COUNT = 300;
    private static LRUMap<String, DbLinkEntity> linksProperties = new LRUMap(MAX_DATASOURCE_COUNT);
    public static DataSourceUtil dataSourceUtil;
    public static DynamicRoutingDataSource dynamicRoutingDataSource;
    public static DynamicDataSourceProperties dynamicDataSourceProperties;
    private static DefaultDataSourceCreator defaultDataSourceCreator;
    private static ConfigValueUtil configValueUtil;

    public DynamicDataSourceUtil(@Qualifier(value="dataSourceSystem") DataSource dynamicRoutingDataSource, DynamicDataSourceProperties dynamicDataSourceProperties, DefaultDataSourceCreator defaultDataSourceCreator, ConfigValueUtil configValueUtil, DataSourceUtil dataSourceUtil) {
        DynamicDataSourceUtil.dynamicRoutingDataSource = (DynamicRoutingDataSource)dynamicRoutingDataSource;
        DynamicDataSourceUtil.dynamicDataSourceProperties = dynamicDataSourceProperties;
        DynamicDataSourceUtil.defaultDataSourceCreator = defaultDataSourceCreator;
        DynamicDataSourceUtil.configValueUtil = configValueUtil;
        DynamicDataSourceUtil.dataSourceUtil = new DataSourceUtil();
        BeanUtils.copyProperties((Object)dataSourceUtil, (Object)DynamicDataSourceUtil.dataSourceUtil);
    }

    public static DbLinkEntity switchToDataSource(String userName, String password, String url, String dbType) throws DataException, SQLException {
        String tenantId = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        String dbKey = tenantId + userName + password + url;
        DbLinkEntity dbLinkEntity = new DbLinkEntity();
        dbLinkEntity.setId(dbKey);
        dbLinkEntity.setUserName(userName);
        dbLinkEntity.setPassword(password);
        dbLinkEntity.setUrl(url);
        if (StringUtils.isEmpty(dbType)) {
            dbLinkEntity.setDbType(DbTypeUtil.getDb(url).getDbEncode());
        } else {
            dbLinkEntity.setDbType(dbType);
        }
        DynamicDataSourceUtil.switchToDataSource(dbLinkEntity);
        return dbLinkEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchToDataSource(DbLinkEntity dbLinkEntity) throws DataException, SQLException {
        if (dbLinkEntity == null || StringUtils.isEmpty(dbLinkEntity.getId()) || "0".equals(dbLinkEntity.getId())) {
            if (TenantHolder.isRemote()) {
                String dbKey = TenantHolder.getDatasourceId() + "-master";
                DynamicDataSourceContextHolder.push((String)dbKey);
            } else {
                DynamicDataSourceContextHolder.push(null);
            }
            return;
        }
        String tenantId = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        String dbKey = tenantId + dbLinkEntity.getId();
        String removeKey = null;
        boolean insert = true;
        Object object = LockObjectUtil.addLockKey(dbKey);
        synchronized (object) {
            if (dynamicRoutingDataSource.getDataSources().containsKey(dbKey)) {
                LRUMap<String, DbLinkEntity> lRUMap = linksProperties;
                synchronized (lRUMap) {
                    if (((DbLinkEntity)linksProperties.get((Object)dbKey)).equals(dbLinkEntity)) {
                        insert = false;
                    }
                }
            }
            if (insert) {
                DataSource ds = DynamicDataSourceUtil.createDataSource(dbLinkEntity);
                if (ds instanceof ItemDataSource && ((ItemDataSource)ds).getRealDataSource() instanceof DruidDataSource) {
                    ((DruidDataSource)((ItemDataSource)ds).getRealDataSource()).setMinIdle(0);
                }
                dynamicRoutingDataSource.addDataSource(dbKey, ds);
                LRUMap<String, DbLinkEntity> lRUMap = linksProperties;
                synchronized (lRUMap) {
                    if (linksProperties.size() == MAX_DATASOURCE_COUNT) {
                        removeKey = (String)linksProperties.firstKey();
                    }
                    linksProperties.put((Object)dbKey, (Object)dbLinkEntity);
                }
            }
        }
        DynamicDataSourceContextHolder.push((String)dbKey);
        if (removeKey != null) {
            try {
                dynamicRoutingDataSource.removeDataSource(removeKey);
            }
            catch (Exception e) {
                log.error("\u79fb\u9664\u6570\u636e\u6e90\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    public static void clearSwitchDataSource() {
        DynamicDataSourceContextHolder.poll();
    }

    public static Connection getCurrentConnection() throws SQLException {
        return dynamicRoutingDataSource.getConnection();
    }

    public static <T extends DataSourceUtil> DataSource createDataSource(T dbLinkEntity) throws DataException, SQLException {
        return DynamicDataSourceUtil.createDataSource(dbLinkEntity, dbLinkEntity.getUrl());
    }

    public static <T extends DataSourceUtil> DataSource createDataSource(T dbLinkEntity, String url) throws DataException {
        DataSourceProperty dataSourceProperty = DynamicDataSourceUtil.createDataSourceProperty(dbLinkEntity, url);
        DataSource ds = defaultDataSourceCreator.createDataSource(dataSourceProperty);
        return ds;
    }

    public static <T extends DataSourceUtil> DataSourceProperty createDataSourceProperty(T dbLinkEntity, String url) {
        if (StringUtils.isEmpty(url)) {
            url = ConnUtil.getUrl(dbLinkEntity, dbLinkEntity.getDbName());
        }
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        dataSourceProperty.setUsername(dbLinkEntity.getAutoUsername());
        dataSourceProperty.setPassword(dbLinkEntity.getAutoPassword());
        dataSourceProperty.setUrl(url);
        dataSourceProperty.setDriverClassName(DbTypeUtil.getDb(dbLinkEntity).getDriver());
        DruidConfig druidConfig = (DruidConfig)BeanUtil.copyProperties((Object)dynamicDataSourceProperties.getDruid(), DruidConfig.class, (String[])new String[0]);
        dataSourceProperty.setLazy(Boolean.valueOf(true));
        druidConfig.setBreakAfterAcquireFailure(Boolean.valueOf(true));
        if (druidConfig.getValidationQuery() == null && (DbTypeUtil.checkKingbase(dbLinkEntity).booleanValue() || DbTypeUtil.checkDM(dbLinkEntity).booleanValue())) {
            druidConfig.setValidationQuery("select 1;");
        }
        if (DbTypeUtil.checkOracle(dbLinkEntity).booleanValue()) {
            druidConfig.setConnectionProperties(DbOracle.setConnProp("Default", dbLinkEntity.getUserName(), dbLinkEntity.getPassword()));
        }
        dataSourceProperty.setDruid(druidConfig);
        return dataSourceProperty;
    }

    public static boolean isPrimaryDataSoure() {
        String dsKey = DynamicDataSourceContextHolder.peek();
        return StringUtils.isEmpty(dsKey) || dynamicDataSourceProperties.getPrimary().equals(dsKey);
    }

    public static String getPrimaryDbType() {
        return dataSourceUtil.getDbType();
    }

    public static DataSourceUtil getDataSourceUtil() {
        return dataSourceUtil;
    }

    public static boolean containsLink(String key) {
        return linksProperties.containsKey((Object)key);
    }
}

