/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.JdbcPageMod;
import com.bringspring.common.database.model.dto.JdbcDTO;
import com.bringspring.common.database.model.dto.ModelDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CollectionUtils;
import com.bringspring.common.util.XSSEscape;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);

    public static Boolean creUpDe(PreparedStatementDTO statementDTO) throws DataException {
        Connection conn = statementDTO.getConn();
        String sql = statementDTO.getPrepareSql();
        LinkedList<Object> data = statementDTO.getPrepareDataList();
        String[] batchSql = sql.split(";");
        boolean flag = false;
        try {
            conn.setAutoCommit(false);
            flag = JdbcUtil.creUpDeBase(conn, Arrays.asList(statementDTO)).get(0);
            conn.commit();
            return flag;
        }
        catch (Exception e) {
            throw DataException.rollbackDataException(e.getMessage(), conn);
        }
    }

    public static List<Boolean> creUpDeBatch(Connection conn, List<PreparedStatementDTO> DTOs) throws DataException {
        try {
            conn.setAutoCommit(false);
            List<Boolean> flags = JdbcUtil.creUpDeBase(conn, DTOs);
            conn.commit();
            return flags;
        }
        catch (Exception e) {
            throw DataException.rollbackDataException(e.getMessage(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Boolean> creUpDeBase(Connection conn, List<PreparedStatementDTO> DTOs) throws SQLException {
        LinkedList<Boolean> flags = new LinkedList<Boolean>();
        for (PreparedStatementDTO dto : DTOs) {
            String sql = dto.getPrepareSql();
            LinkedList<Object> data = dto.getPrepareDataList();
            PreparedStatement statement = conn.prepareStatement(XSSEscape.escapeEmpty(sql));
            try {
                for (int i = 0; i < data.size(); ++i) {
                    statement.setObject(i + 1, data.get(i));
                }
                flags.add(statement.execute());
            }
            finally {
                if (Collections.singletonList(statement).get(0) == null) continue;
                statement.close();
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] creUpDeBatchOneSql(Connection conn, String sql, List<PreparedStatementDTO> DTOs) throws DataException {
        int[] nArray;
        block8: {
            PreparedStatement statement = conn.prepareStatement(sql);
            try {
                conn.setAutoCommit(false);
                for (PreparedStatementDTO dto : DTOs) {
                    LinkedList<Object> data = dto.getPrepareDataList();
                    for (int i = 0; i < data.size(); ++i) {
                        statement.setObject(i + 1, data.get(i));
                    }
                    statement.addBatch();
                }
                int[] ints = statement.executeBatch();
                conn.commit();
                nArray = ints;
                if (Collections.singletonList(statement).get(0) == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(statement).get(0) != null) {
                        statement.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw DataException.rollbackDataException(e.getMessage(), conn);
                }
            }
            statement.close();
        }
        return nArray;
    }

    public static List<Map<String, Object>> queryList(PreparedStatementDTO statementDTO) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("mapMods");
        return JdbcUtil.query(statementDTO, jdbcDTO).getMapMods();
    }

    public static List<Map<String, Object>> queryListAlias(PreparedStatementDTO statementDTO) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("mapMods");
        jdbcDTO.setAliasFlag(true);
        return JdbcUtil.query(statementDTO, jdbcDTO).getMapMods();
    }

    public static List<Map<String, Object>> queryListLowercase(PreparedStatementDTO statementDTO) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("mapMods");
        jdbcDTO.setLowercaseFlag(true);
        return JdbcUtil.query(statementDTO, jdbcDTO).getMapMods();
    }

    public static Map<String, Object> queryOne(PreparedStatementDTO statementDTO) throws DataException {
        List<Map<String, Object>> mapList = JdbcUtil.queryList(statementDTO);
        return mapList.size() > 0 ? mapList.get(0) : new HashMap();
    }

    public static Integer queryOneInt(PreparedStatementDTO statementDTO, String keyWord) throws DataException {
        List<Map<String, Object>> mapList = JdbcUtil.queryList(statementDTO);
        if (mapList.size() > 0) {
            keyWord = DbAliasEnum.getAsByDb(DbTypeUtil.getDb(statementDTO.getConn()), keyWord);
            Map<String, Object> map = CollectionUtils.mapKeyToLower(JdbcUtil.queryOne(statementDTO));
            return Integer.parseInt(String.valueOf(map.get(keyWord.toLowerCase())));
        }
        throw new DataException(MsgCode.FA020.get());
    }

    public static List<List<DbFieldMod>> queryIncludeFieldMods(PreparedStatementDTO statementDTO) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("includeFieldMods");
        return JdbcUtil.query(statementDTO, jdbcDTO).getIncludeFieldMods();
    }

    public static List<List<DbFieldMod>> queryTableFields(PreparedStatementDTO statementDTO) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("tableFieldMod");
        return JdbcUtil.query(statementDTO, jdbcDTO).getTableFieldMods();
    }

    public static <T extends JdbcGetMod> List<T> queryCustomMods(PreparedStatementDTO statementDTO, Class<T> modType) throws DataException {
        JdbcDTO<T> jdbcDTO = new JdbcDTO<T>();
        jdbcDTO.setReturnType("customMods");
        jdbcDTO.setModType(modType);
        jdbcDTO.setDbBase(DbTypeUtil.getDb(statementDTO.getConn()));
        return JdbcUtil.query(statementDTO, jdbcDTO).getCustomMods();
    }

    public static JdbcPageMod queryPage(PreparedStatementDTO statementDTO, String sortType, Integer currentPage, Integer pageSize, JdbcDTO jdbcDTO) throws DataException {
        DbBase db = DbTypeUtil.getDb(statementDTO.getConn());
        SqlBase sqlBase = db.getSqlBase();
        String[] sqlArray = sqlBase.getPageSql(statementDTO.getPrepareSql(), sortType, currentPage, pageSize);
        JdbcPageMod pageModel = new JdbcPageMod();
        String selectSql = "";
        try {
            selectSql = sqlArray[0];
            statementDTO.setPrepareSql(selectSql);
            List<?> resultData = JdbcUtil.query(statementDTO, jdbcDTO).getData();
            pageModel.setDataList(resultData);
            selectSql = sqlArray[1];
            statementDTO.setPrepareSql(selectSql);
            pageModel.setTotalRecord(JdbcUtil.queryOneInt(statementDTO, DbAliasEnum.TOTAL_RECORD.asByDb(db)));
            pageModel.setCurrentPage(currentPage);
            pageModel.setPageSize(pageSize);
        }
        catch (DataException e) {
            log.error("\u5728\u7ebf\u5217\u8868sql\u8bed\u53e5\u9519\u8bef\uff1a" + selectSql);
            throw new DataException("sql\u5f02\u5e38\uff1a" + selectSql);
        }
        return pageModel;
    }

    public static JdbcPageMod queryPage(PreparedStatementDTO statementDTO, String sortType, Integer currentPage, Integer pageSize) throws DataException {
        JdbcDTO jdbcDTO = new JdbcDTO();
        jdbcDTO.setReturnType("mapMods");
        jdbcDTO.setAliasFlag(true);
        return JdbcUtil.queryPage(statementDTO, sortType, currentPage, pageSize, jdbcDTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends JdbcGetMod> JdbcDTO<T> query(PreparedStatementDTO statementDTO, JdbcDTO<T> jdbcDTO) throws DataException {
        try {
            String sql = statementDTO.getPrepareSql();
            Connection conn = statementDTO.getConn();
            LinkedList<Object> prepareDataList = statementDTO.getPrepareDataList();
            PreparedStatement statement = conn.prepareStatement(XSSEscape.escapeEmpty(sql));
            try {
                if (!prepareDataList.isEmpty()) {
                    for (int i = 0; i < prepareDataList.size(); ++i) {
                        Object dataObject = prepareDataList.get(i);
                        statement.setObject(i + 1, dataObject);
                    }
                }
                ResultSet result = statement.executeQuery();
                try {
                    if (result == null) throw new DataException(MsgCode.DB004.get());
                    JdbcDTO<T> jdbcDTO2 = JdbcUtil.getList(result, jdbcDTO);
                    return jdbcDTO2;
                }
                finally {
                    if (Collections.singletonList(result).get(0) != null) {
                        result.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(statement).get(0) != null) {
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Connection conn, PreparedStatement pps, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pps != null) {
                    pps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T extends JdbcGetMod> JdbcDTO<T> getList(ResultSet result, JdbcDTO<T> jdbcDTO) throws Exception {
        ArrayList<JdbcGetMod> customMods = new ArrayList<JdbcGetMod>();
        ArrayList<Map<String, Object>> mapMods = new ArrayList<Map<String, Object>>();
        ArrayList<List<DbFieldMod>> includeFieldMods = new ArrayList<List<DbFieldMod>>();
        ArrayList<List<DbFieldMod>> tableFieldMods = new ArrayList<List<DbFieldMod>>();
        if ("mapMods".equals(jdbcDTO.getReturnType())) {
            while (result.next()) {
                mapMods.add(JdbcUtil.getModel0(result, jdbcDTO));
            }
        } else if ("includeFieldMods".equals(jdbcDTO.getReturnType())) {
            while (result.next()) {
                includeFieldMods.add(JdbcUtil.getModel1(result, jdbcDTO));
            }
        } else if ("tableFieldMod".equals(jdbcDTO.getReturnType())) {
            tableFieldMods.add(JdbcUtil.getModel3(result, jdbcDTO));
        } else if ("customMods".equals(jdbcDTO.getReturnType())) {
            while (result.next()) {
                JdbcGetMod newT = (JdbcGetMod)jdbcDTO.getModType().newInstance();
                customMods.add(JdbcUtil.getModel2(new ModelDTO(result, jdbcDTO.getDbBase()), newT));
            }
        }
        jdbcDTO.setCustomMods(customMods);
        jdbcDTO.setMapMods(mapMods);
        jdbcDTO.setIncludeFieldMods(includeFieldMods);
        jdbcDTO.setTableFieldMods(tableFieldMods);
        return jdbcDTO;
    }

    private static <T> Map<String, Object> getModel0(ResultSet rs, JdbcDTO<T> jdbcDTO) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String fieldName = jdbcDTO.getAliasFlag() != false ? md.getColumnLabel(i) : md.getColumnName(i);
            fieldName = jdbcDTO.getLowercaseFlag() != false ? fieldName.toLowerCase() : fieldName;
            map.put(fieldName, XSSEscape.escapeEmpty(rs.getString(i)));
        }
        return map;
    }

    private static <T> List<DbFieldMod> getModel1(ResultSet rs, JdbcDTO<T> jdbcDTO) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList<DbFieldMod> list = new ArrayList<DbFieldMod>();
        for (int i = 1; i <= columnCount; ++i) {
            list.add(new DbFieldMod(md.getTableName(i), md.getColumnLabel(i), md.getColumnName(i), md.getColumnTypeName(i), md.getColumnType(i), XSSEscape.escapeEmpty(rs.getString(i)), jdbcDTO.getLowercaseFlag()));
        }
        return list;
    }

    private static <T extends JdbcGetMod> T getModel2(ModelDTO modelDTO, T t) throws SQLException {
        t.setMod(modelDTO);
        t = XSSEscape.escapeObj(t);
        return t;
    }

    private static <T> List<DbFieldMod> getModel3(ResultSet rs, JdbcDTO<T> jdbcDTO) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        ArrayList<DbFieldMod> dbFieldModList = new ArrayList<DbFieldMod>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            dbFieldModList.add(new DbFieldMod(md.getTableName(i), md.getColumnLabel(i), md.getColumnName(i), md.getColumnTypeName(i), md.getColumnType(i), null, jdbcDTO.getLowercaseFlag()));
        }
        return dbFieldModList;
    }

    private static <T> Map<String, Object> getModel4(ResultSet rs, JdbcDTO<T> jdbcDTO) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String fieldName = jdbcDTO.getLowercaseFlag() != false ? md.getColumnName(i).toLowerCase() : md.getColumnName(i);
            map.put(fieldName, rs.getString(i));
        }
        return map;
    }
}

