/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.i18n.core;

import com.bringspring.common.constant.model.MCode;
import com.bringspring.common.i18n.provider.I18nMessageProvider;
import java.text.MessageFormat;
import java.util.Locale;
import org.springframework.context.support.AbstractMessageSource;

public class DynamicMessageSource
extends AbstractMessageSource {
    private I18nMessageProvider i18nMessageProvider;

    public DynamicMessageSource(I18nMessageProvider i18nMessageProvider) {
        this.i18nMessageProvider = i18nMessageProvider;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MCode i18nMessage = this.i18nMessageProvider.getI18nMessage(code, locale);
        if (i18nMessage != null) {
            return this.createMessageFormat(i18nMessage.getDesc(), locale);
        }
        return null;
    }
}

