/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.i18n.core;

import cn.hutool.core.util.ReflectUtil;
import com.bringspring.common.i18n.provider.MessageSourceProvider;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class MyReloadableResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyReloadableResourceBundleMessageSource.class);
    private final ConcurrentMap<String, ReloadableResourceBundleMessageSource.PropertiesHolder> cachedPropertiesCopy;
    private final ConcurrentMap<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder> cachedMergedPropertiesCopy;
    private List<MessageSourceProvider> messageSourceProviders;

    public MyReloadableResourceBundleMessageSource(List<MessageSourceProvider> messageSourceProviders) {
        this.messageSourceProviders = messageSourceProviders;
        this.cachedPropertiesCopy = (ConcurrentMap)ReflectUtil.getFieldValue((Object)((Object)this), (String)"cachedProperties");
        this.cachedMergedPropertiesCopy = (ConcurrentMap)ReflectUtil.getFieldValue((Object)((Object)this), (String)"cachedMergedProperties");
    }

    protected ReloadableResourceBundleMessageSource.PropertiesHolder refreshProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        if ((propHolder = super.refreshProperties(filename, propHolder)).getProperties() == null && this.messageSourceProviders != null) {
            for (MessageSourceProvider messageSourceProvider : this.messageSourceProviders) {
                try {
                    String config = messageSourceProvider.loadMessageResource(filename, this);
                    if (config == null) continue;
                    propHolder = this.refreshConfig(filename, config);
                    break;
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7d\u8bed\u8a00\u914d\u7f6e\u5931\u8d25\uff1a{}, {}", new Object[]{filename, e.getMessage(), e});
                }
            }
        }
        return propHolder;
    }

    public ReloadableResourceBundleMessageSource.PropertiesHolder refreshConfig(String filename, String config) throws IOException {
        long refreshTimestamp = this.getCacheMillis() < 0L ? -1L : System.currentTimeMillis();
        Properties properties = new Properties();
        properties.load(new StringReader(config));
        ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, refreshTimestamp);
        propertiesHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedPropertiesCopy.put(filename, propertiesHolder);
        this.cachedMergedPropertiesCopy.clear();
        return propertiesHolder;
    }

    public void refreshConfig(String filename, String property, String value) {
        ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = (ReloadableResourceBundleMessageSource.PropertiesHolder)this.cachedPropertiesCopy.get(filename);
        Properties properties = propertiesHolder.getProperties();
        if (properties != null) {
            properties.setProperty(property, value);
            this.cachedMergedPropertiesCopy.clear();
        }
    }

    @Generated
    public ConcurrentMap<String, ReloadableResourceBundleMessageSource.PropertiesHolder> getCachedPropertiesCopy() {
        return this.cachedPropertiesCopy;
    }

    @Generated
    public ConcurrentMap<Locale, ReloadableResourceBundleMessageSource.PropertiesHolder> getCachedMergedPropertiesCopy() {
        return this.cachedMergedPropertiesCopy;
    }
}

