/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.springframework.web.multipart.MultipartFile;

public class CustomMultipartFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    private final String contentType;
    private final byte[] content;

    public CustomMultipartFile(File file) throws IOException {
        this.originalFilename = file.getName();
        this.name = "file";
        this.contentType = Files.probeContentType(file.toPath());
        this.content = Files.readAllBytes(file.toPath());
    }

    public CustomMultipartFile(String name, String originalFilename, String contentType, byte[] content) {
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.length == 0;
    }

    public long getSize() {
        return this.content != null ? (long)this.content.length : 0L;
    }

    public byte[] getBytes() throws IOException {
        return (byte[])this.content.clone();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        Files.write(dest.toPath(), this.content, new OpenOption[0]);
    }
}

