/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JsonUtil {
    public static List listToJsonField(List lists) {
        String jsonStr = JSONArray.toJSONString((Object)lists, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List list = (List)JSONArray.parseObject((String)jsonStr, List.class);
        return list;
    }

    public static Map<String, Object> entityToMap(Object object) {
        String jsonStr = JSONObject.toJSONString((Object)object);
        Map map = (Map)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        return map;
    }

    public static Map<String, Object> stringToMap(String object) {
        Map map = (Map)JSONObject.parseObject((String)object, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        return map;
    }

    public static <T> T getJsonToBean(String jsonData, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonData, clazz);
    }

    public static JSONArray getJsonToJsonArray(String json) {
        return JSONArray.parseArray((String)json);
    }

    public static <T> JSONArray getListToJsonArray(List<T> list) {
        return JSONArray.parseArray((String)JsonUtil.getObjectToString(list));
    }

    public static String getObjectToString(Object object) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public static String getObjectToStringDateFormat(Object object, String dateFormat) {
        JSON.defaultTimeZone = TimeZone.getTimeZone(ZoneId.of("+8"));
        return JSON.toJSONStringWithDateFormat((Object)object, (String)dateFormat, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public static <T> T getJsonToBeanEx(Object dto, Class<T> clazz) throws DataException {
        if (dto == null) {
            throw new DataException(MsgCode.FA001.get());
        }
        return (T)JSON.parseObject((String)JsonUtil.getObjectToString(dto), clazz);
    }

    public static <T> List<T> getJsonToList(String jsonData, Class<T> clazz) {
        return JSON.parseArray((String)jsonData, clazz);
    }

    public static List<Map<String, Object>> getJsonToListMap(String jsonData) {
        return (List)JSON.parseObject((String)jsonData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
    }

    public static List<Map<String, Object>> getJsonToList(JSONArray jsonArray) {
        return (List)JSON.parseObject((String)JSON.toJSONString((Object)jsonArray), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
    }

    public static <T> T getJsonToBean(Object dto, Class<T> clazz) {
        return (T)JSON.parseObject((String)JsonUtil.getObjectToString(dto), clazz);
    }

    public static <T> List<T> getJsonToList(Object dto, Class<T> clazz) {
        return JSON.parseArray((String)JsonUtil.getObjectToString(dto), clazz);
    }

    public static boolean isJSONString(String content) {
        if (StringUtils.isEmpty(content)) {
            return false;
        }
        if (!content.startsWith("{") || !content.endsWith("}")) {
            return false;
        }
        try {
            JSONObject.parse((String)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

