/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.bringspring.common.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    private static AntPathMatcher matcher = new AntPathMatcher();

    public static HttpServletRequest getRequest() {
        try {
            return ServletUtil.getRequestAttributes().getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHeader(String name) {
        if (ServletUtil.getRequest() != null) {
            return ServletUtil.getRequest().getHeader(name);
        }
        return null;
    }

    public static boolean getIsMobileDevice() {
        return ServletUtil.isMobileDevice(ServletUtil.getUserAgent());
    }

    public static boolean getIsMobileDevice(String userAgent) {
        return ServletUtil.isMobileDevice(userAgent);
    }

    public static String getUserAgent() {
        return ServletUtil.getHeader("User-Agent");
    }

    public static boolean isMobileDevice(String requestHeader) {
        UserAgent userAgent = UserAgentUtil.parse((String)requestHeader);
        if (userAgent == null) {
            return false;
        }
        return userAgent.isMobile();
    }

    public static String getServletPath() {
        return ServletUtil.getRequest().getServletPath();
    }

    public static HttpServletResponse getResponse() {
        try {
            return ServletUtil.getRequestAttributes().getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        try {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            return (ServletRequestAttributes)attributes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = request.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public static Map<String, Object> getParams(HttpServletRequest request) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null) {
            while (parameterNames.hasMoreElements()) {
                String key = (String)parameterNames.nextElement();
                if (key == null) continue;
                parameters.put(key, request.getParameter(key));
            }
        }
        return parameters;
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (StringUtils.inStringIgnoreCase(uri, ".json", ".xml")) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return StringUtils.inStringIgnoreCase(ajax, "json", "xml");
    }

    public static Map<String, String> getPathVariables(String pattern, String path) {
        Map vars = null;
        try {
            if (!StringUtils.isEmpty(path)) {
                vars = matcher.extractUriTemplateVariables(pattern, path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vars == null) {
            vars = Collections.EMPTY_MAP;
        }
        return vars;
    }

    public static Map<String, String> getPathVariables(String pattern) {
        return ServletUtil.getPathVariables(pattern, ServletUtil.getServletPath());
    }

    public static String getRequestHost() {
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            String host = request.getHeader("MY_HOST");
            if (StringUtils.isEmpty(host)) {
                host = request.getHeader("X-Forwarded-Host");
                if (StringUtils.isNotEmpty(host)) {
                    int index = host.lastIndexOf(",");
                    if (index != -1) {
                        return host.substring(index);
                    }
                    return host;
                }
                host = request.getHeader("Host");
            }
            if (StringUtils.isNotEmpty(host)) {
                return host;
            }
        }
        return "";
    }
}

