/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.wxutil;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class HttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(5000L, TimeUnit.MILLISECONDS).setConnectTimeout(5000L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(3000L, TimeUnit.MILLISECONDS).build();

    private HttpUtil() {
        throw new IllegalAccessError("\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static CloseableHttpClient getHttpClient() {
        return HttpUtil.getHttpClientBuilder().build();
    }

    public static CloseableHttpClient getHttpClient(SSLContext sslContext) {
        return HttpUtil.getHttpClientBuilder(sslContext).build();
    }

    public static HttpClientBuilder getHttpClientBuilder() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
    }

    public static HttpClientBuilder getHttpClientBuilder(SSLContext sslContext) {
        if (sslContext != null) {
            SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).build();
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig);
        }
        return HttpUtil.getHttpClientBuilder();
    }

    public static String sendHttpPost(String httpUrl, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpUtil.sendHttpPost(httpPost, sslContext);
    }

    public static String sendHttpPost(String httpUrl) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpUtil.sendHttpPost(httpPost, null);
    }

    public static String sendHttpPost(String httpUrl, String params) {
        return HttpUtil.sendHttpPost(httpUrl, params, null);
    }

    public static String sendHttpPost(String httpUrl, String params, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        try {
            StringEntity stringEntity = new StringEntity(params, ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8));
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return HttpUtil.sendHttpPost(httpPost, sslContext);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps) {
        return HttpUtil.sendHttpPost(httpUrl, maps, null);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps, SSLContext sslContext) {
        HttpPost httpPost = HttpUtil.wrapHttpPost(httpUrl, maps);
        return HttpUtil.sendHttpPost(httpPost, null);
    }

    public static HttpPost wrapHttpPost(String httpUrl, Map<String, String> maps) {
        HttpPost httpPost = new HttpPost(httpUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> m : maps.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(m.getKey(), m.getValue()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return httpPost;
    }

    public static String sendHttpPost(String httpUrl, File file) {
        return HttpUtil.sendHttpPost(httpUrl, (Map<String, File>)ImmutableMap.of((Object)"media", (Object)file), null, null);
    }

    public static String sendHttpPost(String httpUrl, File file, Map<String, String> maps) {
        return HttpUtil.sendHttpPost(httpUrl, (Map<String, File>)ImmutableMap.of((Object)"media", (Object)file), maps, null);
    }

    public static String sendHttpPost(String httpUrl, List<File> fileLists, Map<String, String> maps) {
        return HttpUtil.sendHttpPost(httpUrl, fileLists, maps, null);
    }

    public static String sendHttpPost(String httpUrl, Map<String, File> fileMap, Map<String, String> maps) {
        return HttpUtil.sendHttpPost(httpUrl, fileMap, maps, null);
    }

    public static String sendHttpPost(String httpUrl, List<File> fileLists, Map<String, String> maps, SSLContext sslContext) {
        HashMap<String, File> fileMap = new HashMap<String, File>(16);
        if (fileLists != null && !fileLists.isEmpty()) {
            for (File file : fileLists) {
                fileMap.put("media", file);
            }
        }
        return HttpUtil.sendHttpPost(httpUrl, fileMap, maps, sslContext);
    }

    public static String sendHttpPost(String httpUrl, Map<String, File> fileMap, Map<String, String> maps, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        MultipartEntityBuilder meBuilder = MultipartEntityBuilder.create();
        if (null != maps) {
            for (Map.Entry<String, Object> entry : maps.entrySet()) {
                meBuilder.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.TEXT_PLAIN));
            }
        }
        if (null != fileMap) {
            for (Map.Entry<String, Object> entry : fileMap.entrySet()) {
                FileBody fileBody = new FileBody((File)entry.getValue());
                meBuilder.addPart(entry.getKey(), (ContentBody)fileBody);
            }
        }
        HttpEntity reqEntity = meBuilder.build();
        httpPost.setEntity(reqEntity);
        return HttpUtil.sendHttpPost(httpPost, sslContext);
    }

    public static String sendHttpPost(HttpPost httpPost) {
        return HttpUtil.sendHttpPost(httpPost, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String sendHttpPost(HttpPost httpPost, SSLContext sslConext) {
        try (CloseableHttpClient httpClient = HttpUtil.getHttpClient(sslConext);){
            String string;
            block14: {
                CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);
                try {
                    HttpEntity entity = response.getEntity();
                    String responseContent = EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                    string = responseContent;
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sendHttpGet(String httpUrl) {
        return HttpUtil.sendHttpGet(httpUrl, null);
    }

    public static String sendHttpGet(String httpUrl, SSLContext sslConext) {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpUtil.sendHttpGet(httpGet, sslConext);
    }

    public static String sendHttpGet(HttpGet httpGet) {
        return HttpUtil.sendHttpGet(httpGet, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String sendHttpGet(HttpGet httpGet, SSLContext sslConext) {
        try (CloseableHttpClient httpClient = HttpUtil.getHttpClient(sslConext);){
            String string;
            block14: {
                CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);
                try {
                    HttpEntity entity = response.getEntity();
                    String responseContent = EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                    string = responseContent;
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isWxError(JSONObject jsonObject) {
        return null == jsonObject || jsonObject.getIntValue("errcode") != 0;
    }

    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        return HttpUtil.httpRequest(requestUrl, requestMethod, outputStr, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr, String ... token) {
        JSONObject jsonObject = null;
        try {
            String agent;
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(6000);
            conn.setRequestProperty("Content-Type", "application/json");
            if (StringUtils.isNotEmpty(token)) {
                conn.setRequestProperty("Authorization", XSSEscape.escape(token[0]));
                if (token.length > 1 && StringUtils.isNotEmpty(token[1])) {
                    Map<String, Object> requestHeader = JsonUtil.stringToMap(token[1]);
                    for (String field : requestHeader.keySet()) {
                        conn.setRequestProperty(field, String.valueOf(requestHeader.get(field)));
                    }
                }
            }
            if (StringUtils.isNotEmpty(agent = ServletUtils.getUserAgent())) {
                conn.setRequestProperty("User-Agent", agent);
            }
            if (StringUtils.isNotEmpty(outputStr)) {
                OutputStream outputStream = conn.getOutputStream();
                try {
                    outputStream.write(outputStr.getBytes(StandardCharsets.UTF_8));
                    outputStream.close();
                }
                finally {
                    if (Collections.singletonList(outputStream).get(0) != null) {
                        outputStream.close();
                    }
                }
            }
            InputStream inputStream = conn.getInputStream();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                try {
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        String str = null;
                        StringBuffer buffer = new StringBuffer();
                        while ((str = bufferedReader.readLine()) != null) {
                            buffer.append(str);
                        }
                        bufferedReader.close();
                        inputStreamReader.close();
                        inputStream.close();
                        conn.disconnect();
                        jsonObject = JSONObject.parseObject((String)buffer.toString());
                        if (jsonObject != null) return jsonObject;
                        JSONObject jSONObject = new JSONObject();
                        return jSONObject;
                    }
                    finally {
                        if (Collections.singletonList(bufferedReader).get(0) != null) {
                            bufferedReader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(inputStreamReader).get(0) != null) {
                        inputStreamReader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            jsonObject = new JSONObject();
            jsonObject.put("errcode", (Object)-1);
            jsonObject.put("errmsg", (Object)e.getMessage());
        }
        return jsonObject;
    }

    public static void main(String[] args) throws Exception {
        JSONObject param = new JSONObject();
        boolean get = HttpUtil.httpCronRequest("http://192.168.20.128:30000/api/scheduletask", "GET", null, "bearer eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInNjb3BlIjpbImFsbCJdLCJzaW5nbGVMb2dpbiI6IjEiLCJleHAiOjE2NDY4MzU2MTEsImp0aSI6ImQ2MTVhZDEyLWI0NmItNDgwOC04YmI2LWNhZTY2Y2QyZDVhYSIsImNsaWVudF9pZCI6ImFkbWluIiwidG9rZW4iOiJsb2dpbl90b2tlbl8yNzExODY5NTgxMTIyNjExMjUifQ.E-sPzi1dFoNh-q-cVHn3jti6cxDm1y2fiH8UVYtAYcsoFwZSvx6oubkUefB7xkE9VhCh_syGLbuYhZvRrUAtY-YfH0GG_sNIQXXrzjjieEtpynyBeCGjjZ2U46InjJhOXDMW9FMQS1VSuIx_Z5FuKV93M7kZcAO4ZxhxYcG1_3R4zscxx2hed8ChQvVWf8nbcnuZBUYffan26Y4Fecvi6b0yGrQE_Tmu1D0TjBnsJ5SugRcA_9IxDHIA2H8NfI4tVmeWMVqvNomjBzJaxWZkuXsA-CTzGUvaz9wpRfskh6qTrpnnNpc5p7KsCfkV_Se6KCvfnmD4eNJ27zRvHg1WJA");
    }

    public static boolean httpCronRequest(String requestUrl, final String requestMethod, final String outputStr, final String token) {
        boolean falg = false;
        try {
            final URL url = new URL(requestUrl);
            final HttpURLConnection[] conn = new HttpURLConnection[]{null};
            Callable<String> task = new Callable<String>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public String call() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            ThreadPoolTaskExecutor executor = SpringContext.getBean(ThreadPoolTaskExecutor.class);
            Future future = executor.submit((Callable)task);
            try {
                String rst = (String)future.get(3L, TimeUnit.SECONDS);
                if ("url\u8fde\u63a5ok".equals(rst)) {
                    falg = true;
                }
            }
            catch (TimeoutException e) {
                log.error("\u8fde\u63a5url\u8d85\u65f6");
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5f02\u5e38," + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return falg;
    }
}

