package com.bringspring.common.auth.granter;

import com.bringspring.common.auth.config.JsbosOauthConfig;
import com.bringspring.common.auth.consts.AuthConsts;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.exception.LoginException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 *
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Component
public class TokenGranterBuilder {

    @Autowired
    private JsbosOauthConfig oauthConfig;

    private final Map<String, TokenGranter> granterPool = new ConcurrentHashMap<>();

    public TokenGranterBuilder(Map<String, TokenGranter> granterPool) {
        granterPool.forEach(this.granterPool::put);
    }

    /**
     * 获取TokenGranter
     *
     * @param grantType 授权类型
     * @return ITokenGranter
     */
    public TokenGranter getGranter(String grantType) throws LoginException {
        TokenGranter tokenGranter = null;
        // 内部登录需要放行
        if(!oauthConfig.getSsoEnabled() || "tempuser".equalsIgnoreCase(grantType)) {
            tokenGranter = granterPool.get(grantType);
        }
        if(tokenGranter == null){
            //URL匹配
            for (TokenGranter value : granterPool.values()) {
                if(value.requiresAuthentication()){
                    tokenGranter = value;
                    break;
                }
            }
        }
        if(tokenGranter == null){
            if(oauthConfig.getSsoEnabled()) {
                throw new LoginException(MsgCode.LOG111.get());
            }else{
                throw new LoginException(MsgCode.LOG112.get());
            }
        }
        return tokenGranter;
    }


    /**
     * 获取当前登录用户的TokenGranter
     * @return
     * @throws LoginException
     */
    public TokenGranter getGranterByLogin(String grandType) {
        if(grandType == null || grandType.isEmpty()){
            UserInfo userInfo = UserProvider.getUser();
            if(userInfo.getGrantType() != null){
                grandType = userInfo.getGrantType();
            }else {
                grandType = AuthConsts.GRANT_TYPE_PASSWORD;
            }
        }
        return granterPool.get(grandType);
    }


}
