package com.bringspring.common.base;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:47
 */
public enum ActionResultCode{

    /**
     * 成功
     */
    Success(200, "成功"),
    /**
     * 警告
     */
    Warning(444, "警告"),
    /**
     * 失败
     */
    Fail(400, "失败"),
    /**
     * 验证错误
     */
    ValidateError(401, "验证错误"),
    /**
     * 异常
     */
    Exception(500, "异常"),
    /**
     * 登录过期
     */
    SessionOverdue(600, "登录过期,请重新登录"),
    /**
     * 异地登录
     */
    SessionOffLine(601, "您的帐号在其他地方已登录,被强制踢出"),
    /**
     * token验证失败
     */
    SessionError(602, "Token验证失败"),

    /**
     * 证书无效
     */
    LicenseError(603, "您的证书无效，请核查服务器是否取得授权或重新申请证书！"),

    /**
     * 微信公众号授权过期
     */
    WxMpAuthError(501, "微信公众号授权过期，请重新授权！"),

    /**
     * 微信公众号未绑定手机号
     */
    WxMpBindError(502, "微信公众号未绑定手机号！"),
    ;

    private int code;
    private String message;

    ActionResultCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
