package com.bringspring.common.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:54
 */
@Data
public class Pagination extends Page{
    @Schema(description = "每页条数", example = "20")
    private long pageSize=20;
    @Schema(description = "排序类型")
    private String sort="desc";
    @Schema(description = "排序列")
    private String sidx="";
    @Schema(description = "当前页数", example = "1")
    private long currentPage=1;


    @Schema(hidden = true)
    @JsonIgnore
    private long total;
    @Schema(hidden = true)
    @JsonIgnore
    private long records;

    public <T> List<T> setData(List<T> data, long records) {
        this.total = records;
        return data;
    }
}
