package com.bringspring.common.constant;

import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 功能中所用常量
 *
 * @author RKKJ开发平台组
 * @version V3.5.0
 * @copyright 荣科科技股份有限公司
 * @date 2023/6/6 15:08:10
 */
@Data
public class JsbosConst {

    /**
     * 被过滤的系统菜单常量
     */
    public static final String MAIN_SYSTEM_CODE = "mainSystem";

    /**
     * 业务平台编码
     */
    public static final String WORK_SYSTEM_CODE = "workSystem";

    /**
     * 流程中心
     */
    public static final String WORK_FLOW_CODE = "workFlow";

    /**
     * 协作模块
     */
    public static final String TEAMWORK_CODE = "teamwork";

    /**
     * 应用设置
     */
    public static final String APP_CONFIG_CODE = "appConfig";

    /**
     * 在线开发
     */
    public static final String ONLINE_DEV_CODE = "onlineDev";

    //发起流程
    public static final String WORK_FLOWQUICKLAUNCH = "workFlow.flowQuickLaunch";
    //我发起的
    public static final String WORK_FLOWLAUNCH = "workFlow.flowLaunch";
    //我的待签
    public static final String WORK_FLOWSIGN = "workFlow.flowToSign";
    //我的待办
    public static final String WORK_FLOWTODO = "workFlow.flowTodo";
    //我的在办
    public static final String WORK_FLOWDOING = "workFlow.flowDoing";
    //我的已办
    public static final String WORK_FLOWDONE = "workFlow.flowDone";
    //抄送我的
    public static final String WORK_FLOWCIRCULATE = "workFlow.flowCirculate";

    /**
     * 被过滤的系统菜单常量
     */
    public static final List<String> MODULE_CODE = new ArrayList() {{
        add(WORK_FLOW_CODE);//流程中心
        add(WORK_FLOWQUICKLAUNCH);//发起流程
        add(WORK_FLOWLAUNCH);//我的发起
        add(WORK_FLOWSIGN);//我的待签
        add(WORK_FLOWTODO);//我的待办
        add(WORK_FLOWDOING);//我的在办
        add(WORK_FLOWDONE);//我的已办
        add(WORK_FLOWCIRCULATE);//抄送我的
    }};

    //日程安排
    public static final String TEAMWORK_SCHEDULE = "teamwork.schedule";
    //打印文件
    public static final String TEAMWORK_PRINTTEMPLATE = "teamwork.printTemplate";
    //文档中心
    public static final String TEAMWORK_DOCUMENT = "teamwork.document";
    /**
     * 协作模块菜单列表
     */
    public static final List<String> TEAMWORK_MODULE = new ArrayList() {{
        add(TEAMWORK_CODE);//协同办公
        add(TEAMWORK_SCHEDULE);//日程安排
        add(TEAMWORK_PRINTTEMPLATE);//打印文件
        add(TEAMWORK_DOCUMENT);//文档中心
    }};

    /**
     * 应用设置模块菜单列表
     */
    public static final List<String> APP_CONFIG_MODULE = new ArrayList() {{
        add("appConfig");//应用设置
        add("appConfig.baseConfig");//基础设置
        add("appConfig.appMenu");//应用菜单
        add("appConfig.appResource");//应用资源
        add("appConfig.appAuth");//应用授权
    }};

    /**
     * 在线开发模块菜单列表
     */
    public static final List<String> ONLINE_DEV_MODULE = new ArrayList() {{
        add("onlineDev");//在线开发
        add("onlineDev.formDesign");//表单设计
        add("onlineDev.visualPortal");//门户设计
        add("onlineDev.report");//报表设计
        add("onlineDev.dataReport");//报表设计(原)
        add("onlineDev.printDev");//打印设计
        add("onlineDev.dataScreen");//大屏设计
        add("onlineDev.flowEngine");//流程设计
        add("onlineDev.sysForm");//表单回传
    }};

    /**
     * 当前组织
     */
    public static final String CURRENT_ORG = "@currentOrg";
    public static final String CURRENT_ORG_TYPE = "@currentOrg--system";

    /**
     * 当前组织及子组织
     */
    public static final String CURRENT_ORG_SUB = "@currentOrgAndSubOrg";
    public static final String CURRENT_ORG_SUB_TYPE = "@currentOrgAndSubOrg--system";

    /**
     * 当前分管组织
     */
    public static final String CURRENT_GRADE = "@currentGradeOrg";
    public static final String CURRENT_GRADE_TYPE = "@currentGradeOrg--system";

    /**
     * 高级控件系统参数
     */
    public static final Map<String, String> SYSTEM_PARAM = new HashMap() {{
        put(CURRENT_ORG, "当前组织");
        put(CURRENT_ORG_SUB, "当前组织及子组织");
        put(CURRENT_GRADE, "当前分管组织");
        put(CURRENT_ORG_TYPE, "当前组织");
        put(CURRENT_ORG_SUB_TYPE, "当前组织及子组织");
        put(CURRENT_GRADE_TYPE, "当前分管组织");
    }};

    /**
     * 在线开发数据日志事件key
     */
    public static final String VSLOG_EVENT_KEY = "vslogEventKey";

    public static String FIELD_SUFFIX_JSBOSID = "_jsbosId";

    /**
     * pc端
     */
    public final static String WEB = "Web";

    /**
     * 手机端
     */
    public final static String APP = "App";

    /**
     * 副表标记
     */
    public static String SIDE_MARK = "_jsbos_";
    /**
     * 副表标记
     */
    public static String SIDE_MARK_PRE = "jsbos_";
    /**
     * 副表正则
     */
    public static String SIDE_REGULAR = "^[jsbos_]\\S*_jsbos\\S*";

    public static final String CREAT_DEP ="create_department";
    public static final String UPDATE_DEP ="update_department";
    public static final String DELETE_DEP ="delete_department";
    public static final String SOCIALS_CONFIG = "SocialsConfig";
    public static final String QYH_DEPARTMENT = "qyhDepartment";
    public static final String DING_DEPARTMENT = "dingDepartment";
}
