package com.bringspring.common.constant;

import com.bringspring.common.constant.model.MCode;

/**
 * 常用提示信息
 *
 * @author RKKJ开发平台组 YanYu
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/12/20
 */
public interface MsgCode {

    /**
     * 编码和提示语正则提取 MCode\s+[\w\d]+\s+=\s+[\w\d]+[(]"([\w\d]+)"\s*,\s*"(.+)"[)];
     */

    /**
     * 执行成功：SU（success）
     */
    MCode SU000 = MSG("SU000", "Success");
    MCode SU001 = MSG("SU001", "新建成功");
    MCode SU002 = MSG("SU002", "保存成功");
    MCode SU003 = MSG("SU003", "删除成功");
    MCode SU004 = MSG("SU004", "更新成功");
    MCode SU005 = MSG("SU005", "操作成功");
    MCode SU006 = MSG("SU006", "提交成功，请耐心等待");
    MCode SU007 = MSG("SU007", "复制成功");
    MCode SU008 = MSG("SU008", "停止成功");
    MCode SU009 = MSG("SU009", "终止成功");
    MCode SU010 = MSG("SU010", "还原成功");
    MCode SU011 = MSG("SU011", "发布成功");
    MCode SU012 = MSG("SU012", "发送成功");
    MCode SU013 = MSG("SU013", "接口修改成功");
    MCode SU014 = MSG("SU014", "更新接口状态成功");
    MCode SU015 = MSG("SU015", "上传成功");
    MCode SU016 = MSG("SU016", "设置成功");
    MCode SU017 = MSG("SU017", "验证成功");
    MCode SU018 = MSG("SU018", "添加成功");
    MCode SU019 = MSG("SU019", "获取成功");
    MCode SU020 = MSG("SU020", "回滚成功");
    MCode SU021 = MSG("SU021", "移除成功");
    MCode SU022 = MSG("SU022", "查询成功");
    MCode SU023 = MSG("SU023", "修改成功");
    MCode SU024 = MSG("SU024", "部分修改成功");


    /**
     * 执行失败：FA（fail）
     */
    MCode FA001 = MSG("FA001", "此条数据不存在");
    MCode FA002 = MSG("FA002", "更新失败，数据不存在");
    MCode FA003 = MSG("FA003", "删除失败，数据不存在");
    MCode FA004 = MSG("FA004", "复制失败，数据不存在");
    MCode FA005 = MSG("FA005", "发送失败，数据不存在");
    MCode FA006 = MSG("FA006", "下载失败，数据不存在");
    MCode FA007 = MSG("FA007", "操作失败，数据不存在");
    MCode FA008 = MSG("FA008", "停止失败，数据不存在");
    MCode FA009 = MSG("FA009", "终止失败，数据不存在");
    MCode FA010 = MSG("FA010", "还原失败，数据不存在");
    MCode FA011 = MSG("FA011", "发布失败，数据不存在");
    MCode FA012 = MSG("FA012", "获取失败，数据不存在");
    MCode FA013 = MSG("FA013", "接口修改失败，数据不存在");
    MCode FA014 = MSG("FA014", "更新接口状态失败，数据不存在");
    MCode FA015 = MSG("FA015", "预览失败，数据不存在");
    MCode FA016 = MSG("FA016", "删除失败，该文件夹存在数据");
    MCode FA017 = MSG("FA017", "上传失败，文件格式不允许上传");
    MCode FA018 = MSG("FA018", "文件不存在");
    MCode FA019 = MSG("FA019", "已失效");
    MCode FA020 = MSG("FA020", "未查到信息");
    MCode FA021 = MSG("FA021", "更新失败！您没有权限操作");
    MCode FA022 = MSG("FA022", "更新失败！您没有权限操作 (角色只有超级管理员才能够操作)");
    MCode FA023 = MSG("FA023", "更新失败！无法切换组织。");
    MCode FA024 = MSG("FA024", "删除失败！已绑定用户");
    MCode FA025 = MSG("FA025", "该组织内无角色或角色权限为空，组织切换失败");
    MCode FA026 = MSG("FA026", "更新失败，关联组织不存在，请重新登录，或者刷新页面");
    MCode FA027 = MSG("FA027", "该系统下菜单为空，系统切换失败");
    MCode FA028 = MSG("FA028", "新增数据失败");
    MCode FA029 = MSG("FA029", "修改数据失败");
    MCode FA030 = MSG("FA030", "更新失败！已绑定用户，无法修改状态");
    MCode FA032 = MSG("FA032", "上传文件不能为空");
    MCode FA033 = MSG("FA033", "文件上传失败！");
    MCode FA034 = MSG("FA034", "非法请求, 缺少认证信息");
    MCode FA035 = MSG("FA035", "未获取到租户指定数据源信息");
    MCode FA036 = MSG("FA036", "常用数据已存在");
    MCode FA037 = MSG("FA037", "接口请求失败");
    MCode FA038 = MSG("FA038", "文件存储路径错误");
    MCode FA039 = MSG("FA039", "链接已失效");
    MCode FA040 = MSG("FA040", "预览失败,请检查文件类型是否规范");
    MCode FA041 = MSG("FA041", "预览失败,请重新上传文件");
    MCode FA042 = MSG("FA042", "请输入正确的文件格式");
    MCode FA043 = MSG("FA043", "存在同名文件！");
    MCode FA044 = MSG("FA044", "不存在该文件");
    MCode FA045 = MSG("FA045", "删除文件:{0}失败");
    MCode FA046 = MSG("FA046", "文件读取失败");
    MCode FA047 = MSG("FA047", "未发现文件");
    MCode FA048 = MSG("FA048", "微信公众号原始id不能重复");
    MCode FA049 = MSG("FA049", "此记录与“消息发送配置”关联引用，不允许被禁用");
    MCode FA050 = MSG("FA050", "此记录与“消息发送配置”关联引用，不允许被删除");
    MCode FA051 = MSG("FA051", "接口已配置加密, 数据解密失败.");
    MCode FA052 = MSG("FA052", "该身份未分配权限");
    MCode FA053 = MSG("FA053", "上传失败, 文件中包含不安全内容");
    MCode FA054 = MSG("FA054", "修改失败");
    MCode FA055 = MSG("FA055", "修改失败，{0}存在约束冲突");
    MCode FA056 = MSG("FA056", "当前存储不支持列出文件列表");
    MCode FA057 = MSG("FA057", "请选择组织");

    /*======1 短语======*/
    MCode FA101 = MSG("FA101", "保存失败");
    MCode FA102 = MSG("FA102", "更新失败");
    MCode FA103 = MSG("FA103", "删除失败");
    MCode FA104 = MSG("FA104", "获取失败");
    MCode FA105 = MSG("FA105", "预览失败,请先保存在预览数据");
    MCode FA106 = MSG("FA106", "预览失败,单元格配置出现死循环");
    MCode FA107 = MSG("FA107", "报表导出报错");


    /**
     * 重名判断
     */
    MCode EXIST001 = MSG("EXIST001", "名称不能重复");
    MCode EXIST002 = MSG("EXIST002", "编码不能重复");
    MCode EXIST003 = MSG("EXIST003", "模板已存在");
    MCode EXIST004 = MSG("EXIST004", "文件夹名称不能重复");
    MCode EXIST005 = MSG("EXIST005", "模板名称超过了限制长度");
    MCode EXIST101 = MSG("EXIST101", "名称重复，请重新输入");
    MCode EXIST102 = MSG("EXIST102", "编码重复，请重新输入");
    MCode EXIST103 = MSG("EXIST103", "不能重复");
    MCode EXIST104 = MSG("EXIST104", "路由地址已存在");

    /**
     * 导入导出：IMP（import/export）
     */
    MCode IMP001 = MSG("IMP001", "导入成功");
    MCode IMP002 = MSG("IMP002", "导入失败，文件格式错误");
    MCode IMP003 = MSG("IMP003", "导入失败，数据已存在");
    MCode IMP004 = MSG("IMP004", "导入失败，数据有误");
    MCode IMP005 = MSG("IMP005", "导出失败");
    MCode IMP006 = MSG("IMP006", "导入数据格式不正确");
    MCode IMP007 = MSG("IMP007", "重复");
    MCode IMP008 = MSG("IMP008", "名称");
    MCode IMP009 = MSG("IMP009", "编码");
    MCode IMP010 = MSG("IMP010", "导入失败，查询不到上级分类");
    MCode IMP011 = MSG("IMP011", "请选择导出字段");

    /**
     * 其他
     */
    // 打印模板 (print)
    MCode PRI001 = MSG("PRI001", "打印模板不存在");
    MCode PRI002 = MSG("PRI002", "数字字典不存在printDev的字典分类");
    MCode PRI003 = MSG("PRI003", "第1条SQL语句：查询出多条表头信息");
    MCode PRI004 = MSG("PRI004", "第1条SQL语句：未查出表头信息");
    MCode PRI005 = MSG("PRI005", "第{index}条SQL语句：");
    MCode PRI006 = MSG("PRI006", "已到达该模板复制上限，请复制源模板");
    MCode PRI007 = MSG("PRI007", "Sql语法错误");
    MCode PRI008 = MSG("PRI008", "该报表已删除");

    MCode COD001 = MSG("COD001", "集合条件过滤获得目标为空");

    /**
     * 复制
     */
    MCode COPY001 = MSG("COPY001", "复制名称长度超过了限制长度");


    /**
     * 登录相关
     */
    /*=====0-账号相关====*/
    MCode LOG001 = MSG("LOG001", "账户异常");
    MCode LOG002 = MSG("LOG002", "注销成功");
    MCode LOG003 = MSG("LOG003", "无效的账号");
    MCode LOG004 = MSG("LOG004", "账号异常，请联系管理员修改所属组织信息");
    MCode LOG005 = MSG("LOG005", "账号未被激活");
    MCode LOG006 = MSG("LOG006", "账号被禁用");
    MCode LOG007 = MSG("LOG007", "账号已被删除");
    MCode LOG010 = MSG("LOG010", "此IP未在白名单中，请联系管理员");
    MCode LOG011 = MSG("LOG011", "登录失败，用户暂未绑定角色");
    MCode LOG012 = MSG("LOG012", "请联系管理员解除账号锁定！");
    MCode LOG013 = MSG("LOG013", "请等待{time}分钟后再进行登录，或联系管理员解除账号锁定！");
    MCode LOG014 = MSG("LOG014", "登录时用户的账号、手机、邮箱重复，请联系管理员排查！");

    /*======1-登录相关======*/
    MCode LOG101 = LOG("LOG101", "账户或密码错误，请重新输入。");
    MCode LOG102 = LOG("LOG102", "账号有误，请重新输入。");
    MCode LOG103 = LOG("LOG103", "请输入验证码");
    MCode LOG104 = LOG("LOG104", "验证码错误");
    MCode LOG105 = LOG("LOG105", "登陆繁忙，请稍后再试");
    MCode LOG106 = LOG("LOG106", "短信验证码错误");
    MCode LOG107 = LOG("LOG107", "验证码已失效");
    MCode LOG108 = MSG("LOG108", "请等待{0}分钟后再进行登录，或联系管理员解除锁定");
    MCode LOG109 = LOG("LOG109", "租户登录失败，请用手机验证码登录");
    MCode LOG110 = LOG("LOG110", "数据库异常，请联系管理员处理");
    MCode LOG111 = LOG("LOG111", "已开启单点登录, 不支持此登录方式");
    MCode LOG112 = LOG("LOG112", "不支持此登录方式");
    MCode LOG113 = LOG("LOG113", "未设置租户信息");
    MCode LOG114 = LOG("LOG114", "租户编码不允许为空");
    MCode LOG115 = LOG("LOG115", "租户信息获取失败");
    MCode LOG116 = LOG("LOG116", "不支持此验证");
    MCode LOG117 = LOG("LOG117", "短信验证码验证失败：{0}");
    MCode LOG118 = LOG("LOG118", "租户库名为空");

    /*======2-密码修改========*/
    MCode LOG201 = LOG("LOG201", "旧密码错误");
    MCode LOG202 = LOG("LOG202", "修改成功，请牢记新密码。");
    MCode LOG203 = LOG("LOG203", "修改失败，账号不存在。");
    MCode LOG204 = LOG("LOG204", "修改失败，新建密码不能与旧密码一样");
    MCode LOG205 = LOG("LOG205", "重置密码成功");
    MCode LOG206 = LOG("LOG206", "重置密码失败");
    MCode LOG207 = LOG("LOG207", "当前账号已删除");
    MCode LOG208 = LOG("LOG208", "当前账号已禁用");
    MCode LOG209 = LOG("LOG209", "当前账号已锁定");

    //oauth
    MCode OA001 = OA("OA001", "用户登录");
    MCode OA002 = OA("OA002", "设备");
    MCode OA003 = OA("OA003", "TOKEN");
    MCode OA004 = OA("OA004", "用户退出");
    MCode OA005 = OA("OA005", "用户踢出");
    MCode OA006 = OA("OA006", "用户顶替");
    MCode OA007 = OA("OA007", "登录异常");
    MCode OA008 = OA("OA008", "登录获取系统配置失败");
    MCode OA009 = OA("OA009", "该用户未分配权限");
    MCode OA010 = OA("OA010", "仅支持pc端访问,APP端不支持");
    MCode OA011 = OA("OA011", "应用不存在");
    MCode OA012 = OA("OA012", "当前应用已被禁用");
    MCode OA013 = OA("OA013", "登录密码解密失败");
    MCode OA014 = OA("OA014", "注销成功");
    MCode OA015 = OA("OA015", "登录成功");
    MCode OA016 = OA("OA016", "登录票据已失效");
    MCode OA017 = OA("OA017", "第三方未绑定账号");
    MCode OA018 = OA("OA018", "不允许访问此登录接口");
    MCode OA019 = OA("OA019", "账号不存在");
    MCode OA020 = OA("OA020", "账户或密码错误，请重新输入");
    MCode OA021 = OA("OA021", "验证成功");
    MCode OA022 = OA("OA022", "限制会话, 不允许访问系统");
    MCode OA023 = OA("OA023", "管理员不能注销");
    MCode OA024 = OA("OA024", "登录失败");
    MCode OA025 = OA("OA025", "超级管理员");
    MCode OA026 = OA("OA026", "普通管理员");
    MCode OA027 = OA("OA027", "普通用户");
    MCode OA028 = OA("OA028", "未知来源");
    MCode OA029 = PS("OA029", "当前组织被逐级审批使用，不可调整层级");

    //oauth
    MCode PS001 = PS("PS001", "此记录与[{0}]关联引用，不允许被删除");
    MCode PS003 = PS("PS003", "组织");
    MCode PS004 = PS("PS004", "岗位");
    MCode PS005 = PS("PS005", "用户");
    MCode PS006 = PS("PS006", "角色");
    MCode PS007 = PS("PS007", "账号不能为空");
    MCode PS008 = PS("PS008", "姓名不能为空");
    MCode PS009 = PS("PS009", "用户额度已达到上限");
    MCode PS010 = PS("PS010", "您的权限发生变更，请刷新界面！");
    MCode PS011 = PS("PS011", "密码已变更，请重新登录");
    MCode PS012 = PS("PS012", "类型不能为空");
    MCode PS013 = PS("PS013", "当前机构Id不能与父机构Id相同");
    MCode PS014 = PS("PS014", "该应用已禁用");
    MCode PS015 = PS("PS015", "无法设置当前用户为分级管理员");
    MCode PS016 = PS("PS016", "无法设置超管为分级管理员");
    MCode PS017 = PS("PS017", "无法设置当前用户操作权限");
    MCode PS018 = PS("PS018", "解绑失败");
    MCode PS019 = PS("PS019", "第三方登录未配置");
    MCode PS020 = PS("PS020", "性别不能为空");
    MCode PS021 = PS("PS021", "无法禁用管理员用户");
    MCode PS022 = PS("PS022", "管理员只能修改自己，不能修改其他管理员");
    MCode PS023 = PS("PS023", "无法修改管理员账户");
    MCode PS024 = PS("PS024", "直属主管不能是自己");
    MCode PS025 = PS("PS025", "直属主管不能是我的下属用户");
    MCode PS026 = PS("PS026", "无法删除管理员账户");
    MCode PS027 = PS("PS027", "此用户为某部门主管，无法删除");
    MCode PS028 = PS("PS028", "此用户有下属，无法删除");
    MCode PS029 = PS("PS029", "无法修改管理员账户状态");
    MCode PS030 = PS("PS030", "用户信息已变更，请重新登录");
    MCode PS031 = PS("PS031", "该应用已删除");
    MCode PS032 = PS("PS032", "无本应用权限!");
    MCode PS033 = PS("PS033", "工作交接成功!");
    MCode PS034 = PS("PS034", "工作交接无法转移给管理员");
    MCode PS035 = PS("PS035", "工作交接无法转移给本人");
    MCode PS036 = PS("PS036", "该组织限制{0}级，已达上限");
    MCode PS037 = PS("PS037", "下级组织不支持当前选中的组织类型");
    MCode PS038 = PS("PS038", "该岗位限制{0}级，已达上限");
    MCode PS039 = PS("PS039", "无本应用后台权限!");
    MCode PS040 = PS("PS040", "该{0}下存在用户，不可删除");
    MCode PS041 = PS("PS041", "当前岗位被逐级审批使用，不可调整层级");
    MCode PS042 = PS("PS042", "请先选择交接内容");
    MCode PS043 = PS("PS043", "交接人不能为空");
    MCode PS044 = PS("PS044", "应用交接人不能为空");

    /**
     * 数据库
     */
    MCode DB001 = DB("DB001", "数据类型编码不符合标准（请注意大小写）。MySQL , SQLServer , Oracle , DM8 , KingbaseES , PostgreSQL");
    MCode DB002 = DB("DB002", "请检查 1、连接信息 2、网络通信 3、数据库服务启动状态。 详情：");
    MCode DB003 = DB("DB003", "通过url找不到对应数据库");
    MCode DB004 = DB("DB004", "查询结果集为空。");
    MCode DB005 = DB("DB005", "未找到对应数据库类型:{0}({1})");
    MCode DB006 = DB("DB006", "未找到对应数据类型转换");
    MCode DB007 = DB("DB007", "导入表名存在重复");
    MCode DB008 = DB("DB008", "建表数据与当前操作数据库不匹配: {0} -> {1}");
    MCode DB009 = DB("DB009", "未找到表信息: {0}");
    MCode DB010 = DB("DB010", "数据库{0}，未找到此表:{1}");
    MCode DB011 = DB("DB011", "联合主键类缺少“{0}”字段值");
    MCode DB012 = DB("DB012", "表示对应获取数值失败");
    MCode DB013 = DB("DB013", "目前还未支持{0}数据类型：{1}");
    MCode DB014 = DB("DB014", "表 [{0}]中字段 [{1}] 为主键，不允许数据类型 [{2}]");
    MCode DB015 = DB("DB015", "未找到字段SQL语句");
    MCode DB016 = DB("DB016", "没有初始字段");
    MCode DB017 = DB("DB017", "sql异常：{0}");
    MCode DB018 = DB("DB018", "请在数据库中添加对应的数据表");
    MCode DB019 = DB("DB019", "添加失败");
    /*== 系统自带表 DB1 ==*/
    MCode DB101 = DB("DB101", "系统自带表,不允许被删除");
    MCode DB102 = DB("DB102", "系统自带表,不允许被编辑");
    /*== 表已经被使用 DB2 ==*/
    MCode DB201 = DB("DB201", "表已经被使用,不允许被删除");
    MCode DB202 = DB("DB202", "表已经被使用,不允许被编辑");
    /*== 数据库连接问题 ==*/
    MCode DB301 = DB("DB301", "数据库连接成功");
    MCode DB302 = DB("DB302", "数据库连接失败");

    /**
     * 工作流相关错误码
     */
    /*========0-状态、短提示==========*/
    MCode WF001 = WF("WF001", "必填值");
    MCode WF002 = WF("WF002", "【审核通过】");
    MCode WF003 = WF("WF003", "【审核同意】");
    MCode WF004 = WF("WF004", "【审核退回】");
    MCode WF005 = WF("WF005", "审批已完成");
    MCode WF006 = WF("WF006", "开始");
    MCode WF007 = WF("WF007", "结束");
    MCode WF008 = WF("WF008", "必须有表");
    MCode WF009 = WF("WF009", "功能流程不能终止");
    MCode WF010 = WF("WF010", "指派成功");
    MCode WF011 = WF("WF011", "批量操作完成");
    MCode WF012 = WF("WF012", "该流程不能操作");
    MCode WF013 = WF("WF013", "复活成功");
    MCode WF014 = WF("WF014", "变更成功");
    MCode WF015 = WF("WF015", "挂起成功");
    MCode WF016 = WF("WF016", "恢复成功");
    MCode WF017 = WF("WF017", "委托人和被委托人相同，委托失败");
    MCode WF018 = WF("WF018", "操作失败，同一时间内有相同流程的委托");
    MCode WF019 = WF("WF019", "操作失败，同一时间内有相同流程，不能相互委托");
    MCode WF020 = WF("WF020", "功能流程不能删除");
    MCode WF021 = WF("WF021", "不能删除");
    MCode WF022 = WF("WF022", "催办成功");
    MCode WF023 = WF("WF023", "未找到催办人");
    MCode WF024 = WF("WF024", "该功能已被流程引用，请重新选择关联功能");
    MCode WF025 = WF("WF025", "启用失败，流程未设计");
    MCode WF026 = WF("WF026", "启用成功");
    MCode WF027 = WF("WF027", "禁用成功");
    MCode WF028 = WF("WF028", "该版本内有工单任务流转，无法删除");
    MCode WF029 = WF("WF029", "您没有发起该流程的权限");
    MCode WF030 = WF("WF030", "表单未找到");
    MCode WF031 = WF("WF031", "已审核完成");
    MCode WF032 = WF("WF032", "冻结不能操作");
    MCode WF033 = WF("WF033", "转向节点不存在或配置错误");
    MCode WF034 = WF("WF034", "转向失败，转向节点未审批");
    MCode WF035 = WF("WF035", "退回至您的审批，不能再发起退回");
    MCode WF036 = WF("WF036", "流程已处理，无法撤回");
    MCode WF037 = WF("WF037", "当前流程包含子流程，无法撤回");
    MCode WF038 = WF("WF038", "子流程无法撤回");
    MCode WF039 = WF("WF039", "下一节点为选择分支无法批量审批");
    MCode WF040 = WF("WF040", "条件流程包含候选人无法批量通过");
    MCode WF041 = WF("WF041", "该流程工单已终止");
    MCode WF042 = WF("WF042", "该流程工单已撤回");
    MCode WF043 = WF("WF043", "该节点没有数据,无法复活");
    MCode WF044 = WF("WF044", "此流程不支持变更");
    MCode WF045 = WF("WF045", "当前节点有子流程无法变更");
    MCode WF046 = WF("WF046", "退回节点包含子流程，退回失败");
    MCode WF047 = WF("WF047", "当前节点未审批，不能退回");
    MCode WF048 = WF("WF048", "流程处于挂起状态，不可操作");
    MCode WF049 = WF("WF049", "当前流程正在运行不能删除");
    MCode WF050 = WF("WF050", "已被挂起不能删除");
    MCode WF051 = WF("WF051", "没有删除权限");
    MCode WF052 = WF("WF052", "主版本没有内容");
    MCode WF053 = WF("WF053", "流程没有启用");
    MCode WF054 = WF("WF054", "流程编码不能重复");
    MCode WF055 = WF("WF055", "流程表单不一致，请重新选择");
    MCode WF056 = WF("WF056", "该流程由在线开发生成的，无法直接删除，请在功能设计中删除相关功能");
    MCode WF057 = WF("WF057", "该流程内工单任务流转未结束，无法删除");
    MCode WF058 = WF("WF058", "当前流程正在运行不能重复提交");
    MCode WF059 = WF("WF059", "流程自动发起审批失败");
    MCode WF060 = WF("WF060", "驳回节点不能是子流程");
    MCode WF061 = WF("WF061", "下一节点无审批人员请联系管理员");
    MCode WF062 = WF("WF062", "表单已被引用，请重新选择");
    MCode WF063 = WF("WF063", "流程已发起，无法删除");
    MCode WF064 = WF("WF064", "任务不存在,或者已处理");
    MCode WF065 = WF("WF065", "拒绝成功");
    MCode WF066 = WF("WF066", "同意成功");
    MCode WF067 = WF("WF067", "协办成功");
    MCode WF068 = WF("WF068", "协办保存成功");
    MCode WF069 = WF("WF069", "减签成功");
    MCode WF070 = WF("WF070", "撤销成功");
    MCode WF071 = WF("WF071", "最后一条数据不能删除");
    MCode WF072 = WF("WF072", "启用版本不能删除");
    MCode WF073 = WF("WF073", "归档版本不能删除");
    MCode WF074 = WF("WF074", "暂停成功");
    MCode WF075 = WF("WF075", "条件不满足无法流转");
    MCode WF076 = WF("WF076", "节点不存在");
    MCode WF077 = WF("WF077", "流程无法撤回");
    MCode WF078 = WF("WF078", "流程未同意，无法撤销");
    MCode WF079 = WF("WF079", "归档异常");
    MCode WF080 = WF("WF080", "选择的数据不能退签");
    MCode WF081 = WF("WF081", "无法加签");
    MCode WF082 = WF("WF082", "无法减签");
    MCode WF083 = WF("WF083", "无法退回");
    MCode WF084 = WF("WF084", "无法转审");
    MCode WF085 = WF("WF085", "无法协办");
    MCode WF086 = WF("WF086", "无法批量审批");
    MCode WF087 = WF("WF087", "经办未签收");
    MCode WF088 = WF("WF088", "经办未开始办理");
    MCode WF089 = WF("WF089", "流程发布失败");
    MCode WF090 = WF("WF090", "流程发布失败");
    MCode WF091 = WF("WF091", "流程提交失败");
    MCode WF092 = WF("WF092", "获取引擎当前任务失败");
    MCode WF093 = WF("WF093", "流程删除失败");
    MCode WF094 = WF("WF094", "获取出线集合失败");
    MCode WF095 = WF("WF095", "获取线之后的任务节点失败");
    MCode WF096 = WF("WF096", "获取下一级任务节点集合失败");
    MCode WF097 = WF("WF097", "获取上一级任务节点集合失败");
    MCode WF098 = WF("WF098", "任务完成失败");
    MCode WF099 = WF("WF099", "获取流程实例失败");
    MCode WF100 = WF("WF100", "获取未经过的节点失败");
    MCode WF125 = WF("WF125", "您没有发起委托流程");
    MCode WF126 = WF("WF126", "撤销流程不能转审");
    MCode WF127 = WF("WF127", "撤销流程不能退回");
    MCode WF128 = WF("WF128", "该用户已审批，请重新打开界面");
    MCode WF129 = WF("WF129", "委托人已无该流程权限");
    MCode WF130 = WF("WF130", "管理员不能新建委托/代理");
    MCode WF131 = WF("WF131", "不能选择admin");
    MCode WF132 = WF("WF132", "已有人接受，不可编辑");
    MCode WF133 = WF("WF133", "流转条件不满足，无法发起审批");
    MCode WF134 = WF("WF134", "第一个审批节点设置候选人，无法发起审批");
    MCode WF135 = WF("WF135", "第一个审批节点异常，无法发起审批");
    MCode WF136 = WF("WF136", "找不到发起人，发起失败");
    MCode WF137 = WF("WF137", "代理人和被代理人相同，代理失败");
    MCode WF138 = WF("WF138", "存在未签收的数据，无法关闭");
    MCode WF139 = WF("WF139", "该流程已触发了任务，无法删除");
    MCode WF140 = WF("WF140", "该流程已下架");
    MCode WF141 = WF("WF141", "存在待办理的数据，无法关闭");
    MCode WF142 = WF("WF142", "流程引擎异常");
    MCode WF143 = WF("WF143", "已到达加签限制层级，无法再加签");
    MCode WF144 = WF("WF144", "操作失败，同一时间内有相同流程的代理");
    MCode WF145 = WF("WF145", "操作失败，同一时间内有相同流程，不能相互代理");
    MCode WF146 = WF("WF146", "该任务流程已下架");
    MCode WF147 = WF("WF147", "发起节点设置了选择分支，无法发起审批");
    MCode WF148 = WF("WF148", "办理成功");
    MCode WF149 = WF("WF149", "不能转办给自己");
    MCode WF150 = WF("WF150", "不能转办给委托人");
    MCode WF151 = WF("WF151", "无法转办");
    MCode WF152 = WF("WF152", "转审成功");
    MCode WF153 = WF("WF153", "未找到上级审批人，请联系管理员");
    MCode WF154 = WF("WF154", "不支持退回至外部节点");

    /*=========1-提示语句=========*/
    MCode WF101 = WF("WF101", "新增异常，需自主排查。");
    MCode WF102 = WF("WF102", "修改异常，需自主排查。");
    MCode WF103 = WF("WF103", "复制异常，需自主排查。");
    MCode WF104 = WF("WF104", "当前流程被处理，无法撤回流程");
    MCode WF105 = WF("WF105", "任务待审状态才能撤回");
    MCode WF106 = WF("WF106", "撤回节点下一节点已操作");
    MCode WF107 = WF("WF107", "包含子流程不能撤回");
    MCode WF108 = WF("WF108", "当前流程正在运行不能重复提交");
    MCode WF109 = WF("WF109", "单据规则不存在");
    MCode WF110 = WF("WF110", "包含子流程不能操作");
    MCode WF111 = WF("WF111", "当前流程未完成,不能修改工作流引擎");
    MCode WF112 = WF("WF112", "已审核完成");
    MCode WF113 = WF("WF113", "未找到流程引擎");
    MCode WF114 = WF("WF114", "驳回节点不能是子流程");
    MCode WF115 = WF("WF115", "该流程工单已删除");
    MCode WF116 = WF("WF116", "当前流程正在运行不能删除");
    MCode WF117 = WF("WF117", "功能流程不能删除");
    MCode WF118 = WF("WF118", "子表数据不能删除");
    MCode WF119 = WF("WF119", "系统表单反射失败");
    MCode WF120 = WF("WF120", "该流程工单已撤回");
    MCode WF121 = WF("WF121", "该流程工单已终止");
    MCode WF122 = WF("WF122", "没有权限操作");
    MCode WF123 = WF("WF123", "该流程待办已删除");
    MCode WF124 = WF("WF124", "当前流程已发生变化，刷新后重试");


    /**
     * 在线开发相关错误码
     */
    /*=========1-错误提示=========*/
    MCode VS401 = VS("VS401", "该模板内表单内容为空，无法");
    MCode VS402 = VS("VS402", "该模板内列表内容为空，无法");
    MCode VS403 = VS("VS403", "该功能未配置流程不可用");
    MCode VS404 = VS("VS404", "单行输入不能重复");
    MCode VS405 = VS("VS405", "当前表单原数据已被调整，请重新进入该页面编辑并提交数据");
    MCode VS406 = VS("VS406", "该功能配置的流程处于停用");
    MCode VS407 = VS("VS407", "表头名称不可更改，表头行不能删除");
    MCode VS408 = VS("VS408", "请至少选择一个数据表");
    MCode VS409 = VS("VS409", "未找到主表信息");
    MCode VS410 = VS("VS410", "请导入对应功能的json文件");
    MCode VS411 = VS("VS411", "已存在相同功能");
    MCode VS412 = VS("VS412", "该表单已删除");
    MCode VS413 = VS("VS413", "应用不能为空");
    MCode VS414 = VS("VS414", "门户数据信息存在重复");
    MCode VS415 = VS("VS415", "该门户已删除");
    //base
    MCode VS001 = VS("VS001", "同步到流程时，{0}");
    MCode VS002 = VS("VS002", "发布失败，流程未设计！");
    MCode VS003 = VS("VS003", "无表生成有表失败");
    MCode VS004 = VS("VS004", "发布");
    MCode VS005 = VS("VS005", "预览");
    MCode VS006 = VS("VS006", "下载");
    MCode VS007 = VS("VS007", "同步成功");
    MCode VS008 = VS("VS008", "回滚失败,暂无线上版本");
    MCode VS009 = VS("VS009", "参数解析错误！");
    MCode VS010 = VS("VS010", "无效链接");
    MCode VS011 = VS("VS011", "密码错误");
    MCode VS012 = VS("VS012", "未找到该功能表单");
    MCode VS013 = VS("VS013", "未开启表单外链！");
    MCode VS014 = VS("VS014", "下载链接已失效");
    MCode VS015 = VS("VS015", "字段不能为空");
    MCode VS016 = VS("VS016", "路径错误");
    MCode VS017 = VS("VS017", "集成助手被禁用");
    MCode VS018 = VS("VS018", "表规范名称不能重复");
    MCode VS019 = VS("VS019", "规范名称不能使用系统关键字或JAVA关键字");
    MCode VS020 = VS("VS020", "字段规范名称不能重复");
    MCode VS021 = VS("VS021", "“{0}”命名不符合规范");
    MCode VS022 = VS("VS022", "主键策略:[雪花ID],表[ {0} ]主键设置不支持!");
    MCode VS023 = VS("VS023", "主键策略:[自增ID],表[ {0} ]主键设置不支持!");
    MCode VS024 = VS("VS024", "表单不存在或者未发布！");
    MCode VS025 = VS("VS025", "未获取到流程发起人");
    MCode VS026 = VS("VS026", "规范名称前两字母必须小写");
    MCode VS027 = VS("VS027", "自动生成的[{0}]超出长度，提交失败！");
    MCode VS028 = VS("VS028", "视图最多新建5个");
    MCode VS029 = VS("VS029", "设置视图主键后才能正常使用");

    MCode VS030 = VS("VS030", "只能由字母、数字、下划线组成，且不能以数字开头");
    MCode VS031 = VS("VS031", "最大长度不超过30个字符");
    MCode VS032 = VS("VS032", "数据库表名已存在");
    MCode VS033 = VS("VS033", "{0}超出条数限制");


    /**
     * 网关
     */
    MCode GT101 = GT("GT101", "成功");
    MCode GT102 = GT("GT102", "失败");
    MCode GT103 = GT("GT103", "验证错误");
    MCode GT104 = GT("GT104", "异常");
    MCode GT105 = GT("GT105", "登录过期,请重新登录");
    MCode GT106 = GT("GT106", "您的帐号在其他地方已登录,被强制踢出");
    MCode GT107 = GT("GT107", "Token验证失败");
    MCode GT108 = GT("GT108", "请求超过最大数");
    MCode GT109 = GT("GT108", "权限异常");
    /**
     * 调度
     */
    MCode SC001 = SCHEDULE("SC001", "操作失败，任务不存在");

    /**
     * admin exception
     */
    MCode AD101 = MSG("AD101", "接口无法访问");
    MCode AD102 = MSG("AD102", "系统异常");
    MCode AD103 = MSG("AD103", "操作过于频繁");
    MCode AD104 = MSG("AD104", "没有访问权限，请联系管理员授权");
    MCode AD105 = MSG("AD105", "认证失败，无法访问系统资源");
    MCode AD106 = MSG("AD106", "无效内部认证，无法访问系统资源");

    /**
     * extend
     */
    MCode ETD101 = MSG("ETD101", "操作失败，原文件不存在");
    MCode ETD102 = MSG("ETD102", "找不到父级");
    MCode ETD103 = MSG("ETD103", "不能移动到自己的文件夹");
    MCode ETD104 = MSG("ETD104", "未能找到此订单");
    MCode ETD105 = MSG("ETD105", "新建成功10000条数据");
    MCode ETD106 = MSG("ETD106", "获取失败");
    MCode ETD107 = MSG("ETD107", "账户认证错误");
    MCode ETD108 = MSG("ETD108", "你还没有设置邮件的帐户");
    MCode ETD109 = MSG("ETD109", "文件导出失败");
    MCode ETD110 = MSG("ETD110", "文件格式不正确");
    MCode ETD111 = MSG("ETD111", "文件找不到");
    MCode ETD112 = MSG("ETD112", "此记录被关联引用,不允许被删除");
    MCode ETD113 = MSG("ETD113", "防止恶意创建过多数据");
    MCode ETD114 = MSG("ETD114", "保存失败，请重新登陆");
    MCode ETD115 = MSG("ETD115", "请输入预览的url");
    MCode ETD116 = MSG("ETD116", "请选择正确的预览方式");
    MCode ETD117 = MSG("ETD117", "数据超过1000条");
    /**
     * form
     */
    MCode FM001 = MSG("FM001", "未找到接口");
    MCode FM002 = MSG("FM002", "表单信息不存在");
    MCode FM003 = MSG("FM003", "子表重复");
    MCode FM004 = MSG("FM004", "已到达该模板复制上限，请复制源模板!");
    MCode FM005 = MSG("FM005", "该表单已被流程引用，无法删除！");
    MCode FM006 = MSG("FM006", "该表单未发布，无法回滚表单内容");
    MCode FM007 = MSG("FM007", "该模板内表单内容为空，无法发布");
    MCode FM008 = MSG("FM008", "该功能未导入流程表单");
    MCode FM009 = MSG("FM009", "流程未设计，请先设计流程！");
    MCode FM010 = MSG("FM010", "该功能流程处于停用状态！");
    MCode FM011 = MSG("FM011", "表[{0}]无主键!");
    MCode FM012 = MSG("FM012", "主键策略:{0}，与表[{1}]主键策略不一致!");
    MCode FM013 = MSG("FM013", "表新增错误:{0}");
    MCode FM014 = MSG("FM014", "该表单已生成菜单不可删除");

    /**
     * message的消息提示
     */
    MCode MSERR101 = MSG("MSERR101", "发送失败，失败原因：SMTP服务为空");
    MCode MSERR102 = MSG("MSERR102", "发送失败，失败原因：发件人邮箱为空");
    MCode MSERR103 = MSG("MSERR103", "发送失败，失败原因：发件人密码为空");
    MCode MSERR104 = MSG("MSERR104", "发送失败，失败原因：接收人为空");
    MCode MSERR105 = MSG("MSERR105", "发送失败。失败原因：{0}的邮箱账号格式有误！");
    MCode MSERR106 = MSG("MSERR106", "发送失败。失败原因：{0}的邮箱账号为空！");
    MCode MSERR107 = MSG("MSERR107", "发送失败。失败原因：接收人对应的邮箱全部为空");
    MCode MSERR108 = MSG("MSERR108", "发送失败。失败原因：{0}");
    MCode MSERR109 = MSG("MSERR109", "连接成功");
    MCode MSERR110 = MSG("MSERR110", "连接失败。失败原因：{0}");
    MCode MSERR111 = MSG("MSERR111", "已发送");
    MCode MSERR112 = MSG("MSERR112", "内容不能包含<符号");
    MCode MSERR113 = MSG("MSERR113", "暂无未读消息");
    MCode MSERR114 = MSG("MSERR114", "自定义模板编码不能使用系统模板编码规则");
    MCode MSERR115 = MSG("MSERR115", "创建失败，存在多个标题参数");
    MCode MSERR116 = MSG("MSERR116", "创建失败，不存在标题参数");
    MCode MSERR117 = MSG("MSERR117", "更新失败，存在多个标题参数");
    MCode MSERR118 = MSG("MSERR118", "更新失败，不存在标题参数");
    MCode MSERR119 = MSG("MSERR119", "请先前往系统同步设置，配置钉钉账号");
    MCode MSERR120 = MSG("MSERR120", "请先前往系统同步设置，配置企业微信账号");
    MCode MSERR121 = MSG("MSERR121", "配置模板无数据，无法测试");

    /********************
     * system
     ********************/
    MCode SYS001 = SYS("SYS001", "区域编码不能重复");
    MCode SYS002 = SYS("SYS002", "删除失败，当前有子节点数据");
    MCode SYS003 = SYS("SYS003", "单据已经被使用,不允许被删除");
    MCode SYS004 = SYS("SYS004", "清理成功");
    MCode SYS005 = SYS("SYS005", "接口创建成功");
    MCode SYS006 = SYS("SYS006", "当前SQL含有敏感字:{0}");
    MCode SYS007 = SYS("SYS007", "接口请求成功");
    MCode SYS008 = SYS("SYS008", "接口不符合规范");
    MCode SYS009 = SYS("SYS009", "变量名不能包含敏感字符");
    MCode SYS010 = SYS("SYS010", "变量名已存在");
    MCode SYS011 = SYS("SYS011", "数据库连接不能相同");
    MCode SYS012 = SYS("SYS012", "请检查，同一数据库下无法同步数据");
    MCode SYS013 = SYS("SYS013", "同步失败:{0}");
    MCode SYS014 = SYS("SYS014", "字典类型下面有字典值禁止删除");
    MCode SYS015 = SYS("SYS015", "模板不存在");
    MCode SYS016 = SYS("SYS016", "当前目录存在数据,不能修改类型");
    MCode SYS017 = SYS("SYS017", "删除失败，请先删除子菜单");
    MCode SYS018 = SYS("SYS018", "当前导入菜单为{0}端菜单，请在对应模块下导入！");
    MCode SYS019 = SYS("SYS019", "请在顶级节点下创建目录后再进行菜单导入");
    MCode SYS020 = SYS("SYS020", "该字段在方案{0}中已被使用");
    MCode SYS021 = SYS("SYS021", "修改失败，该方案不允许编辑");
    MCode SYS022 = SYS("SYS022", "编码错误");
    MCode SYS023 = SYS("SYS023", "请求发生错误！");
    MCode SYS024 = SYS("SYS024", "获取不到数据！");
    MCode SYS025 = SYS("SYS025", "获取企业微信access_token失败");
    MCode SYS026 = SYS("SYS026", "正在进行同步，请稍后再试");
    MCode SYS027 = SYS("SYS027", "请先从企业微信同步部门到本地");
    MCode SYS028 = SYS("SYS028", "请先从钉钉同步部门到本地");

    MCode SYS029 = SYS("SYS029", "验证码位数不能大于6");
    MCode SYS030 = SYS("SYS030", "验证码位数不能小于3");
    MCode SYS031 = SYS("SYS031", "测试发送消息的连接失败：{0}");
    MCode SYS032 = SYS("SYS032", "测试发送消息连接成功");
    MCode SYS033 = SYS("SYS033", "测试组织同步的连接失败：{0}");
    MCode SYS034 = SYS("SYS034", "测试组织同步连接成功");
    MCode SYS035 = SYS("SYS035", "测试连接类型错误");
    MCode SYS036 = SYS("SYS036", "测试钉钉连接失败：");
    MCode SYS037 = SYS("SYS037", "测试连接成功");
    MCode SYS038 = SYS("SYS038", "表信息抽取异常");
    MCode SYS039 = MSG("SYS039", "删除失败，请先删除该应用下的菜单和门户");
    MCode SYS040 = MSG("SYS040", "删除失败，请先删除该应用下的菜单");
    MCode SYS041 = MSG("SYS041", "删除失败，请先删除该应用下的门户");
    MCode SYS042 = MSG("SYS042", "该日程已被删除");
    MCode SYS043 = MSG("SYS043", "最后一条数据不能删除");
    MCode SYS044 = MSG("SYS044", "启用版本不能删除");
    MCode SYS045 = MSG("SYS045", "归档版本不能删除");
    MCode SYS046 = MSG("SYS046", "数据集不能重名");
    MCode SYS047 = MSG("SYS047", "SQL语句仅支持查询语句");
    MCode SYS048 = MSG("SYS048", "SQL语句需带上@formId条件");
    MCode SYS049 = MSG("SYS049", "正在进行同步,请稍等");
    MCode SYS050 = MSG("SYS050", "只能输入字母、数字、点、横线和下划线，且以字母开头");
    MCode SYS051 = MSG("SYS051", "翻译标记不能重复");
    MCode SYS052 = MSG("SYS052", "翻译语言至少填写一项");
    MCode SYS053 = SYS("SYS053", "获取钉钉access_token失败");

    /**
     * 应用
     */
    MCode SYS101 = SYS("SYS101", "更新失败，主系统不允许禁用");
    MCode SYS102 = SYS("SYS102", "主系统不允许删除");
    MCode SYS103 = SYS("SYS103", "系统在审批常用语中被使用，不允许删除");
    MCode SYS104 = SYS("SYS104", "更新失败，主系统不允许修改编码");
    MCode SYS105 = SYS("SYS105", "常用语已存在");

    /**
     * 数据接口
     */
    MCode SYS121 = SYS("SYS121", "接口暂只支持HTTP和HTTPS方式");
    MCode SYS122 = SYS("SYS122", "接口请求失败");
    MCode SYS123 = SYS("SYS123", "接口请求失败, JS调用失败,错误：{0}");
    MCode SYS124 = SYS("SYS124", "验证请求超时");
    MCode SYS125 = SYS("SYS125", "appSecret错误");
    MCode SYS126 = SYS("SYS126", "appId使用期限已到期");
    MCode SYS127 = SYS("SYS127", "appId参数错误");

    MCode SYS128 = SYS("SYS128", "{0}不能使用系统、开发语言及数据库关键字命名");
    MCode SYS129 = SYS("SYS129", "当前数据源不支持全连接");

    MCode SYS130 = SYS("SYS130", "标题不能为空");
    MCode SYS131 = SYS("SYS131", "结束时间必须晚于开始时间");
    MCode SYS132 = SYS("SYS132", "结束重复必须晚于开始时间");

    MCode SYS133 = SYS("SYS133", "请先设置数据接口的字段列表！");

    MCode SYS134 = SYS("SYS134", "至少选择一个用户");
    MCode SYS135 = SYS("SYS135", "该{0}已达用户限制个数");
    MCode SYS136 = SYS("SYS136", "该{0}已达权限限制个数");
    MCode SYS137 = SYS("SYS137", "用户冲突，互斥修改失败");
    MCode SYS138 = SYS("SYS138", "用户冲突，先决修改失败");
    MCode SYS139 = SYS("SYS139", "部分添加成功");
    MCode SYS140 = SYS("SYS140", "互斥对象不能是自己");
    MCode SYS141 = SYS("SYS141", "先决对象不能是自己");
    MCode SYS142 = SYS("SYS142", "互斥和先决对象不能是同一个对象");
    MCode SYS143 = SYS("SYS143", "先决约束冲突，先决限制1级");
    MCode SYS144 = SYS("SYS144", "已达权限上限个数");
    MCode SYS145 = SYS("SYS145", "部分添加成功，超出权限基数的未被保存");
    MCode SYS146 = SYS("SYS146", "上级{0}不能是自己或下级");

    /**
     * AI
     */
    MCode SYS180 = SYS("SYS180", "AI功能未配置启用");
    MCode SYS181 = SYS("SYS181", "AI结果获取失败, 请稍后再尝试");
    MCode SYS182 = SYS("SYS182", "AI请求频率达到限制, 请稍后再尝试");

    /********************
     * system
     ********************/


    static MCode MSG(String code, String desc) {
        return new MCode("message", code, desc);
    }

    static MCode LOG(String code, String desc) {
        return new MCode("login", code, desc);
    }

    static MCode DB(String code, String desc) {
        return new MCode("database", code, desc);
    }

    static MCode WF(String code, String desc) {
        return new MCode("workflow", code, desc);
    }

    static MCode VS(String code, String desc) {
        return new MCode("visual", code, desc);
    }

    static MCode GT(String code, String desc) {
        return new MCode("gateway", code, desc);
    }

    static MCode OA(String code, String desc) {
        return new MCode("oauth", code, desc);
    }

    static MCode PS(String code, String desc) {
        return new MCode("permission", code, desc);
    }

    static MCode SCHEDULE(String code, String desc) {
        return new MCode("schedule", code, desc);
    }

    static MCode SYS(String code, String desc) {
        return new MCode("system", code, desc);
    }

}
