package com.bringspring.common.constant.model;

import com.bringspring.common.i18n.util.I18nUtil;

/**
 * 类功能
 *
 * @author RKKJ开发平台组 YanYu
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/12/20
 */
public class MCode {

    /**
     * 提示信息类型
     */
    private final String type;

    /**
     * 错误编码
     */
    private final String code;

    /**
     * description 描述
     */
    private final String desc;


    public MCode(String type, String code, String desc){
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String get(){
        return  desc;
    }

    public String get(Object... args){
        return I18nUtil.getMessageStr(this, args);
    }

    public String getMsg(){
        return type + ":" + code + " " + desc;
    }


}
