package com.bringspring.common.database.constant;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;

import java.util.Map;
import java.util.Optional;

/**
 * 类功能
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/27
 */
public class DbAliasConst {
    /**
     * 字段名
     */
    public static final String FIELD_NAME = "FIELD_NAME";
    /**
     * 注释
     */
    public static final String FIELD_COMMENT = "FIELD_COMMENT";
    /**
     * 默认值
     */
    public static final String DEFAULTS = "DEFAULTS";
    /**
     * 类型
     * 字符串：varchar
     */
    public static final String DATATYPE = "DATATYPE";
    /**
     * 说明
     */
    public static final String DESCRIPTION = "DESCRIPTION";
    /**
     * 允空
     * 允许：1，不允许：0
     */
    public static final String ALLOW_NULL = "ALLOW_NULL";
    /**
     * 长度
     */
    public static final String DATA_LENGTH = "DATA_LENGTH";
    /**
     * 主键
     * 存在：1，不存在：0
     */
    public static final String PRIMARY_KEY = "PRIMARY_KEY";
    /**
     * 表名
     */
    public static final String TABLE_NAME = "TABLE_NAME";
    /**
     * 表注释
     */
    public static final String TABLE_COMMENT = "TABLE_COMMENT";
    /**
     * 表总数
     */
    public static final String TABLE_SUM = "TABLE_SUM";
    /**
     * 表大小
     */
    public static final String TABLE_SIZE = "TABLE_SIZE";
    /**
     * 精度
     */
    public static final String PRECISION = "PRECISION";
    /**
     * 小数
     */
    public static final String DECIMALS = "DECIMALS";
    /**
     * 类型
     */
    public static final String DATA_TYPE = "DATATYPE";

    /**
     * 类型+精度+特殊标志
     */
    public static final String COLUMN_TYPE = "COLUMNTYPE";

    /**
     * 允空
     */
    public static final String NULL = "NULL";

    /**
     * 非空
     */
    public static final String NOT_NULL = "NOT NULL";

    /**
     * 允空
     * 0:空值 NULL、1:非空值 NOT NULL
     */
    public static final NumFieldAttr<String> ALLOW_NULL_ = new NumFieldAttr<>(ImmutableMap.of(
            1, NULL,
            0, NOT_NULL,
            -1, NOT_NULL
    ));

    /**
     * 主键
     *  0:非主键、1：主键
     */
    public static final NumFieldAttr<Boolean> PRIMARY_KEY_ = new NumFieldAttr<>(ImmutableMap.of(
            1, true,
            0, false,
            -1, false
    ));

    public static final NumFieldAttr<Boolean> AUTO_INCREMENT = new NumFieldAttr<>(ImmutableMap.of(
            1, true,
            0, false,
            -1, false
    ));

    /**
     * 数值对应字段属性
     * @param <T>
     */
    @AllArgsConstructor
    public static class NumFieldAttr<T>{

        private Map<Integer, T> config;

        /**
         * 获取标识
         */
        public T getSign(Integer i) {
            return config.get(i == null ? -1 : i);
        }

        /**
         * 获取数值
         */
        public Integer getNum(T sign) throws DataException {
            if(sign == null){
                return 0;
            }
            Optional<Map.Entry<Integer, T>> first = config.entrySet().stream().filter(map -> map.getValue().equals(sign)).findFirst();
            if(first.isPresent()){
                return first.get().getKey();
            }else {
                throw new DataException(MsgCode.DB012.get());
            }
        }
    }

}
