package com.bringspring.common.database.datatype.viewshow;


import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;

/**
 * 数据库数据类型向前端显示
 * 转换规则
 *
 * @author RKKJ开发平台组
 * @version V3.3
 * @copyright 荣科科技股份有限公司
 * @date 2022-05-26
 */
public enum DtViewEnum {
    /**
     * 整型
     */
    INT("int", new DtInterface[]{
                DtMySQLEnum.INT,
    }),
    /**
     * 长整型
     */
    BIGINT("bigint", new DtInterface[]{
                DtMySQLEnum.BIGINT,
    }),
    /**
     * 字符串
     */
    VARCHAR("varchar", new DtInterface[]{
                    DtMySQLEnum.CHAR,
                    DtMySQLEnum.VARCHAR,
    }),
    /**
     * 文本
     */
    TEXT("text", new DtInterface[]{
                    DtMySQLEnum.TINY_TEXT,
                    DtMySQLEnum.TEXT,
                    DtMySQLEnum.MEDIUM_TEXT,
                    DtMySQLEnum.LONG_TEXT,
    }),
    /**
     * 浮点型
     */
    DECIMAL("decimal", new DtInterface[]{
                    DtMySQLEnum.DECIMAL,
    }),
    /**
     * 日期时间
     */
    DATE_TIME("datetime", new DtInterface[]{
                    DtMySQLEnum.DATE,
                    DtMySQLEnum.DATE_TIME,
    }),
    ;

    DtViewEnum(String view, DtInterface[] dtEnums){}

}
