package com.bringspring.common.database.model.interfaces;


import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.sql.model.DbStruct;

/**
 * 数据源接口
 *
 * @author RKKJ开发平台组
 * @version V3.2.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/28
 */
public interface DbSourceOrDbLink {

    DbStruct getDbStruct();

    DbLinkEntity init();

    DbLinkEntity init(String dbName);

    /**
     * 获取数据源参数传参对象
     * 注意：此处方法不能命名为 get开头的名字，
     * 会出现copy bean转换时候的错误
     * @return ignore
     */
    DataSourceDTO convertDTO();

    /**
     * 多租户：获取数据源参数传参对象
     * @param dbName 库名
     * @return ignore
     */
    DataSourceDTO convertDTO(String dbName);
}
