package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.constant.DbConst;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlPostgre;
import com.bringspring.common.database.sql.model.DbStruct;
import com.bringspring.common.exception.DataException;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * PostgreSQL模型
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/06
 */
public class DbPostgre extends DbBase {

    public static String DEF_SCHEMA = "public";

    @Override
    protected void init() {
        setInstance(
                DbBase.POSTGRE_SQL,
                DbType.POSTGRE_SQL,
                "5432",
                "postgresql",
                "org.postgresql.Driver",
                "jdbc:postgresql://{host}:{port}/{dbname}",
                new SqlPostgre());
    }


    @Override
    public String getConnUrl(String prepareUrl, String host, Integer port, DbStruct struct) {
        prepareUrl = super.getConnUrl(prepareUrl, host, port, null);
        return prepareUrl.replace(DbConst.DB_NAME, struct.getPostGreDbName()).replace(DbConst.DB_SCHEMA, struct.getPostGreDbSchema());
    }

    @Override
    protected String getDynamicTableName(String tableName) {
        return DataSourceContextHolder.getDatasourceName().toUpperCase()+"."+tableName;
    }

    @Override
    public DbTableFieldModel getPartFieldModel(ResultSet result) throws SQLException, DataException {
        DbTableFieldModel model =  new DbTableFieldModel();
        //"t"不允许为空,"f"允许为空
        if(result.getString(DbAliasEnum.ALLOW_NULL.asByDb(this)).equals("t")){
            model.setAllowNull(DbAliasEnum.ALLOW_NULL.isFalse());
        }else {
            model.setAllowNull(DbAliasEnum.ALLOW_NULL.isTrue());
        }
        return model;
    }

}
