package com.bringspring.common.database.sql.param;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.JdbcColumnModel;
import com.bringspring.common.exception.DataTypeException;

/**
 * 类功能
 *
 * @author RKKJ开发平台组
 * @version v3.4.5
 * @copyrignt 荣科科技股份有限公司
 * @date 2022-12-06
 */
public class FormatSqlMySQL {

    /**
     * 处理单引号 ''
     */
    public static String singleQuotes(String value){
        return value.replace("'", "\\'");
    }

    /**
     * Mysql一些类型的特殊处理
     */
    public static Object getMysqlValue(JdbcColumnModel dbColumnModel) {
        return dbColumnModel.getValue();
    }

    public static void  checkMysqlFieldPrimary(DbFieldModel field, String table) throws DataTypeException {
        // Mysql对主键的一些限制
        if(field.getIsPrimaryKey()){
            // Mysql 字段为主键的时候，不能为BLOB/TEXT/tinytext的类型
            switch ((DtMySQLEnum)field.getDtModelDTO().getConvertTargetDtEnum()){
                case BLOB:
                case TINY_TEXT:
                case MEDIUM_TEXT:
                case TEXT:
                case LONG_TEXT:
                    throw new DataTypeException(MsgCode.DB014.get(table, field.getField(), field.getDtModelDTO().getDtEnum().getDataType()));
                case VARCHAR:
                    // varchar作为主键的时候，长度不允许超过768
                    if(field.getDtModelDTO().getCharLength() > 768L){
                        field.getDtModelDTO().setCharLength(768L);
                    }
                    break;
                default:
            }
        }
    }

}
