package com.bringspring.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 文件下载日志
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-03-13
 */
@Data
@TableName("BASE_FILE_DOWN_LOG")
public class FileDownLogEntity {

    /**
     * 主键
     **/
    @TableId("ID")
    private String id;

    /**
     * 存储引擎
     **/
    @TableField("ENGINE")
    private String engine;

    /**
     * 存储桶
     **/
    @TableField("BUCKET")
    private String bucket;

    /**
     * 文件id
     **/
    @TableField("FILE_ID")
    private String fileId;

    /**
     * 文件名称
     **/
    @TableField("FILE_NAME")
    private String fileName;

    /**
     * 文件后缀
     **/
    @TableField("SUFFIX")
    private String suffix;

    /**
     * 文件大小
     **/
    @TableField("SIZE_INFO")
    private String sizeInfo;

    /**
     * 文件的对象名（唯一名称）
     **/
    @TableField("OBJ_NAME")
    private String objName;

    /**
     * 文件存储路径
     **/
    @TableField("STORAGE_PATH")
    private String storagePath;

    /**
     * 文件二级存储路径
     **/
    @TableField("SECOND_FILE_PATH")
    private String secondFilePath;

    /**
     * 图片缩略图
     **/
    @TableField("THUMBNAIL")
    private String thumbnail;

    /**
     * 文件版本
     **/
    @TableField("FILE_VERSION")
    private String fileVersion;

    /**
     * 文件一级存储路径 license :临时文件存储路径 document : 文档管理存储路径
     **/
    @TableField("FILE_TYPE")
    private String fileType;

    /**
     * 上传方式: 1.local 本地上传  2.http http上传  3.create 新建
     **/
    @TableField("TYPE")
    private String type;

    /**
     * 下载链接
     **/
    @TableField("URL")
    private String url;

    /**
     * 模块类型/业务类型
     **/
    @TableField("MODULAR")
    private String modular;

    /**
     * 业务id
     **/
    @TableField("BUSINESS_ID")
    private String businessId;

    /**
     * 文件MD5
     **/
    @TableField("FILE_DIGEST")
    private String fileDigest;

    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;


    /**
     *
     **/
    @TableField("OLD_FILE_VERSION_ID")
    private String oldFileVersionId;

}
