package com.bringspring.common.filter;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingRequestWrapper;

import java.io.IOException;

/**
 * Repeatable 过滤器  实现可重复读参数请求
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class RepeatableFilter implements Filter {

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        //springboot自带的包装器读取流只能读取一次导致导致切面拿到流信息后
        // 读取验证完成后，后续业务接口接收不到实例信息，因此该有自定义方式
//        ServletRequest requestWrapper = null;
//        if (request instanceof HttpServletRequest) {
//            requestWrapper = new RepeatedlyRequestWrapper((HttpServletRequest) request, response);
//        }
//        if (requestWrapper == null) {
//            chain.doFilter(request, response);
//        } else {
//            chain.doFilter(requestWrapper, response);
//        }
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        // 使用 Spring 官方提供的、经过充分测试的包装器
        ContentCachingRequestWrapper wrappedRequest = new ContentCachingRequestWrapper(httpRequest);
        chain.doFilter(wrappedRequest, response);
    }

    @Override
    public void destroy() {

    }
}