package com.bringspring.common.properties;

import com.bringspring.common.util.Md5Util;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
public class SecurityProperties {

    public static final String PREFIX = "security";


    @Getter
    private static SecurityProperties instance;

    public SecurityProperties() {
        initIgnoreXssUrl();
        SecurityProperties.instance = this;
    }

    /**
     * AES, DES 公钥
     * 长度 16/24/32
     *
     * @return
     */
    private String securityKey = "";

    /**
     * 开启数据传输加密
     */
    private boolean enableRestEncrypt;

    /**
     * 是否开启接口鉴权
     */
    private boolean enablePreAuth;

    /**
     * 是否验证请求是否来自内部
     */
    private boolean enableInnerAuth;

    /**
     * 忽略XSS过滤路径
     */
    public List<String> ignoreXssUrl = new ArrayList<>();


    public List<String> getIgnoreXssUrl() {
        return new ArrayList<>(ignoreXssUrl);
    }

    public void setIgnoreXssUrl(List<String> ignoreXssUrl) {
        initIgnoreXssUrl();
        this.ignoreXssUrl.addAll(ignoreXssUrl);
    }

    private void initIgnoreXssUrl() {
        ignoreXssUrl.clear();
        //添加默认URL
    }


    public void setSecurityKey(String securityKey) {
        this.securityKey = Md5Util.getStringMd5(securityKey);
    }
}
