package com.bringspring.common.security.encrypt;

import com.bringspring.common.security.handler.IRestHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Slf4j
@Order(0)
@Component
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(prefix = "security", name = "enable-rest-encrypt", havingValue = "true")
public class EmptyEncryptRestRequestHandler implements IRestHandler {

    @Override
    public boolean supportParameter() {
        return false;
    }

    @Override
    public boolean supportBodyJson() {
        return false;
    }

    @Override
    public boolean supportResponse() {
        return false;
    }

    @Override
    public boolean supportHeader() {
        return false;
    }
}
