package com.bringspring.common.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.entity.FileDownLogEntity;
import com.bringspring.common.mapper.FileDownLogMapper;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.model.filedownlog.FileDownLogPagination;
import com.bringspring.common.model.filedownlog.FileDownLogUpForm;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 文件下载日志
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-03-13
 */
@Service
public class FileDownLogServiceImpl extends ServiceImpl<FileDownLogMapper, FileDownLogEntity> implements FileDownLogService {


    @Autowired
    private UserProvider userProvider;




    /**
     * 文件下载日志列表分页查询
     *
     * @param filedownlogPagination 查询参数
     * @return List<FiledownlogEntity>
     */
    @Override
    public List<FileDownLogEntity> getList(FileDownLogPagination filedownlogPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int filedownlogNum = 0;
        QueryWrapper<FileDownLogEntity> filedownlogQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_id())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileId, filedownlogPagination.getFile_id());
        }

        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_name())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileName, filedownlogPagination.getFile_name());
        }

        if (StringUtils.isNotEmpty(filedownlogPagination.getStorage_path())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getStoragePath, filedownlogPagination.getStorage_path());
        }

        if (AllIdList.size() > 0) {
            filedownlogQueryWrapper.lambda().in(FileDownLogEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(filedownlogPagination.getSidx())) {
            filedownlogQueryWrapper.lambda().orderByDesc(FileDownLogEntity::getId);
        } else {
            try {
                String sidx = filedownlogPagination.getSidx();
                FileDownLogEntity filedownlogEntity = new FileDownLogEntity();
                Field declaredField = filedownlogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                filedownlogQueryWrapper = "asc".equalsIgnoreCase(filedownlogPagination.getSort()) ? filedownlogQueryWrapper.orderByAsc(value) : filedownlogQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<FileDownLogEntity> page = new Page<>(filedownlogPagination.getCurrentPage(), filedownlogPagination.getPageSize());
            IPage<FileDownLogEntity> userIPage = this.page(page, filedownlogQueryWrapper);
            return filedownlogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<FileDownLogEntity> list = new ArrayList();
            return filedownlogPagination.setData(list, list.size());
        }
    }

    /**
     * 文件下载日志列表分页查询（导出使用）
     *
     * @param filedownlogPagination 查询参数
     * @param dataType              0-当前页；非0-当前查询条件所有数据
     * @return List<FiledownlogEntity>
     */
    @Override
    public List<FileDownLogEntity> getTypeList(FileDownLogPagination filedownlogPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int filedownlogNum = 0;
        QueryWrapper<FileDownLogEntity> filedownlogQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_id())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileId, filedownlogPagination.getFile_id());
        }

        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_name())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileName, filedownlogPagination.getFile_name());
        }

        if (StringUtils.isNotEmpty(filedownlogPagination.getStorage_path())) {
            filedownlogNum++;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getStoragePath, filedownlogPagination.getStorage_path());
        }

        if (AllIdList.size() > 0) {
            filedownlogQueryWrapper.lambda().in(FileDownLogEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(filedownlogPagination.getSidx())) {
            filedownlogQueryWrapper.lambda().orderByDesc(FileDownLogEntity::getId);
        } else {
            try {
                String sidx = filedownlogPagination.getSidx();
                FileDownLogEntity filedownlogEntity = new FileDownLogEntity();
                Field declaredField = filedownlogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                filedownlogQueryWrapper = "asc".equalsIgnoreCase(filedownlogPagination.getSort()) ? filedownlogQueryWrapper.orderByAsc(value) : filedownlogQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<FileDownLogEntity> page = new Page<>(filedownlogPagination.getCurrentPage(), filedownlogPagination.getPageSize());
                IPage<FileDownLogEntity> userIPage = this.page(page, filedownlogQueryWrapper);
                return filedownlogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<FileDownLogEntity> list = new ArrayList();
                return filedownlogPagination.setData(list, list.size());
            }
        } else {
            return this.list(filedownlogQueryWrapper);
        }
    }

    /**
     * 获取文件下载日志详细信息
     *
     * @param id 主键
     * @return FiledownlogEntity
     */
    @Override
    public FileDownLogEntity getInfo(String id) {
        QueryWrapper<FileDownLogEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FileDownLogEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    /**
     * 创建文件下载日志操作
     *
     * @param filedownlogCrForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void create(FileDownLogCrForm filedownlogCrForm) {
        String mainId = RandomUtil.uuId();
        FileDownLogEntity entity = JsonUtil.getJsonToBean(filedownlogCrForm, FileDownLogEntity.class);
        entity.setId(mainId);
        this.save(entity);

    }

    /**
     * 更新文件下载日志操作
     *
     * @param id                主键
     * @param filedownlogUpForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void update(String id, FileDownLogUpForm filedownlogUpForm) {
        UserInfo userInfo = userProvider.get();
        FileDownLogEntity entity = this.getInfo(id);
        if (entity != null) {
            FileDownLogEntity subentity = JsonUtil.getJsonToBean(filedownlogUpForm, FileDownLogEntity.class);
            this.updateById(subentity);
        }
    }

    /**
     * 删除文件下载日志操作
     *
     * @param entity
     * @return
     */
    @Override
    @DSTransactional
    public void delete(FileDownLogEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法


}