package com.bringspring.common.util;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:54
 */
public class PageUtil {
    /**
     * 自定义分页
     */
    public static List getListPage(int page, int pageSize, List list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        int totalCount = list.size();
        page = page - 1;
        int fromIndex = page * pageSize;
        if (fromIndex >= totalCount) {
            return list;
        }
        int toIndex = ((page + 1) * pageSize);
        if (toIndex > totalCount) {
            toIndex = totalCount;
        }
        return list.subList(fromIndex, toIndex);
    }

    /**
     * 解决总数量20条，第二次请求不会在分页
     * @param page
     * @param pageSize
     * @param allList
     * @return
     */
    public static List getPage(int page, int pageSize, List allList) {
        if (allList == null || allList.size() == 0) {
            return allList;
        }
        page = page - 1;
        int fromIndex = page * pageSize;
        //对list进行截取
        List list = allList.subList(fromIndex, (allList.size() - fromIndex > pageSize) ? (fromIndex + pageSize) : allList.size());
        return list;
    }
}
