/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.config;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.util.TenantHolder;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
@EnableAsync(proxyTargetClass=true)
public class AsyncConfig
implements AsyncConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncConfig.class);

    @Primary
    @Bean(value={"threadPoolTaskExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(10);
        executor.setMaxPoolSize(50);
        executor.setQueueCapacity(2000);
        executor.setKeepAliveSeconds(30);
        executor.setThreadNamePrefix("sysTaskExecutor");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setTaskDecorator(r -> {
            TenantVO tenantVO = TenantHolder.getLocalTenantCache();
            UserInfo userInfo = UserProvider.getUser();
            return () -> {
                try {
                    if (tenantVO != null) {
                        TenantHolder.setLocalTenantCache(tenantVO);
                    }
                    UserProvider.setLocalLoginUser(userInfo);
                    r.run();
                }
                finally {
                    UserProvider.clearLocalUser();
                    RequestContextHolder.resetRequestAttributes();
                    TenantHolder.clearLocalTenantCache();
                }
            };
        });
        return executor;
    }

    @Bean(value={"defaultExecutor"})
    public ThreadPoolTaskExecutor getAsyncExecutorDef(@Qualifier(value="threadPoolTaskExecutor") Executor executor) {
        return (ThreadPoolTaskExecutor)executor;
    }

    @Generated
    public AsyncConfig() {
    }
}

