/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.db;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.DateTimeLimit;
import com.bringspring.common.database.datatype.limit.DecimalLimit;
import com.bringspring.common.database.datatype.limit.FloatLimit;
import com.bringspring.common.database.datatype.limit.IntegerLimit;
import com.bringspring.common.database.datatype.limit.StringLimit;
import lombok.Generated;

public enum DtDMEnum implements DtInterface
{
    TINY_INT("TINYINT", new IntegerLimit()),
    SMALL_INT("SMALLINT", new IntegerLimit()),
    INT("INT", new IntegerLimit()),
    BIGINT("BIGINT", new IntegerLimit()),
    CHAR("CHAR", new StringLimit(true).charLength(32767L, 150L)),
    VARCHAR("VARCHAR", new StringLimit(true).bitLength(32767L, 150L)),
    VARCHAR2("VARCHAR2", new StringLimit(true).bitLength(32767L, 150L)),
    TEXT("TEXT", new StringLimit().fixedCharLength(Integer.MAX_VALUE)),
    CLOB("CLOB", new StringLimit().fixedCharLength(Integer.MAX_VALUE)),
    BLOB("BLOB", new StringLimit()),
    DATE("DATE", new DateTimeLimit()),
    DATE_TIME("DATETIME", new DateTimeLimit()),
    TIME_STAMP("TIMESTAMP", new DateTimeLimit()),
    TIME("TIME", new DateTimeLimit()),
    DECIMAL("DECIMAL", new DecimalLimit(true).precision(38, 18).scale(38, 3, 3)),
    DEC("DEC", new DecimalLimit(true).precision(38, 18).scale(38, 3, 3)),
    FLOAT("FLOAT", new FloatLimit(true).precision(24, 18).scale(30, 3)),
    DOUBLE("DOUBLE", new FloatLimit(true).precision(53, 18).scale(30, 3));

    private final String dataType;
    private final DtLimitBase dtLimit;

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public DtLimitBase getDtLimit() {
        return this.dtLimit;
    }

    @Generated
    private DtDMEnum(String dataType, DtLimitBase dtLimit) {
        this.dataType = dataType;
        this.dtLimit = dtLimit;
    }
}

