/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.db.interfaces;

import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.base.DtLimitModel;
import com.bringspring.common.database.datatype.viewshow.ViewDataTypeEnum;
import com.bringspring.common.util.StringUtils;
import java.util.function.BiFunction;

public interface DtInterface {
    public static final String CHARACTER_LENGTH = "CHARACTER_MAXIMUM_LENGTH";
    public static final String NUMERIC_PRECISION = "NUMERIC_PRECISION";
    public static final String NUMERIC_SCALE = "NUMERIC_SCALE";

    public String getDataType();

    public String name();

    public DtLimitBase getDtLimit();

    default public DtLimitModel getCharLengthLm() {
        return this.getDtLimit().getCharLengthLm();
    }

    default public DtLimitModel getBitLengthLm() {
        return this.getDtLimit().getBitLengthLm();
    }

    default public DtLimitModel getNumPrecisionLm() {
        return this.getDtLimit().getNumPrecisionLm();
    }

    default public DtLimitModel getNumScaleLm() {
        return this.getDtLimit().getNumScaleLm();
    }

    default public String getDtCategory() {
        return this.getDtLimit().getDtCategory();
    }

    default public Boolean getIsModifyFlag() {
        return this.getDtLimit().getIsModifyFlag();
    }

    default public String getJavaType() {
        return this.getDtLimit().getJavaType();
    }

    default public String getDbType() {
        return this.getClass().getSimpleName().replace("Dt", "").replace("Enum", "");
    }

    public static <T extends DtInterface> Class<T> getClz(String dbType) throws Exception {
        return Class.forName("jsbos.database.datatype.db.Dt" + dbType + "Enum");
    }

    public static DtInterface newInstanceByView(String viewDataType, String dbEncode) throws Exception {
        if (StringUtils.isNotNull(viewDataType)) {
            for (ViewDataTypeEnum value : ViewDataTypeEnum.values()) {
                if (!value.getViewFieldType().equalsIgnoreCase(viewDataType)) continue;
                switch (dbEncode) {
                    case "MySQL": {
                        return value.getDtMySQLEnum();
                    }
                    case "Oracle": {
                        return value.getDtOracleEnum();
                    }
                    case "SQLServer": {
                        return value.getDtSQLServerEnum();
                    }
                    case "DM8": {
                        return value.getDtDMEnum();
                    }
                    case "KingbaseES": {
                        return value.getDtKingbaseESEnum();
                    }
                    case "PostgreSQL": {
                        return value.getDtPostgreSQLEnum();
                    }
                }
            }
        }
        return null;
    }

    public static DtInterface newInstanceByDt(String dtDataType, String dbEncode) throws Exception {
        BiFunction<String, String, String> checkDataType = (dataType, dbType) -> {
            switch (dbType) {
                case "MySQL": {
                    if (dataType.equalsIgnoreCase("INT UNSIGNED")) {
                        return "int";
                    }
                    if (!dataType.equalsIgnoreCase("BIGINT UNSIGNED")) break;
                    return "bigint";
                }
            }
            return dataType;
        };
        for (DtInterface enumConstant : (DtInterface[])DtInterface.getClz(dbEncode).getEnumConstants()) {
            if (!enumConstant.getDataType().equalsIgnoreCase(checkDataType.apply(dtDataType, dbEncode))) continue;
            return enumConstant;
        }
        return null;
    }
}

