/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.AbstractSqlInjector;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.plugins.IgnoreStrategy;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.bringspring.common.config.ApplicationStartErrorCheck;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.util.ReflectionUtils;

public class MyDefaultSqlInjector
extends DefaultSqlInjector {
    private AbstractSqlInjector sqlInjector;
    private ConfigValueUtil configValueUtil;
    public static final String ignoreLogicPrefix = "Ilg";
    public static final Set<String> IGNOREMETHOD = new HashSet<String>();

    public MyDefaultSqlInjector(ConfigValueUtil configValueUtil) {
        this(null, configValueUtil);
    }

    public MyDefaultSqlInjector(ISqlInjector sqlInjector, ConfigValueUtil configValueUtil) {
        this.configValueUtil = configValueUtil;
        if (Objects.nonNull(sqlInjector) && sqlInjector instanceof AbstractSqlInjector) {
            this.sqlInjector = (AbstractSqlInjector)sqlInjector;
        }
    }

    public List<AbstractMethod> getMethodList(Configuration configuration, Class<?> mapperClass, TableInfo tableInfo) {
        return this.sqlInjector == null ? super.getMethodList(configuration, mapperClass, tableInfo) : this.sqlInjector.getMethodList(configuration, mapperClass, tableInfo);
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        ApplicationStartErrorCheck.getApplicationInitThreadPool().execute(() -> {
            try {
                super.inspectInject(builderAssistant, mapperClass);
            }
            catch (Exception e) {
                ApplicationStartErrorCheck.setStartError();
                throw e;
            }
        });
    }

    private List<AbstractMethod> methodFilter(List<AbstractMethod> list) {
        if (!this.configValueUtil.isEnableLogicDelete()) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            AbstractMethod abstractMethod = list.get(i);
            abstractMethod = this.enhancerMethod(abstractMethod);
            list.set(i, abstractMethod);
        }
        return list;
    }

    private AbstractMethod enhancerMethod(AbstractMethod method) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(method.getClass());
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
                MyDefaultSqlInjector.this.handleAddMappedStatement(o, method, objects, methodProxy);
                MyDefaultSqlInjector.this.handleInject(o, method, objects, methodProxy);
                return methodProxy.invokeSuper(o, objects);
            }
        });
        return (AbstractMethod)enhancer.create(new Class[]{String.class}, new Object[]{ReflectionUtil.getFieldValue(method, "methodName")});
    }

    public void handleAddMappedStatement(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws IllegalAccessException {
        if (method.getName().equals("addMappedStatement") && objects.length > 1 && objects[1] instanceof String) {
            String id = (String)objects[1];
            Field builderAssistantField = ReflectionUtils.findField(AbstractMethod.class, (String)"builderAssistant");
            if (builderAssistantField != null) {
                ReflectionUtils.makeAccessible((Field)builderAssistantField);
                MapperBuilderAssistant builderAssistant = (MapperBuilderAssistant)ReflectionUtils.getField((Field)builderAssistantField, (Object)o);
                String namespace = builderAssistant.getCurrentNamespace();
                String msId = builderAssistant.applyCurrentNamespace(id, false);
                Field ignoreCacheField = ReflectionUtils.findField(InterceptorIgnoreHelper.class, (String)"IGNORE_STRATEGY_CACHE");
                if (ignoreCacheField != null) {
                    IgnoreStrategy ignoreStrategy;
                    ReflectionUtils.makeAccessible((Field)ignoreCacheField);
                    Map cache = (Map)ignoreCacheField.get(null);
                    if (cache.containsKey(msId)) {
                        ignoreStrategy = (IgnoreStrategy)cache.get(msId);
                    } else {
                        ignoreStrategy = IgnoreStrategy.builder().build();
                        if (cache.containsKey(namespace)) {
                            BeanUtil.copyProperties(cache.get(namespace), (Object)ignoreStrategy, (String[])new String[0]);
                        }
                        cache.put(msId, ignoreStrategy);
                    }
                    HashMap<String, Boolean> others = ignoreStrategy.getOthers();
                    if (others == null) {
                        others = new HashMap<String, Boolean>();
                        ignoreStrategy.setOthers(others);
                    }
                    others.putIfAbsent(ignoreLogicPrefix, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInject(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        TableInfo tableInfo;
        String packageName = o.getClass().getPackage().getName();
        if (method.getName().equals("inject") && (packageName.startsWith("com.baomidou.mybatisplus.core.injector.methods") || packageName.startsWith("com.github.yulichang.method.mp")) && (tableInfo = (TableInfo)objects[3]).isWithLogicDelete()) {
            String methodName = (String)ReflectionUtil.getFieldValue(o, "methodName");
            try {
                ReflectionUtil.setFieldValue(tableInfo, "withLogicDelete", false);
                ReflectionUtil.setFieldValue(o, "methodName", methodName + ignoreLogicPrefix);
                methodProxy.invokeSuper(o, objects);
                IGNOREMETHOD.add(methodName);
            }
            finally {
                ReflectionUtil.setFieldValue(o, "methodName", methodName);
                ReflectionUtil.setFieldValue(tableInfo, "withLogicDelete", true);
            }
        }
    }
}

