/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import com.bringspring.common.database.plugins.LogicDeleteHandler;
import com.bringspring.common.database.util.LogicDeleteHelper;
import com.bringspring.common.util.StringUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyLogicDeleteInnerInterceptor
extends TenantLineInnerInterceptor
implements InnerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyLogicDeleteInnerInterceptor.class);
    private LogicDeleteHandler logicDeleteHandler;
    private static List<String> tableName = new ArrayList<String>();

    public MyLogicDeleteInnerInterceptor() {
        final MyLogicDeleteInnerInterceptor instance = this;
        super.setTenantLineHandler(new TenantLineHandler(){

            public String getTenantIdColumn() {
                return MyLogicDeleteInnerInterceptor.this.logicDeleteHandler.getLogicDeleteColumn();
            }

            public Expression getTenantId() {
                return MyLogicDeleteInnerInterceptor.this.logicDeleteHandler.getNotDeletedValue();
            }

            public boolean ignoreTable(String tableName) {
                return instance.ignoreTable(tableName);
            }
        });
    }

    private boolean isRemoveLogic() {
        return LogicDeleteHelper.isIgnoreLogicDelete();
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        block5: {
            if (InterceptorIgnoreHelper.willIgnoreOthersByKey((String)ms.getId(), (String)"Ilg")) {
                return;
            }
            if (ms.getId().endsWith("Ilg")) {
                return;
            }
            try {
                if (!this.isRemoveLogic() && boundSql.getSql().toLowerCase().contains(this.logicDeleteHandler.getLogicDeleteColumn().toLowerCase())) {
                    return;
                }
                PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
                mpBs.sql(this.parserSingle(mpBs.sql(), null));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("\u8bed\u53e5\u89e3\u6790\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        block6: {
            PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
            MappedStatement ms = mpSh.mappedStatement();
            if (InterceptorIgnoreHelper.willIgnoreOthersByKey((String)ms.getId(), (String)"Ilg")) {
                return;
            }
            if (ms.getId().endsWith("Ilg")) {
                return;
            }
            SqlCommandType sct = ms.getSqlCommandType();
            if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
                if (!this.isRemoveLogic() && mpSh.mPBoundSql().sql().toLowerCase().contains(this.logicDeleteHandler.getLogicDeleteColumn().toLowerCase())) {
                    return;
                }
                try {
                    PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
                    mpBs.sql(this.parserMulti(mpBs.sql(), null));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("\u8bed\u53e5\u89e3\u6790\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    protected String processParser(Statement statement, int index, String sql, Object obj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL to parse, SQL: " + sql);
        }
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement, index, sql, obj);
        } else if (statement instanceof Select) {
            this.processSelect((Select)statement, index, sql, obj);
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement, index, sql, obj);
        } else if (statement instanceof Delete) {
            if (this.isRemoveLogic()) {
                this.processDelete((Delete)statement, index, sql, obj);
            } else {
                statement = this.processDeleteToLogicDelete((Delete)statement, index, sql, obj);
            }
        }
        sql = statement.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("parse the finished SQL: " + sql);
        }
        return sql;
    }

    protected Statement processDeleteToLogicDelete(Delete delete, int index, String sql, Object obj) {
        if (super.getTenantLineHandler().ignoreTable(delete.getTable().getName())) {
            return delete;
        }
        Update updateStatement = null;
        try {
            updateStatement = (Update)CCJSqlParserUtil.parse((String)this.logicDeleteHandler.getDeleteSql());
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        updateStatement.setTable(delete.getTable());
        updateStatement.setWhere(delete.getWhere());
        return updateStatement;
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlank("logicDeleteHandler", ClassUtils::newInstance, this::setLogicDeleteHandler);
    }

    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        if (this.getTenantLineHandler().ignoreTable(table.getName())) {
            return null;
        }
        return this.getLogicExpression((Expression)this.getAliasColumn(table), this.logicDeleteHandler.getNotDeletedValue());
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName());
        } else {
            column.append(table.getName());
        }
        column.append(".").append(this.logicDeleteHandler.getLogicDeleteColumn());
        return new Column(column.toString());
    }

    protected Expression getLogicExpression(Expression column, Expression val) {
        if ("null".equalsIgnoreCase(val.toString())) {
            IsNullExpression isNullExpression = new IsNullExpression();
            isNullExpression.setLeftExpression(column);
            isNullExpression.setNot(false);
            return isNullExpression;
        }
        return new EqualsTo(column, val);
    }

    private boolean ignoreTable(String table) {
        if (StringUtils.isEmpty(table) || this.logicDeleteHandler.ignoreTable(table)) {
            return true;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)table);
        if (tableInfo != null) {
            return !tableInfo.isWithLogicDelete();
        }
        return true;
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables, String whereSegment) {
        if (this.isRemoveLogic()) {
            return this.removeCondition(currentExpression);
        }
        return super.builderExpression(currentExpression, tables, whereSegment);
    }

    protected Expression andExpression(Table table, Expression where, String whereSegment) {
        if (this.isRemoveLogic()) {
            return this.removeCondition(where);
        }
        return super.andExpression(table, where, whereSegment);
    }

    private Expression removeCondition(Expression expression) {
        String sql;
        if (expression != null && (sql = expression.toString()).contains(this.logicDeleteHandler.getLogicDeleteColumn())) {
            if (expression instanceof AndExpression || expression instanceof OrExpression) {
                BinaryExpression expression1 = (BinaryExpression)expression;
                expression1.setLeftExpression(this.removeCondition(expression1.getLeftExpression()));
                expression1.setRightExpression(this.removeCondition(expression1.getRightExpression()));
            }
            if (expression instanceof EqualsTo || expression instanceof NotEqualsTo || expression instanceof IsNullExpression) {
                return new EqualsTo((Expression)new LongValue(1L), (Expression)new LongValue(1L));
            }
        }
        return expression;
    }

    @Generated
    public LogicDeleteHandler getLogicDeleteHandler() {
        return this.logicDeleteHandler;
    }

    @Generated
    public void setLogicDeleteHandler(LogicDeleteHandler logicDeleteHandler) {
        this.logicDeleteHandler = logicDeleteHandler;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyLogicDeleteInnerInterceptor)) {
            return false;
        }
        MyLogicDeleteInnerInterceptor other = (MyLogicDeleteInnerInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogicDeleteHandler this$logicDeleteHandler = this.getLogicDeleteHandler();
        LogicDeleteHandler other$logicDeleteHandler = other.getLogicDeleteHandler();
        return !(this$logicDeleteHandler == null ? other$logicDeleteHandler != null : !this$logicDeleteHandler.equals(other$logicDeleteHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MyLogicDeleteInnerInterceptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LogicDeleteHandler $logicDeleteHandler = this.getLogicDeleteHandler();
        result = result * 59 + ($logicDeleteHandler == null ? 43 : $logicDeleteHandler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MyLogicDeleteInnerInterceptor(logicDeleteHandler=" + String.valueOf(this.getLogicDeleteHandler()) + ")";
    }
}

