/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.bringspring.common.database.util.ResetSetHolder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetInterceptor
implements Interceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        Object[] args = invocation.getArgs();
        Statement statement = (Statement)args[0];
        ResultSet rs = this.getFirstResultSet(statement);
        if (rs != null) {
            ResetSetHolder.setResultSet(rs);
        }
        try {
            result = invocation.proceed();
        }
        finally {
            ResetSetHolder.clear();
        }
        return result;
    }

    private ResultSet getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
                continue;
            }
            if (stmt.getUpdateCount() != -1) continue;
            break;
        }
        return rs;
    }
}

