/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class SqlPrintHandler {
    private StringBuffer sql = new StringBuffer();
    private StringBuffer sql2 = new StringBuffer();
    private String toDbType;
    private Boolean creFlag = false;
    private Boolean commentFlag = false;
    private Boolean insertFlag = false;
    private Boolean printFlag = false;
    private Boolean executeFlag = true;
    private File sqlFile;
    private File sqlFile2;

    public void start(String outPath, Boolean creFlag, Boolean commentFlag, Boolean insertFlag, String toDbType) throws Exception {
        this.printFlag = true;
        this.executeFlag = false;
        this.sqlFile = SqlPrintHandler.formatOutPath(outPath);
        this.creFlag = creFlag;
        this.commentFlag = commentFlag;
        this.insertFlag = insertFlag;
        this.toDbType = toDbType;
    }

    public static File formatOutPath(String outPath) throws Exception {
        File file = new File(outPath);
        if (file.exists()) {
            if (file.isDirectory()) {
                return file;
            }
            if (file.isFile()) {
                return new File(file.getParent());
            }
            throw new Exception("\u8def\u5f84\u5f02\u5e38");
        }
        boolean flag = file.mkdir();
        if (!flag) {
            throw new Exception("\u8def\u5f84\u5f02\u5e38");
        }
        return file;
    }

    public void close() {
        this.printFlag = false;
        this.creFlag = false;
        this.commentFlag = false;
        this.insertFlag = false;
        this.executeFlag = true;
        this.sqlFile = null;
        this.sqlFile2 = null;
        this.clear();
    }

    private void clear() {
        this.sql = new StringBuffer();
        this.sql2 = new StringBuffer();
    }

    public void setToDbType(String toDbType) {
        this.toDbType = toDbType;
    }

    public void setFileName(String fileName) {
        if (this.sqlFile.isFile()) {
            this.sqlFile = new File(this.sqlFile.getPath().replace(this.sqlFile.getName(), fileName));
        } else if (this.sqlFile.isDirectory()) {
            this.sqlFile = new File(this.sqlFile.getPath() + "/" + fileName);
        }
    }

    public Boolean creTable(String sql) {
        if (this.printFlag.booleanValue() && this.creFlag.booleanValue()) {
            this.sql.append(sql).append(";\n");
        }
        return this.printFlag;
    }

    public Boolean dropTable(String sql) {
        if (this.printFlag.booleanValue() && this.creFlag.booleanValue()) {
            this.sql.append(sql).append(";\n");
        }
        return this.printFlag;
    }

    public Boolean oracleAutoIncrement(String sql) {
        if (this.printFlag.booleanValue()) {
            this.sql.append(sql).append(";\n");
        }
        return this.printFlag;
    }

    public Boolean comment(String sql) {
        if (this.printFlag.booleanValue() && this.commentFlag.booleanValue()) {
            this.sql.append(sql).append(";\n");
        }
        return this.printFlag;
    }

    public void deleteAllInfo(String sql) {
        if (this.insertFlag.booleanValue()) {
            this.sql.append(sql).append(";\n");
        }
    }

    public Boolean insert(String sql) {
        if (this.printFlag.booleanValue() && this.insertFlag.booleanValue()) {
            this.sql.append(sql);
        }
        return this.printFlag;
    }

    public void updateClob(String sql) {
        if (this.insertFlag.booleanValue()) {
            this.sql2.append(";\n/\n").append(sql);
        }
    }

    public void tableInfo(String table) {
        table = "-- ----------------------------\n-- \u8868\u540d\uff1a" + (String)table + "\n-- ----------------------------\n";
        if (this.insertFlag.booleanValue()) {
            this.sql.append((String)table);
        }
    }

    public SqlPrintHandler append(String sql) {
        if (this.insertFlag.booleanValue()) {
            this.sql.append(sql);
        }
        return this;
    }

    public void print() throws Exception {
        if (this.printFlag.booleanValue()) {
            this.createSqlFile(this.sql.toString(), this.sqlFile);
        }
        this.clear();
    }

    private void createSqlFile(String outSql, File file) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        String CHARSET_UTF8 = "UTF-8";
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, CHARSET_UTF8);
        writer.append(outSql);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openDirectory(String folder) {
        File file = new File(folder);
        if (!file.exists()) {
            return;
        }
        Runtime runtime = null;
        try {
            runtime = Runtime.getRuntime();
            runtime.exec("cmd /c start explorer " + folder);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (null != runtime) {
                // empty if block
            }
        }
    }

    @Generated
    public String toString() {
        return "SqlPrintHandler(sql=" + String.valueOf(this.getSql()) + ", sql2=" + String.valueOf(this.getSql2()) + ", toDbType=" + this.getToDbType() + ", creFlag=" + this.getCreFlag() + ", commentFlag=" + this.getCommentFlag() + ", insertFlag=" + this.getInsertFlag() + ", printFlag=" + this.getPrintFlag() + ", executeFlag=" + this.getExecuteFlag() + ", sqlFile=" + String.valueOf(this.getSqlFile()) + ", sqlFile2=" + String.valueOf(this.getSqlFile2()) + ")";
    }

    @Generated
    public SqlPrintHandler() {
    }

    @Generated
    public StringBuffer getSql() {
        return this.sql;
    }

    @Generated
    public StringBuffer getSql2() {
        return this.sql2;
    }

    @Generated
    public String getToDbType() {
        return this.toDbType;
    }

    @Generated
    public Boolean getCreFlag() {
        return this.creFlag;
    }

    @Generated
    public Boolean getCommentFlag() {
        return this.commentFlag;
    }

    @Generated
    public Boolean getInsertFlag() {
        return this.insertFlag;
    }

    @Generated
    public Boolean getPrintFlag() {
        return this.printFlag;
    }

    @Generated
    public Boolean getExecuteFlag() {
        return this.executeFlag;
    }

    @Generated
    public File getSqlFile() {
        return this.sqlFile;
    }

    @Generated
    public File getSqlFile2() {
        return this.sqlFile2;
    }

    @Generated
    public void setSql(StringBuffer sql) {
        this.sql = sql;
    }

    @Generated
    public void setSql2(StringBuffer sql2) {
        this.sql2 = sql2;
    }

    @Generated
    public void setCreFlag(Boolean creFlag) {
        this.creFlag = creFlag;
    }

    @Generated
    public void setCommentFlag(Boolean commentFlag) {
        this.commentFlag = commentFlag;
    }

    @Generated
    public void setInsertFlag(Boolean insertFlag) {
        this.insertFlag = insertFlag;
    }

    @Generated
    public void setPrintFlag(Boolean printFlag) {
        this.printFlag = printFlag;
    }

    @Generated
    public void setExecuteFlag(Boolean executeFlag) {
        this.executeFlag = executeFlag;
    }

    @Generated
    public void setSqlFile2(File sqlFile2) {
        this.sqlFile2 = sqlFile2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlPrintHandler)) {
            return false;
        }
        SqlPrintHandler other = (SqlPrintHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$creFlag = this.getCreFlag();
        Boolean other$creFlag = other.getCreFlag();
        if (this$creFlag == null ? other$creFlag != null : !((Object)this$creFlag).equals(other$creFlag)) {
            return false;
        }
        Boolean this$commentFlag = this.getCommentFlag();
        Boolean other$commentFlag = other.getCommentFlag();
        if (this$commentFlag == null ? other$commentFlag != null : !((Object)this$commentFlag).equals(other$commentFlag)) {
            return false;
        }
        Boolean this$insertFlag = this.getInsertFlag();
        Boolean other$insertFlag = other.getInsertFlag();
        if (this$insertFlag == null ? other$insertFlag != null : !((Object)this$insertFlag).equals(other$insertFlag)) {
            return false;
        }
        Boolean this$printFlag = this.getPrintFlag();
        Boolean other$printFlag = other.getPrintFlag();
        if (this$printFlag == null ? other$printFlag != null : !((Object)this$printFlag).equals(other$printFlag)) {
            return false;
        }
        Boolean this$executeFlag = this.getExecuteFlag();
        Boolean other$executeFlag = other.getExecuteFlag();
        if (this$executeFlag == null ? other$executeFlag != null : !((Object)this$executeFlag).equals(other$executeFlag)) {
            return false;
        }
        StringBuffer this$sql = this.getSql();
        StringBuffer other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        StringBuffer this$sql2 = this.getSql2();
        StringBuffer other$sql2 = other.getSql2();
        if (this$sql2 == null ? other$sql2 != null : !this$sql2.equals(other$sql2)) {
            return false;
        }
        String this$toDbType = this.getToDbType();
        String other$toDbType = other.getToDbType();
        if (this$toDbType == null ? other$toDbType != null : !this$toDbType.equals(other$toDbType)) {
            return false;
        }
        File this$sqlFile = this.getSqlFile();
        File other$sqlFile = other.getSqlFile();
        if (this$sqlFile == null ? other$sqlFile != null : !((Object)this$sqlFile).equals(other$sqlFile)) {
            return false;
        }
        File this$sqlFile2 = this.getSqlFile2();
        File other$sqlFile2 = other.getSqlFile2();
        return !(this$sqlFile2 == null ? other$sqlFile2 != null : !((Object)this$sqlFile2).equals(other$sqlFile2));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlPrintHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $creFlag = this.getCreFlag();
        result = result * 59 + ($creFlag == null ? 43 : ((Object)$creFlag).hashCode());
        Boolean $commentFlag = this.getCommentFlag();
        result = result * 59 + ($commentFlag == null ? 43 : ((Object)$commentFlag).hashCode());
        Boolean $insertFlag = this.getInsertFlag();
        result = result * 59 + ($insertFlag == null ? 43 : ((Object)$insertFlag).hashCode());
        Boolean $printFlag = this.getPrintFlag();
        result = result * 59 + ($printFlag == null ? 43 : ((Object)$printFlag).hashCode());
        Boolean $executeFlag = this.getExecuteFlag();
        result = result * 59 + ($executeFlag == null ? 43 : ((Object)$executeFlag).hashCode());
        StringBuffer $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        StringBuffer $sql2 = this.getSql2();
        result = result * 59 + ($sql2 == null ? 43 : $sql2.hashCode());
        String $toDbType = this.getToDbType();
        result = result * 59 + ($toDbType == null ? 43 : $toDbType.hashCode());
        File $sqlFile = this.getSqlFile();
        result = result * 59 + ($sqlFile == null ? 43 : ((Object)$sqlFile).hashCode());
        File $sqlFile2 = this.getSqlFile2();
        result = result * 59 + ($sqlFile2 == null ? 43 : ((Object)$sqlFile2).hashCode());
        return result;
    }
}

