/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.param;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.JdbcColumnModel;
import com.bringspring.common.exception.DataTypeException;

public class FormatSqlMySQL {
    public static String singleQuotes(String value) {
        return value.replace("'", "\\'");
    }

    public static Object getMysqlValue(JdbcColumnModel dbColumnModel) {
        return dbColumnModel.getValue();
    }

    public static void checkMysqlFieldPrimary(DbFieldModel field, String table) throws DataTypeException {
        if (field.getIsPrimaryKey().booleanValue()) {
            switch ((DtMySQLEnum)field.getDtModelDTO().getConvertTargetDtEnum()) {
                case BLOB: 
                case TINY_TEXT: 
                case MEDIUM_TEXT: 
                case TEXT: 
                case LONG_TEXT: {
                    throw new DataTypeException(MsgCode.DB014.get(table, field.getField(), field.getDtModelDTO().getDtEnum().getDataType()));
                }
                case VARCHAR: {
                    if (field.getDtModelDTO().getCharLength() <= 768L) break;
                    field.getDtModelDTO().setCharLength(768L);
                    break;
                }
            }
        }
    }
}

