/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.util;

import com.bringspring.common.base.Pagination;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbtable.DbTableFieldModel;
import com.bringspring.common.database.model.dto.PrepSqlDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.sql.enums.base.SqlComEnum;
import com.bringspring.common.database.sql.model.SqlPrintHandler;
import com.bringspring.common.database.sql.param.FormatSqlOracle;
import com.bringspring.common.database.sql.param.base.FormatSql;
import com.bringspring.common.database.sql.util.SqlFrameUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.context.SpringContext;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFastUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlFastUtil.class);
    private static SqlPrintHandler sqlPrintHandler = SpringContext.getBean(SqlPrintHandler.class);

    public static void creTable(DbLinkEntity dbLinkEntity, DbTableFieldModel dbTableFieldModel) throws Exception {
        ArrayList<String> primaryKeys;
        List<DbFieldModel> dbFieldModelList = dbTableFieldModel.getDbFieldModelList();
        ArrayList<CallSite> fieldSqlList = new ArrayList<CallSite>();
        if (CollectionUtils.isNotEmpty(dbFieldModelList)) {
            primaryKeys = new ArrayList<String>();
            for (DbFieldModel fieldModel : dbFieldModelList) {
                Matcher matcher;
                String fieldSql = SqlComEnum.CREATE_TABLE.getOutSqlByDb(dbLinkEntity.getDbType(), "", FormatSql.getFieldName(fieldModel.getField(), dbLinkEntity.getDbType()), fieldModel.formatDataTypeByView(dbLinkEntity.getDbType()), FormatSql.defaultCheck(fieldModel, dbLinkEntity.getDbType()), fieldModel.getNullSign().equals("NOT NULL") ? fieldModel.getNullSign() : "", fieldModel.getIsAutoIncrement() != null && fieldModel.getIsAutoIncrement() != false ? "AUTO_INCREMENT" : "", "COMMENT '" + fieldModel.getComment() + "'");
                if (fieldModel.getIsPrimaryKey().booleanValue()) {
                    primaryKeys.add(fieldModel.getField());
                }
                if ((matcher = Pattern.compile("\u3010([\\s\\S]+)\u3011").matcher(fieldSql)).find()) {
                    String fieldSqlFragment = matcher.group(1);
                    fieldSqlList.add((CallSite)((Object)("\t" + fieldSqlFragment.replaceAll("\\s+", " ").trim())));
                    continue;
                }
                throw new DataException(MsgCode.DB015.get());
            }
        } else {
            throw new DataException(MsgCode.DB016.get());
        }
        String sql = SqlComEnum.CREATE_TABLE.getOutSqlByDb(dbLinkEntity.getDbType(), SqlFrameUtil.htmlE(dbTableFieldModel.getTable()), null, null, null, null, null, null, StringUtils.join(primaryKeys, (String)",")).replaceAll("\u3010.+\u3011", StringUtils.join(fieldSqlList, (String)",\n"));
        NotTenantPluginHolder.setNotSwitchFlag();
        FormatSqlOracle.autoIncrement(dbLinkEntity, dbTableFieldModel);
        SqlFastUtil.commentTable(dbLinkEntity, dbTableFieldModel.getTable(), dbTableFieldModel.getComment());
        if (!DbTypeUtil.checkMySQL(dbLinkEntity).booleanValue()) {
            SqlFastUtil.creTableCommentFiled(dbLinkEntity, dbTableFieldModel.getTable(), dbFieldModelList);
        }
    }

    public static Boolean dropTable(DbLinkEntity dbLinkEntity, String table) throws Exception {
        NotTenantPluginHolder.setNotSwitchFlag();
        String sql = SqlComEnum.DROP_TABLE.getOutSql(SqlFrameUtil.htmlE(table));
        int flag = 0;
        if (!sqlPrintHandler.dropTable(sql).booleanValue()) {
            // empty if block
        }
        return flag > 0;
    }

    public static Boolean commentTable(DbLinkEntity dbLinkEntity, String table, String comment) throws Exception {
        String sql = SqlComEnum.COMMENT_TABLE.getOutSqlByDb(dbLinkEntity.getDbType(), SqlFrameUtil.htmlE(table), "'" + SqlFrameUtil.htmlE(comment) + "'");
        NotTenantPluginHolder.setNotSwitchFlag();
        return true;
    }

    private static Boolean creTableCommentFiled(DbLinkEntity dbLinkEntity, String table, List<DbFieldModel> dbFieldModelList) throws Exception {
        String dbEncode = dbLinkEntity.getDbType();
        for (DbFieldModel dbFieldModel : dbFieldModelList) {
            String string = SqlComEnum.COMMENT_COLUMN.getOutSqlByDb(dbEncode, table, FormatSql.getFieldName(dbFieldModel.getField(), dbEncode), "'" + dbFieldModel.getComment() + "'", dbFieldModel.formatDataTypeByView(dbEncode), null);
        }
        return true;
    }

    public static String[] getPageSql(String dbEncode, String selectSql, String orderColumn, String orderSign, Integer currentPage, Integer pageSize) throws DataException {
        if (StringUtils.isEmpty((CharSequence)orderColumn)) {
            throw new DataException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u6392\u5e8f\u5b57\u6bb5");
        }
        orderSign = StringUtils.isEmpty((CharSequence)orderSign) ? "" : orderSign;
        String beginIndex = Integer.toString((currentPage - 1) * pageSize);
        String endIndex = Integer.toString(currentPage * pageSize);
        return new String[]{SqlComEnum.ORDER_PAGE.getOutSqlByDb(dbEncode, selectSql, orderColumn, beginIndex, endIndex, pageSize.toString(), orderSign), SqlComEnum.COUNT_SIZE.getOutSqlByDb(dbEncode, DbAliasEnum.TOTAL_RECORD.getAlias(dbEncode), selectSql)};
    }

    public static String[] getPageSql(String dbEncode, String selectSql, Pagination pagination) throws DataException {
        return SqlFastUtil.getPageSql(dbEncode, selectSql, pagination.getSidx(), pagination.getSort(), Long.valueOf(pagination.getCurrentPage()).intValue(), Long.valueOf(pagination.getPageSize()).intValue());
    }

    public static void batchInsert(String table, DbLinkEntity dbLinkEntity, List<Map<String, Object>> multiDataMapList) throws Exception {
        if (sqlPrintHandler.getPrintFlag().booleanValue() && multiDataMapList.size() > 0) {
            sqlPrintHandler.deleteAllInfo(SqlComEnum.DELETE_ALL.getOutSqlByDb(dbLinkEntity.getDbType(), table));
        }
        int total = multiDataMapList.size();
        int start = 1;
        for (Map<String, Object> dataMap : multiDataMapList) {
            if (total > 100) {
                log.info("\u8868:" + table + "_\u6570\u636e\uff1a(" + start + "/" + total + ")");
                ++start;
            }
            SqlFastUtil.insert(dbLinkEntity, table, dataMap);
        }
    }

    public static void insert(DbLinkEntity dbLinkEntity, String table, Map<String, Object> dataMap) throws Exception {
        String dbEncode = dbLinkEntity.getDbType();
        if (sqlPrintHandler.getPrintFlag().booleanValue()) {
            sqlPrintHandler.insert(SqlFastUtil.formatInsertSql(dataMap, table, dbEncode));
        } else {
            ArrayList<String> formatFieldList = new ArrayList<String>();
            ArrayList<String> signList = new ArrayList<String>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Map.Entry<String, Object> map : dataMap.entrySet()) {
                signList.add("?");
                valueList.add(map.getValue());
                formatFieldList.add(FormatSql.getFieldName(map.getKey(), dbEncode));
            }
            PrepSqlDTO prepSqlDTO = new PrepSqlDTO(SqlComEnum.INSERT.getOutSqlByDb(dbEncode, table, String.join((CharSequence)",", formatFieldList), String.join((CharSequence)",", signList)), valueList).withConn(dbLinkEntity);
        }
    }

    private static String formatInsertSql(Map<String, Object> dataMap, String table, String dbEncode) {
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        StringBuilder oracleClobUpdate = new StringBuilder();
        for (Map.Entry<String, Object> field : dataMap.entrySet()) {
            String column = field.getKey();
            Object columnValue = field.getValue();
            columnValue = FormatSqlOracle.clobExecute(dbEncode, columnValue, table, field.getKey(), dataMap, oracleClobUpdate);
            columnValue = FormatSqlOracle.blobExecute(dbEncode, columnValue, table, field.getKey(), dataMap, oracleClobUpdate);
            fieldList.add(FormatSql.getFieldName(column, dbEncode));
            valueList.add(FormatSql.formatValue(columnValue, dbEncode));
        }
        return SqlComEnum.INSERT.getOutSqlByDb(dbEncode, table, String.join((CharSequence)",", fieldList), String.join((CharSequence)",", valueList)) + ";\n" + (StringUtils.isNotEmpty((CharSequence)oracleClobUpdate) ? oracleClobUpdate.toString() : "");
    }

    public static String getFuzzyQuerySql(String selectSql, String column, String keyWord) throws DataException {
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            return SqlComEnum.LIKE.getOutSql(selectSql, column, "%" + keyWord + "%");
        }
        return selectSql;
    }
}

