/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.TenantLinkModel;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.plugins.MySchemaInnerInterceptor;
import com.bringspring.common.database.plugins.MyTenantLineInnerInterceptor;
import com.bringspring.common.database.source.impl.DbKingbase;
import com.bringspring.common.database.source.impl.DbPostgre;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.exception.TenantInvalidException;
import com.bringspring.common.model.tenant.TenantAuthorizeModel;
import com.bringspring.common.model.tenant.TenantMenuModel;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.LockObjectUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TenantDataSourceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantDataSourceUtil.class);
    public static final String DBLINK_KEY = "TenantInfo";
    public static final String MODULEID_KEY = "ModuleAuthorize";
    private static ConfigValueUtil configValueUtil;
    private static MyTenantLineInnerInterceptor myTenantLineInnerInterceptor;
    private static MySchemaInnerInterceptor mySchemaInnerInterceptor;
    private static boolean absentPermittionApi;

    @Autowired(required=false)
    public void setDynamicTableNameInnerInterceptor(MySchemaInnerInterceptor mySchemaInnerInterceptor) {
        TenantDataSourceUtil.mySchemaInnerInterceptor = mySchemaInnerInterceptor;
    }

    @Autowired(required=false)
    public void setMyTenantLineInnerInterceptor(MyTenantLineInnerInterceptor myTenantLineInnerInterceptor) {
        TenantDataSourceUtil.myTenantLineInnerInterceptor = myTenantLineInnerInterceptor;
    }

    @Autowired
    public void setConfigValueUtil(ConfigValueUtil configValueUtil) {
        TenantDataSourceUtil.configValueUtil = configValueUtil;
    }

    public static void clearLocalTenantInfo() {
        TenantHolder.clearLocalTenantCache();
        DataSourceContextHolder.clearDatasourceType();
    }

    public static void setCacheTenantInfo(String tenantCode, TenantVO tenant) {
        TenantProvider.putTenantCache(tenantCode, DBLINK_KEY, tenant);
    }

    public static void setCacheModuleAuthorize(String tenantCode, TenantAuthorizeModel tenantAuthorizeModel) {
        TenantProvider.putTenantCache(tenantCode, MODULEID_KEY, tenantAuthorizeModel);
    }

    public static void setTenantInfo(TenantVO tenantInfo) {
        TenantDataSourceUtil.setCacheTenantInfo(tenantInfo.getEnCode(), tenantInfo);
        TenantHolder.setLocalTenantCache(tenantInfo);
    }

    public static TenantVO getTenantInfo() {
        return TenantDataSourceUtil.getTenantInfo(null);
    }

    public static TenantVO getTenantInfo(String tenantCode) {
        UserInfo userInfo;
        if (!TenantDataSourceUtil.isMultiTenancy()) {
            return null;
        }
        TenantVO tenantVO = TenantHolder.getLocalTenantCache();
        if (StringUtils.isEmpty(tenantCode) && tenantCode == null && (userInfo = UserProvider.getUser()) != null && userInfo.getUserId() != null) {
            tenantCode = userInfo.getTenantId();
        }
        if (tenantVO != null && StringUtils.isNotEmpty(tenantCode) && !Objects.equals(tenantVO.getEnCode(), tenantCode)) {
            tenantVO = null;
        }
        if (StringUtils.isEmpty(tenantCode) && tenantVO == null) {
            return null;
        }
        if (tenantVO == null && (tenantVO = TenantDataSourceUtil.getCacheTenantInfo(tenantCode)) == null) {
            tenantVO = TenantDataSourceUtil.getRemoteTenantInfo(tenantCode);
        }
        return tenantVO;
    }

    public static TenantVO getCacheTenantInfo(String tenantCode) {
        return (TenantVO)TenantProvider.getTenantCache(tenantCode, DBLINK_KEY);
    }

    public static TenantAuthorizeModel getCacheModuleAuthorize(String tenantCode) {
        TenantAuthorizeModel tenantCache = (TenantAuthorizeModel)TenantProvider.getTenantCache(tenantCode, MODULEID_KEY);
        return Optional.ofNullable(tenantCache).isPresent() ? tenantCache : new TenantAuthorizeModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantVO getRemoteTenantInfo(String tenantCode) throws LoginException {
        TenantVO vo;
        if (!TenantDataSourceUtil.isMultiTenancy()) {
            return null;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            throw new LoginException(MsgCode.LOG114.get());
        }
        HashMap<String, String> headers = new HashMap<String, String>(2, 1.0f);
        headers.put("SA-SAME-TOKEN", UserProvider.getInnerAuthToken());
        try {
            String ip = IpUtil.getIpAddr();
            if (StringUtils.isNotEmpty(ip) && !Objects.equals("127.0.0.1", ip)) {
                headers.put("X-Forwarded-For", ip);
            }
        }
        catch (Exception ip) {
            // empty catch block
        }
        JSONObject object = null;
        try (HttpResponse execute = ((HttpRequest)HttpRequest.get((String)(configValueUtil.getMultiTenancyUrl() + tenantCode)).addHeaders(headers)).execute();){
            object = JSON.parseObject((String)execute.body());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8fdc\u7aef\u591a\u79df\u6237\u4fe1\u606f\u5931\u8d25: {}", (Object)e.getMessage());
        }
        if (object == null || "500".equals(object.get((Object)"code").toString())) {
            throw new LoginException(MsgCode.LOG105.get());
        }
        if (!"200".equals(object.getString("code"))) {
            log.error("\u83b7\u53d6\u591a\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)object.getString("msg"));
            JSONObject data = null;
            if (!object.containsKey((Object)"data")) throw new TenantInvalidException(object.getString("msg")).setData(data);
            data = object.getJSONObject("data");
            throw new TenantInvalidException(object.getString("msg")).setData(data);
        }
        JSONObject resulList = object.getJSONObject("data");
        if (resulList.containsKey((Object)"db_names")) {
            vo = JsonUtil.getJsonToBean(resulList.getJSONObject("db_names"), TenantVO.class);
            if (vo.getDbName() == null) {
                vo.setDbName((String)resulList.getJSONObject("db_names").get((Object)"java"));
            }
            vo.setWl_qrcode((Map)resulList.getObject("wl_qrcode", (TypeReference)new TypeReference<Map<String, String>>(){}));
        } else {
            vo = new TenantVO();
            vo.setDbName(resulList.getString("java"));
        }
        if (Objects.equals(vo.getType(), 2)) {
            vo.setDbName(vo.getLinkList().stream().filter(l -> l.getConfigType().equals(0)).findFirst().get().getServiceName());
        } else if (StringUtils.isEmpty(vo.getDbName())) {
            throw new TenantInvalidException().setLogMsg(MsgCode.LOG118.get());
        }
        vo.setEnCode(tenantCode);
        TenantDataSourceUtil.setCacheTenantInfo(tenantCode, vo);
        if (absentPermittionApi) return vo;
        try (HttpResponse execute = ((HttpRequest)HttpRequest.get((String)(configValueUtil.getMultiTenancyUrl() + "authorize/" + tenantCode)).addHeaders(headers)).execute();){
            switch (execute.getStatus()) {
                case 200: {
                    TenantMenuModel model = JsonUtil.getJsonToBean(execute.body(), TenantMenuModel.class);
                    TenantAuthorizeModel tenantAuthorizeModel = new TenantAuthorizeModel(model.getIds(), model.getUrlAddressList());
                    TenantDataSourceUtil.setCacheModuleAuthorize(tenantCode, tenantAuthorizeModel);
                    return vo;
                }
                case 404: {
                    absentPermittionApi = true;
                    log.error("\u79df\u6237\u7cfb\u7edf\u4e0d\u5b58\u5728\u6743\u9650\u7ba1\u7406\u63a5\u53e3, \u5173\u95ed\u6743\u9650\u8bf7\u6c42\u529f\u80fd");
                    return vo;
                }
                default: {
                    log.error("\u83b7\u53d6\u8fdc\u7aef\u591a\u79df\u6237\u83dc\u5355\u6743\u9650\u5931\u8d25: {}, {}", (Object)tenantCode, (Object)execute.body());
                    return vo;
                }
            }
        }
        catch (Exception e) {
            TenantDataSourceUtil.setCacheModuleAuthorize(tenantCode, new TenantAuthorizeModel());
            log.error("\u83b7\u53d6\u8fdc\u7aef\u591a\u79df\u6237\u83dc\u5355\u6743\u9650\u5931\u8d25: {}, {}", (Object)tenantCode, (Object)e.getMessage());
        }
        return vo;
    }

    public static TenantLinkModel getTenantAssignDataSource(String tenantCode) {
        List<TenantLinkModel> linkList = TenantDataSourceUtil.getTenantAssignDataSourceList(tenantCode);
        return linkList.stream().filter(link -> link.getConfigType().equals(0)).findFirst().orElse(null);
    }

    public static List<TenantLinkModel> getTenantAssignDataSourceList(String tenantCode) {
        if (TenantDataSourceUtil.isMultiTenancy()) {
            TenantVO tenantVO = TenantDataSourceUtil.getTenantInfo(tenantCode);
            List<TenantLinkModel> linkList = tenantVO.getLinkList();
            return linkList;
        }
        return Collections.EMPTY_LIST;
    }

    public static void resetUserTenant() {
    }

    public static TenantVO switchTenant(String tenantCode) {
        if (!TenantDataSourceUtil.isMultiTenancy()) {
            return null;
        }
        TenantHolder.clearLocalTenantCache();
        TenantVO tenantVO = TenantDataSourceUtil.getTenantInfo(tenantCode);
        TenantDataSourceUtil.switchTenant(tenantCode, tenantVO);
        return tenantVO;
    }

    public static void switchTenant(String tenantCode, TenantVO tenantVO) throws LoginException {
        if (!TenantDataSourceUtil.isMultiTenancy()) {
            return;
        }
        if (!Optional.ofNullable(tenantVO).isPresent()) {
            throw new LoginException(MsgCode.LOG115.get());
        }
        boolean isAssign = Objects.equals(tenantVO.getType(), 2);
        TenantHolder.setLocalTenantCache(tenantVO);
        try {
            TenantDataSourceUtil.initTenantAssignDataSource(tenantVO);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        DataSourceContextHolder.setDatasource(tenantCode, tenantVO.getDbName(), isAssign);
    }

    public static String getTenantSchema() {
        String result = "";
        if (TenantDataSourceUtil.isTenantSchema()) {
            result = TenantDataSourceUtil.getTenantName();
        }
        return result;
    }

    public static String getTenantColumn() {
        String result = "0";
        if (TenantDataSourceUtil.isTenantColumn()) {
            result = TenantDataSourceUtil.getTenantName();
        }
        return result;
    }

    public static String getTenantDbName() {
        String result = "";
        if (TenantDataSourceUtil.isMultiTenancy()) {
            DataSourceUtil dataSourceUtil = DynamicDataSourceUtil.getDataSourceUtil();
            if (TenantDataSourceUtil.isTenantColumn()) {
                switch (dataSourceUtil.getDbType()) {
                    case "PostgreSQL": {
                        result = StringUtils.isEmpty(dataSourceUtil.getDbSchema()) ? DbPostgre.DEF_SCHEMA : dataSourceUtil.getDbSchema();
                        break;
                    }
                    case "KingbaseES": {
                        result = StringUtils.isEmpty(dataSourceUtil.getDbSchema()) ? DbKingbase.DEF_SCHEMA : dataSourceUtil.getDbSchema();
                        break;
                    }
                    default: {
                        result = dataSourceUtil.getDbName();
                        break;
                    }
                }
            } else {
                result = TenantHolder.getDatasourceName();
                result = TenantDataSourceUtil.convertSchemaName(result);
            }
        }
        return result;
    }

    public static void initDataSourceTenantDbName(DbSourceOrDbLink dataSourceUtil) {
        if (TenantDataSourceUtil.isMultiTenancy()) {
            if (TenantDataSourceUtil.isTenantAssignDataSource()) {
                return;
            }
            if (!(dataSourceUtil instanceof DataSourceUtil) || dataSourceUtil instanceof DbLinkEntity && !"0".equals(((DbLinkEntity)dataSourceUtil).getId()) && ((DbLinkEntity)dataSourceUtil).getId() != null) {
                return;
            }
            boolean isColumn = TenantDataSourceUtil.isTenantColumn();
            DataSourceUtil ds = (DataSourceUtil)dataSourceUtil;
            switch (ds.getDbType()) {
                case "PostgreSQL": {
                    if (isColumn) {
                        if (!StringUtils.isEmpty(ds.getDbSchema())) break;
                        ds.setDbSchema(DbPostgre.DEF_SCHEMA);
                        break;
                    }
                    ds.setDbSchema(TenantDataSourceUtil.getTenantDbName());
                    break;
                }
                case "KingbaseES": {
                    if (isColumn) {
                        if (!StringUtils.isEmpty(ds.getDbSchema())) break;
                        ds.setDbSchema(DbKingbase.DEF_SCHEMA);
                        break;
                    }
                    ds.setDbSchema(TenantDataSourceUtil.getTenantDbName());
                    break;
                }
                case "DM8": 
                case "Oracle": {
                    ds.setDbSchema(TenantDataSourceUtil.getTenantDbName());
                    break;
                }
                default: {
                    ds.setDbName(TenantDataSourceUtil.getTenantDbName());
                }
            }
        }
    }

    public static String getTenantName() {
        String result = "";
        if (TenantDataSourceUtil.isMultiTenancy() && !TenantDataSourceUtil.getTenantInfo().isRemote()) {
            result = TenantHolder.getDatasourceName();
            result = TenantDataSourceUtil.convertSchemaName(result);
        }
        return result;
    }

    public static String convertSchemaName(String dbName) {
        if (StringUtils.isNotEmpty(dbName)) {
            switch (DynamicDataSourceUtil.dataSourceUtil.getDbType()) {
                case "PostgreSQL": {
                    dbName = dbName.toLowerCase();
                    break;
                }
                case "DM8": 
                case "Oracle": {
                    dbName = dbName.toUpperCase();
                }
            }
        }
        return dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTenantAssignDataSource(TenantVO tenantVO) throws SQLException {
        if (TenantDataSourceUtil.isTenantAssignDataSource()) {
            String tenantId = TenantHolder.getDatasourceId();
            String dbKey = tenantId + "-master";
            Object object = LockObjectUtil.addLockKey(tenantId);
            synchronized (object) {
                if (!DynamicDataSourceUtil.dynamicRoutingDataSource.getGroupDataSources().containsKey(dbKey)) {
                    ArrayList<String> list = new ArrayList<String>(16);
                    List<TenantLinkModel> linkList = tenantVO.getLinkList();
                    Assert.notNull(linkList, (String)MsgCode.FA035.get());
                    String mKey = dbKey + "_";
                    String sKey = tenantId + "-slave_";
                    for (TenantLinkModel model : linkList) {
                        DbLinkEntity dbLinkEntity = model.toDbLink(new DbLinkEntity());
                        if ("0".equals(String.valueOf(model.getConfigType()))) {
                            dbLinkEntity.setId(mKey + dbLinkEntity.getId());
                        } else {
                            dbLinkEntity.setId(sKey + dbLinkEntity.getId());
                        }
                        try {
                            DruidDataSource dataSource = new DruidDataSource();
                            dataSource.getConnection().close();
                            list.add(dbLinkEntity.getId());
                            DynamicDataSourceUtil.dynamicRoutingDataSource.addDataSource(dbLinkEntity.getId(), (DataSource)dataSource);
                        }
                        catch (SQLException e) {
                            for (String s : list) {
                                try {
                                    DynamicDataSourceUtil.dynamicRoutingDataSource.removeDataSource(s);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                            throw e;
                        }
                    }
                }
            }
        }
    }

    public static void removeAllAssignDataSource() {
        if (TenantDataSourceUtil.isTenantAssignDataSource()) {
            String tenantId = TenantHolder.getDatasourceId();
            String dbKey = tenantId + "-master";
            TenantVO tenantVO = TenantDataSourceUtil.getTenantInfo();
            if (tenantVO != null) {
                List<TenantLinkModel> linkList = tenantVO.getLinkList();
                if (linkList != null) {
                    String mKey = dbKey + "_";
                    String sKey = tenantId + "-slave_";
                    for (TenantLinkModel model : linkList) {
                        DbLinkEntity dbLinkEntity = model.toDbLink(new DbLinkEntity());
                        String key = "0".equals(String.valueOf(model.getConfigType())) ? mKey + dbLinkEntity.getId() : sKey + dbLinkEntity.getId();
                        try {
                            DataSource dataSource = (DataSource)DynamicDataSourceUtil.dynamicRoutingDataSource.getDataSources().get(key);
                            if (dataSource instanceof ItemDataSource && ((ItemDataSource)dataSource).getRealDataSource() instanceof DruidDataSource) {
                                ((DruidDataSource)((ItemDataSource)dataSource).getRealDataSource()).setBreakAfterAcquireFailure(true);
                            }
                            DynamicDataSourceUtil.dynamicRoutingDataSource.removeDataSource(key);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                log.error("\u83b7\u53d6\u7f13\u5b58\u79df\u6237\u5e93\u5217\u8868\u5931\u8d25: {}", (Object)tenantId);
            }
        }
    }

    public static String getTenantAssignDataSourceMasterKeyName() {
        if (TenantDataSourceUtil.isTenantAssignDataSource()) {
            return TenantHolder.getDatasourceId() + "-master";
        }
        return "";
    }

    public static boolean isMultiTenancy() {
        return configValueUtil.isMultiTenancy();
    }

    public static boolean isTenantAssignDataSource() {
        return TenantDataSourceUtil.isMultiTenancy() && TenantDataSourceUtil.getTenantInfo().isRemote();
    }

    public static boolean isTenantColumn() {
        return TenantDataSourceUtil.isMultiTenancy() && TenantDataSourceUtil.getTenantInfo().isColumn();
    }

    public static boolean isTenantSchema() {
        return TenantDataSourceUtil.isMultiTenancy() && TenantDataSourceUtil.getTenantInfo().isSchema();
    }

    public static String parseTenantSql(String sql) {
        if (TenantDataSourceUtil.isTenantColumn()) {
            try {
                Statement statement = CCJSqlParserUtil.parse((String)sql);
                if (statement instanceof Select) {
                    return myTenantLineInnerInterceptor.parserSingle(sql, null);
                }
                return myTenantLineInnerInterceptor.parserMulti(sql, null);
            }
            catch (JSQLParserException e) {
                throw new RuntimeException(e);
            }
        }
        if (TenantDataSourceUtil.isTenantSchema()) {
            return mySchemaInnerInterceptor.changeTable(sql);
        }
        return sql;
    }

    public static boolean checkOfficialSmsCode(String mobile, String code, int type) throws LoginException {
        String url = switch (type) {
            case 1 -> configValueUtil.getMultiTenancyOfficialLoginCodeUrl();
            case 2 -> configValueUtil.getMultiTenancyOfficialResetCodeUrl();
            default -> throw new RuntimeException(MsgCode.LOG116.get());
        };
        JSONObject object = null;
        try (HttpResponse execute = HttpRequest.get((String)String.format("%s%s/%s", url, mobile, code)).execute();){
            object = JSON.parseObject((String)execute.body());
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5b98\u7f51\u77ed\u4fe1\u5931\u8d25", (Throwable)e);
        }
        if (object == null || Objects.equals(500, object.getIntValue("code"))) {
            throw new LoginException(MsgCode.LOG105.get());
        }
        if (!Objects.equals(200, object.getIntValue("code"))) {
            throw new LoginException(MsgCode.LOG117.get(object.getString("msg")));
        }
        return true;
    }

    static {
        absentPermittionApi = false;
    }
}

