/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.model;

import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.model.OnlineUserModel;
import jakarta.websocket.Session;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class OnlineUserProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineUserProvider.class);
    private static CopyOnWriteArraySet<OnlineUserModel> onlineUserList = new CopyOnWriteArraySet();

    public static CopyOnWriteArraySet<OnlineUserModel> getOnlineUserList() {
        return onlineUserList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addModel(OnlineUserModel model) {
        CopyOnWriteArraySet<OnlineUserModel> copyOnWriteArraySet = onlineUserList;
        synchronized (copyOnWriteArraySet) {
            onlineUserList.add(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeModel(OnlineUserModel onlineUserModel) {
        CopyOnWriteArraySet<OnlineUserModel> copyOnWriteArraySet = onlineUserList;
        synchronized (copyOnWriteArraySet) {
            onlineUserList.remove(onlineUserModel);
        }
    }

    public static void removeWebSocketByToken(String ... token) {
        List tokens = Arrays.stream(token).map(t -> t.contains("bearer") ? t : "bearer " + t).collect(Collectors.toList());
        List users = OnlineUserProvider.getOnlineUserList().stream().filter(t -> tokens.contains(t.getToken())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(users)) {
            for (OnlineUserModel user : users) {
                OnlineUserProvider.logoutWS(user, null);
                OnlineUserProvider.removeModel(user);
            }
        }
    }

    public static void removeWebSocketByUser(String userId) {
        List tokens = StpUtil.getTokenValueListByLoginId((Object)UserProvider.splicingLoginId(userId));
        OnlineUserProvider.removeWebSocketByToken(tokens.toArray(new String[tokens.size()]));
    }

    public static void logoutWS(OnlineUserModel onlineUserModel, Session session) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"logout");
        obj.put("token", (Object)onlineUserModel.getToken());
        if (onlineUserModel != null) {
            OnlineUserProvider.sendMessage(onlineUserModel, (Object)obj);
        } else {
            OnlineUserProvider.sendMessage(session, (Object)obj);
        }
    }

    public static void closeFrontWs(OnlineUserModel onlineUserModel, Session session) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"closeSocket");
        if (onlineUserModel != null) {
            OnlineUserProvider.sendMessage(onlineUserModel, (Object)obj);
        } else {
            OnlineUserProvider.sendMessage(session, (Object)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(OnlineUserModel onlineUserModel, Object message) {
        Session session;
        Session session2 = session = onlineUserModel.getWebSocket();
        synchronized (session2) {
            block11: {
                try {
                    if (session.isOpen()) {
                        session.getAsyncRemote().sendText(JSONObject.toJSONString((Object)message));
                        break block11;
                    }
                    log.debug("WS\u672a\u6253\u5f00: {}, {}, {}, {}, {}", new Object[]{onlineUserModel.getTenantId(), session.getId(), onlineUserModel.getUserId(), onlineUserModel.getToken(), message});
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        OnlineUserProvider.removeModel(onlineUserModel);
                    }
                }
                catch (Exception e) {
                    log.debug(String.format("WS\u6d88\u606f\u53d1\u9001\u5931\u8d25: %s, %s, %s, %s, %s", onlineUserModel.getTenantId(), session.getId(), onlineUserModel.getUserId(), onlineUserModel.getToken(), message), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(Session session, Object message) {
        OnlineUserModel onlineUserModel = OnlineUserProvider.getOnlineUserList().stream().filter(t -> t.getConnectionId().equals(session.getId())).findFirst().orElse(null);
        if (onlineUserModel == null) {
            onlineUserModel = new OnlineUserModel();
            onlineUserModel.setWebSocket(session);
        }
        Session session2 = session;
        synchronized (session2) {
            OnlineUserProvider.sendMessage(onlineUserModel, message);
        }
    }
}

