/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.wrapper;

import cn.dev33.satoken.context.SaHolder;
import cn.hutool.core.net.url.UrlQuery;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.constant.GlobalConst;
import com.bringspring.common.security.handler.IRestHandler;
import com.bringspring.common.util.StringUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class MyRequestWrapper
extends HttpServletRequestWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyRequestWrapper.class);
    protected Map<String, String[]> paramHashValues;
    protected String requestBody = null;
    protected HttpServletRequest req;
    private final List<IRestHandler> handlers;
    private final String[] EMPTY_ARRAY = new String[0];
    private boolean supportHeader;
    private boolean supportBody;
    private boolean supportParameter;

    public MyRequestWrapper(HttpServletRequest request, List<IRestHandler> handlers) throws IOException {
        super(request);
        this.req = request;
        List<Object> list = this.handlers = handlers == null ? Collections.emptyList() : handlers;
        if (!handlers.isEmpty()) {
            try {
                if (this.isJsonBodyRequest()) {
                    if (this.handlers.stream().anyMatch(IRestHandler::supportBodyJson)) {
                        this.processBody();
                    }
                } else if (this.isParameterRequest()) {
                    if (this.handlers.stream().anyMatch(IRestHandler::supportParameter)) {
                        this.processParameter();
                    }
                    if (this.handlers.stream().anyMatch(IRestHandler::supportBodyJson)) {
                        this.processFormBody();
                    }
                }
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)SaHolder.getRequest().getRequestPath());
                throw e;
            }
        }
    }

    public void wrapperRequestData() throws IOException {
        try {
            if (this.isJsonBodyRequest()) {
                this.processBody();
            } else if (this.isParameterRequest()) {
                this.processParameter();
                this.processFormBody();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)SaHolder.getRequest().getRequestPath());
            throw e;
        }
    }

    private void processBody() throws IOException {
        List bodyHandlers = this.handlers.stream().filter(IRestHandler::supportBodyJson).collect(Collectors.toList());
        this.requestBody = this.convertInputStreamToString((InputStream)this.req.getInputStream());
        if (StringUtils.isNotEmpty(this.requestBody)) {
            JSON jsonData = (JSON)JSON.parse((String)this.requestBody);
            for (IRestHandler bodyHandler : bodyHandlers) {
                jsonData = bodyHandler.initBodyJson(jsonData);
            }
            this.requestBody = jsonData.toJSONString();
            this.supportBody = true;
        }
    }

    private void processParameter() {
        List<IRestHandler> parameterHandlers = this.handlers.stream().filter(IRestHandler::supportParameter).collect(Collectors.toList());
        this.paramHashValues = new HashMap<String, String[]>();
        this.paramHashValues.putAll(this.req.getParameterMap());
        parameterHandlers.forEach(h -> {
            this.paramHashValues = h.initParameter(this.paramHashValues);
        });
        this.supportParameter = true;
    }

    private void processFormBody() throws IOException {
        List bodyHandlers = this.handlers.stream().filter(IRestHandler::supportBodyJson).collect(Collectors.toList());
        this.requestBody = this.convertInputStreamToString((InputStream)this.req.getInputStream());
        if (StringUtils.isNotEmpty(this.requestBody)) {
            Map uriToListToMap = new UrlQuery().parse(this.requestBody, GlobalConst.DEFAULT_CHARSET).getQueryMap();
            this.requestBody = JSONObject.toJSONString((Object)uriToListToMap);
        }
        if (StringUtils.isNotEmpty(this.requestBody)) {
            JSON jsonData = (JSON)JSON.parse((String)this.requestBody);
            for (IRestHandler bodyHandler : bodyHandlers) {
                jsonData = bodyHandler.initBodyJson(jsonData);
            }
            JSONObject formJson = (JSONObject)jsonData;
            UrlQuery urlQuery = new UrlQuery();
            for (Map.Entry entry : formJson.entrySet()) {
                urlQuery.add((CharSequence)entry.getKey(), entry.getValue());
            }
            this.requestBody = urlQuery.build(GlobalConst.DEFAULT_CHARSET);
            this.supportBody = true;
        }
    }

    public BufferedReader getReader() throws IOException {
        if (this.supportBody) {
            return new BufferedReader(new StringReader(this.requestBody));
        }
        return super.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.supportBody) {
            return new ServletInputStream(){
                private InputStream in;
                {
                    this.in = new ByteArrayInputStream(MyRequestWrapper.this.requestBody.getBytes(MyRequestWrapper.this.req.getCharacterEncoding()));
                }

                public int read() throws IOException {
                    return this.in.read();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
        }
        return super.getInputStream();
    }

    public Map<String, String[]> getParameterMap() {
        if (this.supportParameter) {
            return this.paramHashValues;
        }
        return super.getParameterMap();
    }

    public String getParameter(String name) {
        if (this.supportParameter) {
            String[] parameter = this.paramHashValues.getOrDefault(name, this.EMPTY_ARRAY);
            return parameter.length == 0 ? null : parameter[0];
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        if (this.supportParameter) {
            return this.paramHashValues.get(name);
        }
        return super.getParameterValues(name);
    }

    public Enumeration<String> getParameterNames() {
        if (this.supportParameter) {
            return Collections.enumeration(this.paramHashValues.keySet());
        }
        return super.getParameterNames();
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null && this.paramHashValues != null) {
            if (value instanceof String[]) {
                this.paramHashValues.put(name, (String[])value);
            } else if (value instanceof String) {
                this.paramHashValues.put(name, new String[]{(String)value});
            } else {
                this.paramHashValues.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    protected boolean isParameterRequest() {
        String contentType = this.req.getContentType();
        return StringUtils.isNotEmpty(contentType) && org.springframework.util.StringUtils.substringMatch((CharSequence)contentType, (int)0, (CharSequence)"application/x-www-form-urlencoded");
    }

    protected boolean isJsonBodyRequest() {
        String contentType = this.req.getContentType();
        return StringUtils.isNotEmpty(contentType) && org.springframework.util.StringUtils.substringMatch((CharSequence)contentType, (int)0, (CharSequence)"application/json");
    }

    protected String convertInputStreamToString(InputStream inputStream) throws IOException {
        return StreamUtils.copyToString((InputStream)inputStream, (Charset)GlobalConst.DEFAULT_CHARSET);
    }

    @Generated
    public String getRequestBody() {
        return this.requestBody;
    }

    @Generated
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }
}

